/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.BuffedItems.menu.set;

import io.github.altkat.BuffedItems.BuffedItems;
import io.github.altkat.BuffedItems.menu.base.Menu;
import io.github.altkat.BuffedItems.menu.passive.EffectListMenu;
import io.github.altkat.BuffedItems.menu.set.SetBonusesMenu;
import io.github.altkat.BuffedItems.menu.utility.PlayerMenuUtility;
import org.bukkit.Material;
import org.bukkit.event.inventory.InventoryClickEvent;

public class SetBonusEffectSelectorMenu
extends Menu {
    private final BuffedItems plugin;
    private final String setId;
    private final int count;

    public SetBonusEffectSelectorMenu(PlayerMenuUtility playerMenuUtility, BuffedItems plugin) {
        super(playerMenuUtility);
        this.plugin = plugin;
        this.setId = playerMenuUtility.getTempSetId();
        this.count = playerMenuUtility.getTempBonusCount();
    }

    @Override
    public String getMenuName() {
        return "Bonus Effects: " + this.setId + " (" + this.count + ")";
    }

    @Override
    public int getSlots() {
        return 27;
    }

    @Override
    public void handleMenu(InventoryClickEvent e) {
        if (e.getCurrentItem() == null) {
            return;
        }
        if (e.getCurrentItem().getType() == Material.BARRIER) {
            new SetBonusesMenu(this.playerMenuUtility, this.plugin).open();
            return;
        }
        if (e.getCurrentItem().getType() == Material.POTION) {
            new EffectListMenu(this.playerMenuUtility, this.plugin, EffectListMenu.EffectType.POTION_EFFECT, "SET_BONUS").open();
        } else if (e.getCurrentItem().getType() == Material.IRON_SWORD) {
            new EffectListMenu(this.playerMenuUtility, this.plugin, EffectListMenu.EffectType.ATTRIBUTE, "SET_BONUS").open();
        }
    }

    @Override
    public void setMenuItems() {
        this.setFillerGlass();
        this.inventory.setItem(11, this.makeItem(Material.POTION, "\u00a7aPotion Effects", "\u00a77Add effects like Speed, Strength, etc.", "\u00a77to this set bonus tier.", "", "\u00a7eClick to Edit"));
        this.inventory.setItem(15, this.makeItem(Material.IRON_SWORD, "\u00a7bAttributes", "\u00a77Add stats like Max Health, Damage, etc.", "\u00a77to this set bonus tier.", "", "\u00a7eClick to Edit"));
        this.inventory.setItem(22, this.makeItem(Material.BARRIER, "\u00a7cBack", new String[0]));
    }
}

