/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.BuffedItems.menu.selector;

import io.github.altkat.BuffedItems.BuffedItems;
import io.github.altkat.BuffedItems.manager.config.ConfigManager;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;

public class EnchantmentFinder {
    public static Enchantment findEnchantment(String enchantKey, BuffedItems plugin) {
        Enchantment enchant;
        if (enchantKey == null || enchantKey.isEmpty()) {
            return null;
        }
        String key = enchantKey.toLowerCase().trim();
        try {
            enchant = Enchantment.getByKey((NamespacedKey)NamespacedKey.fromString((String)key));
            if (enchant != null) {
                ConfigManager.sendDebugMessage(3, () -> "[EnchantmentFinder] Found enchantment via NamespacedKey.fromString(): " + key);
                return enchant;
            }
        }
        catch (Exception e) {
            ConfigManager.sendDebugMessage(4, () -> "[EnchantmentFinder] NamespacedKey.fromString() failed for: " + key);
        }
        if (key.contains(":")) {
            String[] parts = key.split(":", 2);
            String namespace = parts[0];
            String name = parts[1];
            try {
                NamespacedKey nsKey = new NamespacedKey(namespace, name);
                Enchantment enchant2 = Enchantment.getByKey((NamespacedKey)nsKey);
                if (enchant2 != null) {
                    ConfigManager.sendDebugMessage(3, () -> "[EnchantmentFinder] Found enchantment via custom NamespacedKey: " + namespace + ":" + name);
                    return enchant2;
                }
            }
            catch (Exception e) {
                ConfigManager.sendDebugMessage(4, () -> "[EnchantmentFinder] Custom NamespacedKey failed for: " + namespace + ":" + name);
            }
        }
        if (!key.startsWith("minecraft:")) {
            try {
                NamespacedKey minecraftKey = NamespacedKey.minecraft((String)key);
                Enchantment enchant3 = Enchantment.getByKey((NamespacedKey)minecraftKey);
                if (enchant3 != null) {
                    ConfigManager.sendDebugMessage(3, () -> "[EnchantmentFinder] Found vanilla enchantment: minecraft:" + key);
                    return enchant3;
                }
            }
            catch (Exception e) {
                ConfigManager.sendDebugMessage(4, () -> "[EnchantmentFinder] Vanilla NamespacedKey failed for: " + key);
            }
        }
        try {
            enchant = Enchantment.getByName((String)key.toUpperCase());
            if (enchant != null) {
                ConfigManager.sendDebugMessage(3, () -> "[EnchantmentFinder] Found enchantment via getByName(): " + key.toUpperCase());
                return enchant;
            }
        }
        catch (Exception e) {
            ConfigManager.sendDebugMessage(4, () -> "[EnchantmentFinder] getByName() failed for: " + key.toUpperCase());
        }
        try {
            String searchName = key.contains(":") ? key.split(":", 2)[1].toUpperCase() : key.toUpperCase();
            for (Enchantment enchant2 : Enchantment.values()) {
                String[] keyParts;
                String lastPart;
                if (enchant2 == null) continue;
                if (enchant2.getName().toUpperCase().equals(searchName)) {
                    ConfigManager.sendDebugMessage(3, () -> "[EnchantmentFinder] Found enchantment via getName() comparison: " + searchName);
                    return enchant2;
                }
                String keyPart = enchant2.getKey().getKey().toUpperCase();
                if (keyPart.equals(searchName)) {
                    ConfigManager.sendDebugMessage(3, () -> "[EnchantmentFinder] Found enchantment via key comparison: " + searchName);
                    return enchant2;
                }
                if (!keyPart.contains("_") || !(lastPart = (keyParts = keyPart.split("_"))[keyParts.length - 1]).equals(searchName)) continue;
                ConfigManager.sendDebugMessage(3, () -> "[EnchantmentFinder] Found enchantment via partial key match: " + searchName);
                return enchant2;
            }
        }
        catch (Exception e) {
            ConfigManager.sendDebugMessage(1, () -> "[EnchantmentFinder] Name search failed: " + e.getMessage());
        }
        try {
            for (Enchantment enchant4 : Enchantment.values()) {
                String enchantFullKey;
                String enchantFullKeyLower;
                if (enchant4 == null || !(enchantFullKeyLower = (enchantFullKey = enchant4.getKey().getKey()).toLowerCase()).contains(key)) continue;
                ConfigManager.sendDebugMessage(3, () -> "[EnchantmentFinder] Found enchantment via substring match: " + enchantFullKey + " matches " + key);
                return enchant4;
            }
        }
        catch (Exception e) {
            ConfigManager.sendDebugMessage(4, () -> "[EnchantmentFinder] Substring search failed: " + e.getMessage());
        }
        ConfigManager.sendDebugMessage(1, () -> "[EnchantmentFinder] Could not find enchantment: " + enchantKey + " - Available enchantments: " + EnchantmentFinder.getAvailableEnchantments());
        return null;
    }

    private static String getAvailableEnchantments() {
        StringBuilder sb = new StringBuilder();
        int count = 0;
        for (Enchantment e : Enchantment.values()) {
            if (e == null) continue;
            if (count > 0) {
                sb.append(", ");
            }
            sb.append(e.getKey().getKey());
            if (++count < 5) continue;
            sb.append("... (and ").append(Enchantment.values().length - 5).append(" more)");
            break;
        }
        return sb.toString();
    }
}

