/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.BuffedItems.menu.crafting;

import io.github.altkat.BuffedItems.BuffedItems;
import io.github.altkat.BuffedItems.manager.config.ConfigManager;
import io.github.altkat.BuffedItems.manager.config.RecipesConfig;
import io.github.altkat.BuffedItems.manager.crafting.CustomRecipe;
import io.github.altkat.BuffedItems.menu.base.PaginatedMenu;
import io.github.altkat.BuffedItems.menu.crafting.RecipeEditorMenu;
import io.github.altkat.BuffedItems.menu.utility.MainMenu;
import io.github.altkat.BuffedItems.menu.utility.PlayerMenuUtility;
import io.github.altkat.BuffedItems.utility.item.BuffedItem;
import io.github.altkat.BuffedItems.utility.item.ItemBuilder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class RecipeListMenu
extends PaginatedMenu {
    private final BuffedItems plugin;

    public RecipeListMenu(PlayerMenuUtility playerMenuUtility, BuffedItems plugin) {
        super(playerMenuUtility);
        this.plugin = plugin;
        this.maxItemsPerPage = 36;
    }

    @Override
    public String getMenuName() {
        return "Crafting Recipes";
    }

    @Override
    public int getSlots() {
        return 54;
    }

    @Override
    public void handleMenu(InventoryClickEvent e) {
        Player p = (Player)e.getWhoClicked();
        List<CustomRecipe> recipes = this.getSortedRecipes();
        if (e.getCurrentItem() == null) {
            return;
        }
        if (this.handlePageChange(e, recipes.size())) {
            return;
        }
        if (e.getSlot() == 49) {
            this.playerMenuUtility.setWaitingForChatInput(true);
            this.playerMenuUtility.setChatInputPath("create_recipe");
            p.closeInventory();
            p.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aEnter a unique ID for the new recipe (e.g. 'magic_wand_craft')."));
            return;
        }
        if (e.getSlot() == 45) {
            boolean current = RecipesConfig.get().getBoolean("settings.register-to-book", true);
            RecipesConfig.get().set("settings.register-to-book", (Object)(!current ? 1 : 0));
            RecipesConfig.save();
            this.plugin.getCraftingManager().loadRecipes(true);
            p.playSound(p.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
            this.open();
            return;
        }
        if (e.getSlot() == 53) {
            new MainMenu(this.playerMenuUtility, this.plugin).open();
            return;
        }
        if (e.getSlot() >= 9 && e.getSlot() < 45) {
            int index = this.maxItemsPerPage * this.page + (e.getSlot() - 9);
            if (index >= recipes.size()) {
                return;
            }
            CustomRecipe recipe = recipes.get(index);
            if (e.getClick() == ClickType.LEFT) {
                this.playerMenuUtility.setRecipeToEditId(recipe.getId());
                new RecipeEditorMenu(this.playerMenuUtility, this.plugin).open();
            } else if (e.getClick() == ClickType.RIGHT) {
                RecipesConfig.get().set("recipes." + recipe.getId(), null);
                RecipesConfig.save();
                this.plugin.getCraftingManager().loadRecipes(true);
                p.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cRecipe '" + recipe.getId() + "' deleted."));
                this.open();
            }
        }
    }

    @Override
    public void setMenuItems() {
        int index;
        int i;
        ItemStack filler = this.makeItem(Material.BLACK_STAINED_GLASS_PANE, " ", new String[0]);
        for (i = 0; i < 9; ++i) {
            this.inventory.setItem(i, filler);
        }
        for (i = 45; i < 54; ++i) {
            this.inventory.setItem(i, filler);
        }
        this.addMenuControls();
        boolean isEnabled = RecipesConfig.get().getBoolean("settings.register-to-book", true);
        String status = isEnabled ? "\u00a7aEnabled" : "\u00a7cDisabled";
        Material toggleIcon = isEnabled ? Material.KNOWLEDGE_BOOK : Material.BOOK;
        this.inventory.setItem(45, this.makeItem(toggleIcon, "\u00a76Recipe Book Registration", "\u00a77Determines if custom recipes are", "\u00a77added to the vanilla Recipe Book.", "", "\u00a77Current: " + status, "", "\u00a7eClick to Toggle"));
        this.inventory.setItem(49, this.makeItem(Material.ANVIL, "\u00a7aCreate New Recipe", "\u00a77Click to create a new crafting recipe."));
        this.inventory.setItem(53, this.makeItem(Material.BARRIER, "\u00a7cBack to Main Menu", new String[0]));
        List<CustomRecipe> recipes = this.getSortedRecipes();
        for (int i2 = 0; i2 < this.maxItemsPerPage && (index = this.maxItemsPerPage * this.page + i2) < recipes.size(); ++i2) {
            ItemStack icon;
            CustomRecipe recipe = recipes.get(index);
            boolean isItemValid = false;
            if (recipe.isValid()) {
                BuffedItem item = this.plugin.getItemManager().getBuffedItem(recipe.getResultItemId());
                if (item != null) {
                    icon = new ItemBuilder(item, (Plugin)this.plugin).build();
                    isItemValid = true;
                } else {
                    icon = this.makeItem(Material.BEDROCK, "\u00a7cUnknown Item", "\u00a77ID: " + recipe.getResultItemId());
                }
            } else {
                icon = new ItemStack(Material.BARRIER);
            }
            ItemMeta meta = icon.getItemMeta();
            if (meta != null) {
                if (!isItemValid) {
                    String name = recipe.isValid() ? "\u00a7cUnknown Item" : "\u00a7c" + recipe.getId();
                    meta.displayName(ConfigManager.fromSection(name));
                }
                ArrayList<Object> lore = new ArrayList<Object>();
                lore.add(Component.empty());
                lore.add(ConfigManager.fromSection("\u00a78ID: " + recipe.getId()));
                if (recipe.isValid()) {
                    String permission = RecipesConfig.get().getString("recipes." + recipe.getId() + ".permission");
                    lore.add(ConfigManager.fromSection("\u00a77Result: \u00a7f" + recipe.getResultItemId()));
                    lore.add(ConfigManager.fromSection("\u00a77Permission: \u00a7f" + (permission == null ? "None" : permission)));
                    lore.add(ConfigManager.fromSection("\u00a77Amount: \u00a7e" + recipe.getAmount()));
                } else {
                    lore.add(ConfigManager.fromSection("\u00a7c\u00a7lCONFIGURATION ERRORS:"));
                    for (String err : recipe.getErrorMessages()) {
                        lore.add(ConfigManager.fromSection("\u00a7c- " + err));
                    }
                }
                lore.add(Component.empty());
                lore.add(ConfigManager.fromSection("\u00a7eLeft-Click to Edit"));
                lore.add(ConfigManager.fromSection("\u00a7cRight-Click to Delete"));
                meta.lore(lore);
                icon.setItemMeta(meta);
            }
            icon.setAmount(1);
            this.inventory.setItem(9 + i2, icon);
        }
    }

    private List<CustomRecipe> getSortedRecipes() {
        ArrayList<CustomRecipe> list = new ArrayList<CustomRecipe>(this.plugin.getCraftingManager().getRecipes().values());
        list.sort(Comparator.comparing(CustomRecipe::getId));
        return list;
    }
}

