/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.BuffedItems.manager.cost.types;

import io.github.altkat.BuffedItems.manager.config.ConfigManager;
import io.github.altkat.BuffedItems.manager.cost.ICost;
import java.util.Map;
import org.bukkit.entity.Player;

public class LevelCost
implements ICost {
    private final int amount;
    private final String failureMessage;

    public LevelCost(Map<String, Object> data) {
        this.amount = ((Number)data.getOrDefault("amount", 1)).intValue();
        if (this.amount <= 0) {
            throw new IllegalArgumentException("Amount must be positive.");
        }
        String defaultMsg = ConfigManager.getDefaultCostMessage("LEVEL");
        this.failureMessage = (String)data.getOrDefault("message", defaultMsg);
    }

    @Override
    public String getDisplayString() {
        return this.amount + " XP Levels";
    }

    @Override
    public boolean hasEnough(Player player) {
        return player.getLevel() >= this.amount;
    }

    @Override
    public void deduct(Player player) {
        player.setLevel(Math.max(0, player.getLevel() - this.amount));
    }

    @Override
    public String getFailureMessage() {
        return ConfigManager.stripLegacy(this.failureMessage).replace("{amount}", String.valueOf(this.amount));
    }
}

