/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.BuffedItems.manager.cost.types;

import io.github.altkat.BuffedItems.manager.config.ConfigManager;
import io.github.altkat.BuffedItems.manager.cost.ICost;
import java.util.Map;
import org.bukkit.entity.Player;

public class HealthCost
implements ICost {
    private final double amount;
    private final String failureMessage;

    public HealthCost(Map<String, Object> data) {
        this.amount = ((Number)data.getOrDefault("amount", 2.0)).doubleValue();
        if (this.amount <= 0.0) {
            throw new IllegalArgumentException("Amount must be positive.");
        }
        String defaultMsg = ConfigManager.getDefaultCostMessage("HEALTH");
        this.failureMessage = (String)data.getOrDefault("message", defaultMsg);
    }

    @Override
    public boolean hasEnough(Player player) {
        return player.getHealth() > this.amount;
    }

    @Override
    public String getDisplayString() {
        return this.amount + " Health (Hearts)";
    }

    @Override
    public void deduct(Player player) {
        double newHealth = player.getHealth() - this.amount;
        if (newHealth < 0.0) {
            newHealth = 0.0;
        }
        player.setHealth(newHealth);
    }

    @Override
    public String getFailureMessage() {
        return ConfigManager.stripLegacy(this.failureMessage).replace("{amount}", String.valueOf(this.amount));
    }
}

