/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.BuffedItems.manager.attribute;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;

public class ActiveAttributeManager {
    private final Map<UUID, Map<Attribute, List<AttributeModifier>>> activePlayerModifiers = new ConcurrentHashMap<UUID, Map<Attribute, List<AttributeModifier>>>();

    public void addModifier(UUID playerUUID, Attribute attribute, AttributeModifier modifier) {
        this.activePlayerModifiers.computeIfAbsent(playerUUID, k -> new ConcurrentHashMap()).computeIfAbsent(attribute, k -> new ArrayList()).add(modifier);
    }

    public Map<Attribute, List<AttributeModifier>> getActiveModifiers(UUID playerUUID) {
        return this.activePlayerModifiers.getOrDefault(playerUUID, Collections.emptyMap());
    }

    public Map<Attribute, List<AttributeModifier>> getAndClearModifiers(UUID playerUUID) {
        return this.activePlayerModifiers.remove(playerUUID);
    }

    public void clearPlayer(UUID playerUUID) {
        this.activePlayerModifiers.remove(playerUUID);
    }

    public boolean removeModifier(UUID playerUUID, Attribute attribute, UUID modifierUUID) {
        List<AttributeModifier> attributeList;
        Map<Attribute, List<AttributeModifier>> playerMap = this.activePlayerModifiers.get(playerUUID);
        if (playerMap != null && (attributeList = playerMap.get(attribute)) != null) {
            boolean removed = attributeList.removeIf(mod -> mod.getUniqueId().equals(modifierUUID));
            if (attributeList.isEmpty()) {
                playerMap.remove(attribute);
                if (playerMap.isEmpty()) {
                    this.activePlayerModifiers.remove(playerUUID);
                }
            }
            return removed;
        }
        return false;
    }

    public boolean hasModifier(UUID playerUUID, Attribute attribute, UUID modifierUUID) {
        List<AttributeModifier> attributeList;
        Map<Attribute, List<AttributeModifier>> playerMap = this.activePlayerModifiers.get(playerUUID);
        if (playerMap != null && (attributeList = playerMap.get(attribute)) != null) {
            return attributeList.stream().anyMatch(mod -> mod.getUniqueId().equals(modifierUUID));
        }
        return false;
    }
}

