/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.BuffedItems.listener.handler;

import io.github.altkat.BuffedItems.BuffedItems;
import io.github.altkat.BuffedItems.listener.handler.ChatInputHandler;
import io.github.altkat.BuffedItems.manager.config.ConfigManager;
import io.github.altkat.BuffedItems.manager.config.ItemsConfig;
import io.github.altkat.BuffedItems.menu.active.ActiveItemSettingsMenu;
import io.github.altkat.BuffedItems.menu.active.ActiveItemVisualsMenu;
import io.github.altkat.BuffedItems.menu.active.CommandListMenu;
import io.github.altkat.BuffedItems.menu.active.UsageLimitSettingsMenu;
import io.github.altkat.BuffedItems.menu.utility.PlayerMenuUtility;
import io.github.altkat.BuffedItems.menu.utility.SoundSettingsMenu;
import java.util.ArrayList;
import org.bukkit.Sound;
import org.bukkit.entity.Player;

public class ActiveSettingsInputHandler
implements ChatInputHandler {
    private final BuffedItems plugin;

    public ActiveSettingsInputHandler(BuffedItems plugin) {
        this.plugin = plugin;
    }

    @Override
    public void handle(Player player, PlayerMenuUtility pmu, String input, String path, String itemId) {
        if (path.equals("active.cooldown")) {
            this.handleActiveCooldownEdit(player, pmu, input, itemId);
        } else if (path.equals("active.duration")) {
            this.handleActiveDurationEdit(player, pmu, input, itemId);
        } else if (path.equals("active.commands.add")) {
            this.handleAddCommand(player, pmu, input, itemId);
        } else if (path.startsWith("active.commands.edit.")) {
            this.handleEditCommand(player, pmu, input, path, itemId);
        } else if (path.startsWith("active.msg.")) {
            this.handleActiveMessageEdit(player, pmu, input, path, itemId);
        } else if (path.startsWith("active.sounds.")) {
            this.handleActiveSoundEdit(player, pmu, input, path, itemId);
        } else if (path.startsWith("usage-limit.")) {
            this.handleUsageLimitEdit(player, pmu, input, path, itemId);
        }
    }

    private void handleActiveCooldownEdit(Player player, PlayerMenuUtility pmu, String input, String itemId) {
        try {
            int val = Integer.parseInt(input);
            if (val < 0) {
                throw new NumberFormatException();
            }
            ConfigManager.setItemValue(itemId, "cooldown", val);
            player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aCooldown updated to: \u00a7e" + val + "s"));
            this.closeChatInput(pmu);
            new ActiveItemSettingsMenu(pmu, this.plugin).open();
        }
        catch (NumberFormatException error) {
            player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cInvalid number! Please enter a positive integer (e.g. 10)."));
            player.sendMessage(ConfigManager.fromSection("\u00a77(Type 'cancel' to exit)"));
        }
    }

    private void handleActiveDurationEdit(Player player, PlayerMenuUtility pmu, String input, String itemId) {
        try {
            int val = Integer.parseInt(input);
            if (val < 0) {
                throw new NumberFormatException();
            }
            ConfigManager.setItemValue(itemId, "effect_duration", val);
            player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aEffect Duration updated to: \u00a7e" + val + "s"));
            this.closeChatInput(pmu);
            new ActiveItemSettingsMenu(pmu, this.plugin).open();
        }
        catch (NumberFormatException error) {
            player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cInvalid number! Please enter a positive integer (e.g. 5)."));
            player.sendMessage(ConfigManager.fromSection("\u00a77(Type 'cancel' to exit)"));
        }
    }

    private void handleAddCommand(Player player, PlayerMenuUtility pmu, String input, String itemId) {
        ArrayList<String> commands = new ArrayList<String>(ItemsConfig.get().getStringList("items." + itemId + ".active-mode.commands"));
        if (commands.isEmpty() && input.trim().toLowerCase().startsWith("[else]")) {
            player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cError: The VERY FIRST command cannot start with [else]!"));
            player.sendMessage(ConfigManager.fromSection("\u00a77Logic requires a preceding command to fail first."));
            player.sendMessage(ConfigManager.fromSection("\u00a7ePlease enter the command again without [else]."));
            return;
        }
        commands.add(input);
        ConfigManager.setItemValue(itemId, "commands", commands);
        player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aCommand added!"));
        this.closeChatInput(pmu);
        new CommandListMenu(pmu, this.plugin, CommandListMenu.CommandContext.ACTIVE).open();
    }

    private void handleEditCommand(Player player, PlayerMenuUtility pmu, String input, String path, String itemId) {
        try {
            int index = Integer.parseInt(path.substring(21));
            ArrayList<String> commands = new ArrayList<String>(ItemsConfig.get().getStringList("items." + itemId + ".active-mode.commands"));
            if (index >= 0 && index < commands.size()) {
                commands.set(index, input);
                ConfigManager.setItemValue(itemId, "commands", commands);
                player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aCommand updated!"));
            } else {
                player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cError: Command index out of bounds."));
            }
            this.closeChatInput(pmu);
            new CommandListMenu(pmu, this.plugin, CommandListMenu.CommandContext.ACTIVE).open();
        }
        catch (Exception error) {
            player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cError processing edit."));
            this.closeChatInput(pmu);
            new CommandListMenu(pmu, this.plugin, CommandListMenu.CommandContext.ACTIVE).open();
        }
    }

    private void handleActiveMessageEdit(Player player, PlayerMenuUtility pmu, String input, String path, String itemId) {
        String messageType = path.substring(11);
        String configPath = this.getMessageConfigPath(messageType);
        if (configPath == null) {
            player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cError: Unknown message type: " + messageType));
            this.closeChatInput(pmu);
            new ActiveItemVisualsMenu(pmu, this.plugin).open();
            return;
        }
        if ("default".equalsIgnoreCase(input)) {
            if ("title".equals(messageType)) {
                ConfigManager.setItemValue(itemId, "visuals.messages.subtitle", null);
            }
            ConfigManager.setItemValue(itemId, configPath, null);
            player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aReset to default."));
        } else if ("title".equals(messageType) && input.contains("|")) {
            String[] parts = input.split("\\|", 2);
            ConfigManager.setItemValue(itemId, configPath, parts[0].trim());
            ConfigManager.setItemValue(itemId, "visuals.messages.subtitle", parts[1].trim());
            player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aTitle and Subtitle updated!"));
        } else {
            ConfigManager.setItemValue(itemId, configPath, input);
            player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aMessage updated!"));
        }
        this.closeChatInput(pmu);
        new ActiveItemVisualsMenu(pmu, this.plugin).open();
    }

    private void handleActiveSoundEdit(Player player, PlayerMenuUtility pmu, String input, String path, String itemId) {
        String soundType = path.substring(14);
        if (!this.isValidSoundFormat(input)) {
            player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cInvalid format! Use: NAME;VOLUME;PITCH"));
            player.sendMessage(ConfigManager.fromSection("\u00a77(Type 'cancel' to exit)"));
            pmu.setWaitingForChatInput(true);
            pmu.setChatInputPath("active.sounds." + soundType);
            return;
        }
        ConfigManager.setItemValue(itemId, "sounds." + soundType, input);
        player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aSound updated!"));
        try {
            String soundName = input.split(";")[0];
            Sound sound = Sound.valueOf((String)soundName.toUpperCase());
            player.playSound(player.getLocation(), sound, 1.0f, 1.0f);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.closeChatInput(pmu);
        new SoundSettingsMenu(pmu, this.plugin, soundType).open();
    }

    private void handleUsageLimitEdit(Player player, PlayerMenuUtility pmu, String input, String path, String itemId) {
        if (path.equals("usage-limit.commands.add")) {
            ArrayList<String> commands = new ArrayList<String>(ItemsConfig.get().getStringList("items." + itemId + ".active-mode.usage-limit.commands"));
            commands.add(input);
            ConfigManager.setItemValue(itemId, "usage-limit.commands", commands);
            player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aDepletion command added!"));
            this.closeChatInput(pmu);
            new CommandListMenu(pmu, this.plugin, CommandListMenu.CommandContext.DEPLETION).open();
            return;
        }
        if (path.startsWith("usage-limit.commands.edit.")) {
            try {
                int index = Integer.parseInt(path.substring(26));
                ArrayList<String> commands = new ArrayList<String>(ItemsConfig.get().getStringList("items." + itemId + ".active-mode.usage-limit.commands"));
                if (index >= 0 && index < commands.size()) {
                    commands.set(index, input);
                    ConfigManager.setItemValue(itemId, "usage-limit.commands", commands);
                    player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aDepletion command updated!"));
                } else {
                    player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cError: Command index out of bounds."));
                }
                this.closeChatInput(pmu);
                new CommandListMenu(pmu, this.plugin, CommandListMenu.CommandContext.DEPLETION).open();
            }
            catch (Exception e) {
                player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cError processing edit."));
                this.closeChatInput(pmu);
                new CommandListMenu(pmu, this.plugin, CommandListMenu.CommandContext.DEPLETION).open();
            }
            return;
        }
        if (path.equals("usage-limit.max-usage")) {
            try {
                int val = Integer.parseInt(input);
                if (val < -1 || val == 0) {
                    throw new NumberFormatException();
                }
                ConfigManager.setItemValue(itemId, "usage-limit.max-usage", val);
                player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aMax Usage updated to: \u00a7e" + String.valueOf(val == -1 ? "Unlimited" : Integer.valueOf(val))));
            }
            catch (NumberFormatException e) {
                player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cInvalid number! Enter a positive integer or -1 for unlimited."));
            }
        } else if (path.equals("usage-limit.transform-item")) {
            if (this.plugin.getItemManager().getBuffedItem(input) == null) {
                player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7eWarning: Item ID '" + input + "' does not exist yet."));
            }
            ConfigManager.setItemValue(itemId, "usage-limit.transform-item", input);
            player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aTransform Target updated to: \u00a7e" + input));
        } else {
            ConfigManager.setItemValue(itemId, path, input);
            player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aMessage setting updated!"));
        }
        this.closeChatInput(pmu);
        new UsageLimitSettingsMenu(pmu, this.plugin).open();
    }

    private void closeChatInput(PlayerMenuUtility pmu) {
        pmu.setWaitingForChatInput(false);
        pmu.setChatInputPath(null);
    }

    private String getMessageConfigPath(String messageType) {
        return switch (messageType) {
            case "chat" -> "visuals.messages.cooldown-chat";
            case "title" -> "visuals.messages.cooldown-title";
            case "actionbar" -> "visuals.messages.cooldown-action-bar";
            case "bossbar" -> "visuals.messages.cooldown-boss-bar";
            default -> null;
        };
    }

    private boolean isValidSoundFormat(String input) {
        if (input.contains(";")) {
            String[] parts = input.split(";");
            try {
                if (parts.length > 1) {
                    Float.parseFloat(parts[1]);
                }
                if (parts.length > 2) {
                    Float.parseFloat(parts[2]);
                }
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return true;
    }
}

