/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.BuffedItems.listener;

import io.github.altkat.BuffedItems.BuffedItems;
import io.github.altkat.BuffedItems.manager.config.ConfigManager;
import java.util.HashSet;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.potion.PotionEffectType;

public class PlayerQuitListener
implements Listener {
    private final BuffedItems plugin;

    public PlayerQuitListener(BuffedItems plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        ConfigManager.sendDebugMessage(2, () -> "[Quit] Cleaning up player: " + player.getName());
        this.plugin.getEffectManager().clearAllAttributes(player);
        HashSet<PotionEffectType> effectsToClear = new HashSet<PotionEffectType>(this.plugin.getEffectApplicatorTask().getManagedEffects(player.getUniqueId()));
        int effectCount = effectsToClear.size();
        this.plugin.getEffectApplicatorTask().playerQuit(player);
        this.plugin.getActiveAttributeManager().clearPlayer(player.getUniqueId());
        this.plugin.getDeathKeptItems().remove(player.getUniqueId());
        BuffedItems.removePlayerMenuUtility(player.getUniqueId());
        this.plugin.getInventoryChangeListener().clearPlayerData(player.getUniqueId());
        try {
            if (player.isOnline()) {
                effectsToClear.forEach(arg_0 -> ((Player)player).removePotionEffect(arg_0));
            }
        }
        catch (Exception e) {
            ConfigManager.sendDebugMessage(1, () -> "[Quit] Error while removing potion effects for " + player.getName() + " (player likely already offline): " + e.getMessage());
        }
        ConfigManager.sendDebugMessage(2, () -> "[Quit] Cleanup complete for " + player.getName() + " (removed " + effectCount + " potion effects)");
    }
}

