/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.BuffedItems.listener;

import io.github.altkat.BuffedItems.BuffedItems;
import io.github.altkat.BuffedItems.hooks.HookManager;
import io.github.altkat.BuffedItems.manager.config.ConfigManager;
import io.github.altkat.BuffedItems.manager.cost.ICost;
import io.github.altkat.BuffedItems.utility.attribute.ParsedAttribute;
import io.github.altkat.BuffedItems.utility.item.BuffedItem;
import io.github.altkat.BuffedItems.utility.item.BuffedItemEffect;
import io.github.altkat.BuffedItems.utility.item.DepletionAction;
import io.github.altkat.BuffedItems.utility.item.ItemBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.title.Title;
import org.bukkit.Bukkit;
import org.bukkit.GameRule;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class ItemInteractListener
implements Listener {
    private final BuffedItems plugin;
    private final NamespacedKey nbtKey;
    private final HookManager hooks;

    public ItemInteractListener(BuffedItems plugin) {
        this.plugin = plugin;
        this.hooks = plugin.getHookManager();
        this.nbtKey = new NamespacedKey((Plugin)plugin, "buffeditem_id");
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerInteract(PlayerInteractEvent event) {
        String itemId;
        if (event.getAction() != Action.RIGHT_CLICK_AIR && event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack item = event.getItem();
        if (item == null || !item.hasItemMeta()) {
            return;
        }
        ItemStack updatedItem = this.plugin.getItemUpdater().updateItem(item, player);
        if (updatedItem != null && !updatedItem.isSimilar(item)) {
            if (event.getHand() == EquipmentSlot.HAND) {
                player.getInventory().setItemInMainHand(updatedItem);
            } else {
                player.getInventory().setItemInOffHand(updatedItem);
            }
            item = updatedItem;
            ConfigManager.sendDebugMessage(3, () -> "[LiveUpdate] Item updated in hand.");
        }
        if ((itemId = (String)item.getItemMeta().getPersistentDataContainer().get(this.nbtKey, PersistentDataType.STRING)) == null) {
            return;
        }
        BuffedItem buffedItem = this.plugin.getItemManager().getBuffedItem(itemId);
        if (buffedItem == null || !buffedItem.isActiveMode()) {
            return;
        }
        if (!buffedItem.hasActivePermission(player)) {
            String rawMsg = this.plugin.getConfig().getString("messages.protection-prevent-use-no-permission", "&cYou do not have permission to use this item.");
            String parsedMsg = this.hooks.processPlaceholders((OfflinePlayer)player, rawMsg);
            player.sendMessage(ConfigManager.fromLegacyWithPrefix(parsedMsg));
            return;
        }
        if (this.plugin.getCooldownManager().isOnCooldown(player, itemId)) {
            this.handleCooldownMessage(player, buffedItem);
            event.setCancelled(true);
            return;
        }
        NamespacedKey durabilityKey = new NamespacedKey((Plugin)this.plugin, "remaining_active_uses");
        Integer currentUses = null;
        if (item.getItemMeta().getPersistentDataContainer().has(durabilityKey, PersistentDataType.INTEGER) && (currentUses = (Integer)item.getItemMeta().getPersistentDataContainer().get(durabilityKey, PersistentDataType.INTEGER)) != null && currentUses <= 0) {
            event.setCancelled(true);
            String rawDepletedMsg = buffedItem.getDepletedMessage();
            String parsedDepletedMsg = this.hooks.processPlaceholders((OfflinePlayer)player, rawDepletedMsg);
            player.sendMessage(ConfigManager.fromLegacyWithPrefix(parsedDepletedMsg));
            this.playConfiguredSound(player, buffedItem.getCustomDepletedTrySound(), ConfigManager.getGlobalDepletedTrySound());
            return;
        }
        List<ICost> costs = buffedItem.getCosts();
        if (costs != null && !costs.isEmpty()) {
            ArrayList missingRequirements = new ArrayList();
            for (ICost cost : costs) {
                if (cost.hasEnough(player)) continue;
                missingRequirements.add(this.hooks.processPlaceholders((OfflinePlayer)player, cost.getFailureMessage()));
            }
            if (!missingRequirements.isEmpty()) {
                Iterator<ICost> iterator = missingRequirements.iterator();
                while (iterator.hasNext()) {
                    String msg = (String)((Object)iterator.next());
                    player.sendMessage(ConfigManager.fromLegacy(msg));
                }
                this.playConfiguredSound(player, buffedItem.getCustomCostFailSound(), ConfigManager.getGlobalCostFailSound());
                event.setCancelled(true);
                return;
            }
        }
        if (costs != null && !costs.isEmpty()) {
            for (ICost cost : costs) {
                cost.deduct(player);
            }
        }
        if (buffedItem.getCooldown() > 0) {
            this.plugin.getCooldownManager().setCooldown(player, itemId, buffedItem.getCooldown());
        }
        this.executeCommands(player, buffedItem.getActiveCommands());
        this.applyActiveEffects(player, buffedItem);
        this.playConfiguredSound(player, buffedItem.getCustomSuccessSound(), ConfigManager.getGlobalSuccessSound());
        if (currentUses != null && currentUses > 0) {
            int newUses = currentUses - 1;
            if (newUses == 0) {
                this.handleDepletion(player, buffedItem, item, event.getHand());
            } else if (item.getAmount() > 1) {
                item.setAmount(item.getAmount() - 1);
                ItemStack processedItem = item.clone();
                processedItem.setAmount(1);
                this.updateUsesNBT(processedItem, newUses, buffedItem, player);
                this.giveItemToPlayer(player, processedItem);
            } else {
                this.updateUsesNBT(item, newUses, buffedItem, player);
            }
        }
        event.setCancelled(true);
    }

    private void updateUsesNBT(ItemStack item, int uses, BuffedItem buffedItem, Player player) {
        ItemMeta meta = item.getItemMeta();
        NamespacedKey durabilityKey = new NamespacedKey((Plugin)this.plugin, "remaining_active_uses");
        meta.getPersistentDataContainer().set(durabilityKey, PersistentDataType.INTEGER, (Object)uses);
        item.setItemMeta(meta);
        ItemStack updated = this.plugin.getItemUpdater().updateItem(item, player);
        if (updated != null) {
            item.setItemMeta(updated.getItemMeta());
        }
    }

    private void handleDepletion(Player player, BuffedItem buffedItem, ItemStack originalItem, EquipmentSlot hand) {
        DepletionAction action;
        String rawDepleteMsg = buffedItem.getDepletionNotification();
        String parsedDepleteMsg = this.hooks.processPlaceholders((OfflinePlayer)player, rawDepleteMsg);
        player.sendMessage(ConfigManager.fromLegacyWithPrefix(parsedDepleteMsg));
        this.playConfiguredSound(player, buffedItem.getCustomDepletionSound(), ConfigManager.getGlobalDepletionSound());
        if (!buffedItem.getDepletionCommands().isEmpty()) {
            this.executeCommands(player, buffedItem.getDepletionCommands());
        }
        if ((action = buffedItem.getDepletionAction()) == DepletionAction.DESTROY) {
            if (originalItem.getAmount() > 1) {
                originalItem.setAmount(originalItem.getAmount() - 1);
            } else {
                originalItem.setAmount(0);
                if (hand == EquipmentSlot.HAND) {
                    player.getInventory().setItemInMainHand(null);
                } else {
                    player.getInventory().setItemInOffHand(null);
                }
            }
        } else if (action == DepletionAction.TRANSFORM) {
            if (originalItem.getAmount() > 1) {
                originalItem.setAmount(originalItem.getAmount() - 1);
                this.giveTransformedItem(player, buffedItem);
            } else {
                this.setTransformedItemInHand(player, buffedItem, hand);
            }
        } else if (originalItem.getAmount() > 1) {
            originalItem.setAmount(originalItem.getAmount() - 1);
            ItemStack disabledItem = originalItem.clone();
            disabledItem.setAmount(1);
            this.updateUsesNBT(disabledItem, 0, buffedItem, player);
            this.giveItemToPlayer(player, disabledItem);
        } else {
            this.updateUsesNBT(originalItem, 0, buffedItem, player);
        }
    }

    private void setTransformedItemInHand(Player player, BuffedItem buffedItem, EquipmentSlot hand) {
        String targetId = buffedItem.getDepletionTransformId();
        if (targetId == null) {
            if (hand == EquipmentSlot.HAND) {
                player.getInventory().setItemInMainHand(null);
            } else {
                player.getInventory().setItemInOffHand(null);
            }
            return;
        }
        BuffedItem targetItem = this.plugin.getItemManager().getBuffedItem(targetId);
        if (targetItem != null) {
            ItemStack resultItem = new ItemBuilder(targetItem, (Plugin)this.plugin).build();
            this.processMetaPlaceholders(player, resultItem);
            if (hand == EquipmentSlot.HAND) {
                player.getInventory().setItemInMainHand(resultItem);
            } else {
                player.getInventory().setItemInOffHand(resultItem);
            }
            player.sendMessage(ConfigManager.fromLegacyWithPrefix("&aItem transformed!"));
        } else {
            this.plugin.getLogger().warning("[BuffedItems] Transform failed. Target '" + targetId + "' not found.");
            if (hand == EquipmentSlot.HAND) {
                player.getInventory().setItemInMainHand(null);
            } else {
                player.getInventory().setItemInOffHand(null);
            }
        }
    }

    private void giveTransformedItem(Player player, BuffedItem buffedItem) {
        String targetId = buffedItem.getDepletionTransformId();
        if (targetId == null) {
            return;
        }
        BuffedItem targetItem = this.plugin.getItemManager().getBuffedItem(targetId);
        if (targetItem != null) {
            ItemStack resultItem = new ItemBuilder(targetItem, (Plugin)this.plugin).build();
            this.processMetaPlaceholders(player, resultItem);
            this.giveItemToPlayer(player, resultItem);
            player.sendMessage(ConfigManager.fromLegacyWithPrefix("&aItem transformed!"));
        }
    }

    private void processMetaPlaceholders(Player player, ItemStack item) {
        ItemMeta newMeta = item.getItemMeta();
        if (newMeta != null) {
            if (newMeta.hasDisplayName()) {
                String rawName = ConfigManager.toSection(newMeta.displayName());
                newMeta.displayName(ConfigManager.fromSection(this.hooks.processPlaceholders((OfflinePlayer)player, rawName)));
            }
            if (newMeta.hasLore()) {
                ArrayList<Component> parsedLore = new ArrayList<Component>();
                for (Component line : newMeta.lore()) {
                    String rawLine = ConfigManager.toSection(line);
                    parsedLore.add(ConfigManager.fromSection(this.hooks.processPlaceholders((OfflinePlayer)player, rawLine)));
                }
                newMeta.lore(parsedLore);
            }
            item.setItemMeta(newMeta);
        }
    }

    private void giveItemToPlayer(Player player, ItemStack item) {
        HashMap leftOver = player.getInventory().addItem(new ItemStack[]{item});
        if (!leftOver.isEmpty()) {
            player.getWorld().dropItemNaturally(player.getLocation(), (ItemStack)leftOver.get(0));
        }
    }

    private void handleCooldownMessage(Player player, BuffedItem buffedItem) {
        double remaining = this.plugin.getCooldownManager().getRemainingSeconds(player, buffedItem.getId());
        if (buffedItem.isVisualChat()) {
            String rawMsg = buffedItem.getCustomChatMsg();
            if (rawMsg == null) {
                rawMsg = this.plugin.getConfig().getString("active-items.messages.cooldown-chat", "&cWait {time}s");
            }
            String parsedMsg = this.hooks.processPlaceholders((OfflinePlayer)player, rawMsg.replace("{time}", String.format("%.1f", remaining)));
            player.sendMessage(ConfigManager.fromLegacy(parsedMsg));
        }
        if (buffedItem.isVisualTitle()) {
            String subtitle;
            String title = buffedItem.getCustomTitleMsg();
            if (title == null) {
                title = this.plugin.getConfig().getString("active-items.messages.cooldown-title", "");
            }
            if ((subtitle = buffedItem.getCustomSubtitleMsg()) == null) {
                subtitle = this.plugin.getConfig().getString("active-items.messages.cooldown-subtitle", "");
            }
            String finalTitle = this.hooks.processPlaceholders((OfflinePlayer)player, title.replace("{time}", String.format("%.1f", remaining)));
            String finalSubtitle = this.hooks.processPlaceholders((OfflinePlayer)player, subtitle.replace("{time}", String.format("%.1f", remaining)));
            player.showTitle(Title.title((Component)ConfigManager.fromLegacy(finalTitle), (Component)ConfigManager.fromLegacy(finalSubtitle)));
        }
        this.playConfiguredSound(player, buffedItem.getCustomCooldownSound(), ConfigManager.getGlobalCooldownSound());
    }

    private void executeCommands(Player player, List<String> commands) {
        if (commands == null || commands.isEmpty()) {
            return;
        }
        long cumulativeDelay = 0L;
        boolean lastChainFailed = false;
        for (String cmdLine : commands) {
            String cmdToProcess = cmdLine.trim();
            boolean isElseBlock = false;
            if (cmdToProcess.toLowerCase().startsWith("[else]")) {
                isElseBlock = true;
                cmdToProcess = cmdToProcess.substring(6).trim();
            }
            if (isElseBlock && !lastChainFailed) continue;
            if (!isElseBlock) {
                lastChainFailed = false;
            }
            long localDelay = 0L;
            double localChance = 100.0;
            boolean isConsole = false;
            boolean findingPrefixes = true;
            while (findingPrefixes) {
                findingPrefixes = false;
                String lowerCmd = cmdToProcess.toLowerCase();
                if (lowerCmd.startsWith("[delay:")) {
                    try {
                        int closeIndex = cmdToProcess.indexOf("]");
                        if (closeIndex == -1) continue;
                        localDelay += Long.parseLong(cmdToProcess.substring(7, closeIndex));
                        cmdToProcess = cmdToProcess.substring(closeIndex + 1).trim();
                        findingPrefixes = true;
                    }
                    catch (Exception closeIndex) {}
                    continue;
                }
                if (lowerCmd.startsWith("[chance:")) {
                    try {
                        int closeIndex = cmdToProcess.indexOf("]");
                        if (closeIndex == -1) continue;
                        localChance = Double.parseDouble(cmdToProcess.substring(8, closeIndex));
                        cmdToProcess = cmdToProcess.substring(closeIndex + 1).trim();
                        findingPrefixes = true;
                    }
                    catch (Exception closeIndex) {}
                    continue;
                }
                if (!lowerCmd.startsWith("[console]")) continue;
                isConsole = true;
                cmdToProcess = cmdToProcess.substring(9).trim();
                findingPrefixes = true;
            }
            if (localChance < 100.0 && ThreadLocalRandom.current().nextDouble(100.0) > localChance) {
                lastChainFailed = true;
                continue;
            }
            lastChainFailed = false;
            if (cmdToProcess.isEmpty()) continue;
            String finalCmd = cmdToProcess;
            boolean finalIsConsole = isConsole;
            long executionTime = cumulativeDelay + localDelay;
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                if (!player.isOnline()) {
                    return;
                }
                if (finalCmd.contains(";;")) {
                    String[] subCommands = finalCmd.split(";;");
                    long chainDelay = 0L;
                    for (String sub : subCommands) {
                        this.processSubCommand(player, sub, chainDelay, finalIsConsole);
                    }
                } else {
                    this.executeSingleCommand(player, finalCmd, finalIsConsole);
                }
            }, executionTime);
            cumulativeDelay += localDelay;
        }
    }

    private void processSubCommand(Player player, String commandPart, long delayOffset, boolean inheritedConsole) {
        String cmdToProcess = commandPart.trim();
        long localDelay = 0L;
        boolean isConsole = inheritedConsole;
        boolean findingPrefixes = true;
        while (findingPrefixes) {
            findingPrefixes = false;
            String lowerCmd = cmdToProcess.toLowerCase();
            if (lowerCmd.startsWith("[delay:")) {
                try {
                    int closeIndex = cmdToProcess.indexOf("]");
                    if (closeIndex == -1) continue;
                    localDelay += Long.parseLong(cmdToProcess.substring(7, closeIndex));
                    cmdToProcess = cmdToProcess.substring(closeIndex + 1).trim();
                    findingPrefixes = true;
                }
                catch (Exception closeIndex) {}
                continue;
            }
            if (lowerCmd.startsWith("[console]")) {
                isConsole = true;
                cmdToProcess = cmdToProcess.substring(9).trim();
                findingPrefixes = true;
                continue;
            }
            if (!lowerCmd.startsWith("[chance:")) continue;
            try {
                int closeIndex = cmdToProcess.indexOf("]");
                if (closeIndex == -1) continue;
                double chance = Double.parseDouble(cmdToProcess.substring(8, closeIndex));
                if (ThreadLocalRandom.current().nextDouble(100.0) > chance) {
                    return;
                }
                cmdToProcess = cmdToProcess.substring(closeIndex + 1).trim();
                findingPrefixes = true;
            }
            catch (Exception closeIndex) {}
        }
        if (cmdToProcess.isEmpty()) {
            return;
        }
        String finalCmd = cmdToProcess;
        boolean finalIsConsole = isConsole;
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            if (player.isOnline()) {
                this.executeSingleCommand(player, finalCmd, finalIsConsole);
            }
        }, delayOffset + localDelay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeSingleCommand(Player player, String cmd, boolean asConsole) {
        Location loc = player.getLocation();
        String parsedCmd = cmd.replace("%player%", player.getName()).replace("%player_name%", player.getName()).replace("%player_x%", String.format(Locale.US, "%.2f", loc.getX())).replace("%player_y%", String.format(Locale.US, "%.2f", loc.getY())).replace("%player_z%", String.format(Locale.US, "%.2f", loc.getZ())).replace("%player_yaw%", String.format(Locale.US, "%.2f", Float.valueOf(loc.getYaw()))).replace("%player_pitch%", String.format(Locale.US, "%.2f", Float.valueOf(loc.getPitch())));
        String lowerCmd = (parsedCmd = this.hooks.processPlaceholders((OfflinePlayer)player, parsedCmd)).toLowerCase().trim();
        if (lowerCmd.startsWith("[message] ") || lowerCmd.startsWith("[msg] ")) {
            String msgContent = parsedCmd.substring(parsedCmd.indexOf("] ") + 2);
            player.sendMessage(ConfigManager.fromLegacy(msgContent));
            return;
        }
        if (lowerCmd.startsWith("[actionbar] ") || lowerCmd.startsWith("[ab] ")) {
            String msgContent = parsedCmd.substring(parsedCmd.indexOf("] ") + 2);
            player.sendActionBar(ConfigManager.fromLegacy(msgContent));
            return;
        }
        if (lowerCmd.startsWith("[title] ")) {
            String fullContent;
            String titleText = fullContent = parsedCmd.substring(8);
            String subtitleText = "";
            if (fullContent.contains("|")) {
                String[] parts = fullContent.split("\\|", 2);
                titleText = parts[0].trim();
                subtitleText = parts[1].trim();
            }
            player.showTitle(Title.title((Component)ConfigManager.fromLegacy(titleText), (Component)ConfigManager.fromLegacy(subtitleText)));
            return;
        }
        if (lowerCmd.startsWith("[sound] ")) {
            String soundData = parsedCmd.substring(parsedCmd.indexOf("] ") + 2);
            this.playConfiguredSound(player, soundData, "NONE");
            return;
        }
        Boolean rule = (Boolean)player.getWorld().getGameRuleValue(GameRule.SEND_COMMAND_FEEDBACK);
        player.getWorld().setGameRule(GameRule.SEND_COMMAND_FEEDBACK, (Object)false);
        try {
            if (asConsole) {
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)parsedCmd);
            } else {
                player.performCommand(parsedCmd);
            }
        }
        finally {
            if (rule != null) {
                player.getWorld().setGameRule(GameRule.SEND_COMMAND_FEEDBACK, (Object)rule);
            }
        }
    }

    private void applyActiveEffects(Player player, BuffedItem item) {
        BuffedItemEffect effects = item.getActiveEffects();
        if (effects == null) {
            return;
        }
        int durationTicks = item.getActiveDuration() > 0 ? item.getActiveDuration() * 20 : 100;
        boolean showIcon = ConfigManager.shouldShowPotionIcons();
        for (Map.Entry<PotionEffectType, Integer> entry : effects.getPotionEffects().entrySet()) {
            player.addPotionEffect(new PotionEffect(entry.getKey(), durationTicks, entry.getValue() - 1, true, false, showIcon));
        }
        for (ParsedAttribute attr : effects.getParsedAttributes()) {
            AttributeInstance instance = player.getAttribute(attr.getAttribute());
            if (instance == null) continue;
            UUID deterministicUUID = UUID.nameUUIDFromBytes(("buffeditems.ACTIVE." + String.valueOf(player.getUniqueId()) + "." + item.getId() + "." + attr.getAttribute().name()).getBytes());
            AttributeModifier modifier = new AttributeModifier(deterministicUUID, "buffeditems.active." + item.getId(), attr.getAmount(), attr.getOperation());
            instance.addModifier(modifier);
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                AttributeInstance currentInstance;
                if (player.isOnline() && (currentInstance = player.getAttribute(attr.getAttribute())) != null) {
                    currentInstance.removeModifier(modifier);
                }
            }, (long)durationTicks);
        }
    }

    private void playConfiguredSound(Player player, String itemSound, String globalSound) {
        String soundString;
        String string = soundString = itemSound != null ? itemSound : globalSound;
        if (soundString == null || soundString.equalsIgnoreCase("NONE")) {
            return;
        }
        try {
            String[] parts = soundString.split(";");
            Sound sound = Sound.valueOf((String)parts[0].toUpperCase());
            float volume = parts.length > 1 ? Float.parseFloat(parts[1]) : 1.0f;
            float pitch = parts.length > 2 ? Float.parseFloat(parts[2]) : 1.0f;
            player.playSound(player.getLocation(), sound, volume, pitch);
        }
        catch (Exception e) {
            ConfigManager.sendDebugMessage(1, () -> "[Sound] Invalid sound format: " + soundString);
        }
    }
}

