/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.BuffedItems.handler;

import io.github.altkat.BuffedItems.BuffedItems;
import io.github.altkat.BuffedItems.manager.config.ConfigManager;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class UpdateHandler
implements Listener {
    private final BuffedItems plugin;
    private final String githubRepo;
    private String latestVersion;
    private String latestDownloadUrl;
    private final String GITHUB_REPO_URL;
    private static final String SPIGOT_URL = "https://www.spigotmc.org/resources/129550/";
    private static final long CONSOLE_LOG_DELAY_TICKS = 30L;
    private static final int CONNECT_TIMEOUT_MS = 3000;
    private static final int READ_TIMEOUT_MS = 3000;
    private static final String GITHUB_API_URL = "https://api.github.com/repos/%s/releases/latest";
    private static final Pattern TAG_PATTERN = Pattern.compile("\"tag_name\":\"([^\"]+)\"");
    private static final Pattern URL_PATTERN = Pattern.compile("\"browser_download_url\":\"([^\"]*?\\.jar)\"");

    public UpdateHandler(BuffedItems plugin, String githubRepo) {
        this.plugin = plugin;
        this.githubRepo = githubRepo;
        this.GITHUB_REPO_URL = "https://github.com/" + githubRepo + "/releases/latest";
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public void checkAsync() {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> this.performCheck(null));
    }

    public void checkManually(CommandSender sender) {
        sender.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a77Checking for updates on GitHub..."));
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> this.performCheck(sender));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performCheck(CommandSender sender) {
        HttpURLConnection connection = null;
        try {
            String jsonResponse;
            String apiUrl = String.format(GITHUB_API_URL, this.githubRepo);
            ConfigManager.sendDebugMessage(1, () -> "[UpdateChecker] Fetching from GitHub: " + apiUrl);
            connection = (HttpURLConnection)new URL(apiUrl).openConnection();
            connection.setConnectTimeout(3000);
            connection.setReadTimeout(3000);
            connection.setRequestProperty("User-Agent", "BuffedItems-UpdateChecker (" + this.githubRepo + ")");
            connection.setRequestProperty("Accept", "application/vnd.github.v3+json");
            int statusCode = connection.getResponseCode();
            if (statusCode != 200) {
                String errorMsg = "[UpdateChecker] GitHub API returned status: " + statusCode;
                ConfigManager.sendDebugMessage(1, () -> errorMsg);
                if (sender != null) {
                    sender.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cError checking updates: HTTP " + statusCode));
                }
                return;
            }
            try (InputStream inputStream = connection.getInputStream();
                 Scanner scanner = new Scanner(inputStream, StandardCharsets.UTF_8);){
                jsonResponse = scanner.useDelimiter("\\A").next();
            }
            Matcher tagMatcher = TAG_PATTERN.matcher(jsonResponse);
            if (tagMatcher.find()) {
                this.latestVersion = tagMatcher.group(1);
                Matcher urlMatcher = URL_PATTERN.matcher(jsonResponse);
                if (urlMatcher.find()) {
                    this.latestDownloadUrl = urlMatcher.group(1);
                }
                String currentVersion = this.plugin.getDescription().getVersion();
                boolean newVersionAvailable = UpdateHandler.isNewerVersion(currentVersion, this.latestVersion);
                if (sender == null) {
                    if (newVersionAvailable) {
                        new BukkitRunnable(){

                            public void run() {
                                ConfigManager.logInfo("&eA new update is available! Version: &a" + UpdateHandler.this.latestVersion);
                                ConfigManager.logInfo("&eDownload from GitHub: &a" + UpdateHandler.this.GITHUB_REPO_URL);
                                ConfigManager.logInfo("&eDownload from Spigot: &6https://www.spigotmc.org/resources/129550/");
                            }
                        }.runTaskLater((Plugin)this.plugin, 30L);
                    } else {
                        ConfigManager.logInfo("&aYou are using the latest version. (&e" + currentVersion + "&a)");
                    }
                } else if (newVersionAvailable) {
                    sender.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aA new update is available! \u00a7e" + currentVersion + " \u00a77-> \u00a7a" + this.latestVersion));
                    Component githubLink = ((TextComponent)Component.text((String)"[GitHub]", (TextColor)NamedTextColor.GREEN, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}).clickEvent(ClickEvent.openUrl((String)this.GITHUB_REPO_URL))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)ConfigManager.fromLegacy("&aClick to open GitHub")));
                    Component spigotLink = ((TextComponent)Component.text((String)"[Spigot]", (TextColor)NamedTextColor.GOLD, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}).clickEvent(ClickEvent.openUrl((String)SPIGOT_URL))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)ConfigManager.fromLegacy("&6Click to open Spigot")));
                    sender.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7eDownload: ").append(githubLink).append((Component)Component.text((String)" ")).append(spigotLink));
                } else {
                    sender.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aYou are using the latest version (\u00a7e" + currentVersion + "\u00a7a)."));
                }
            } else {
                if (sender != null) {
                    sender.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cError: Could not parse version info."));
                }
                ConfigManager.sendDebugMessage(1, () -> "[UpdateChecker] Could not parse 'tag_name' from GitHub response.");
            }
        }
        catch (IOException exception) {
            if (sender != null) {
                sender.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cConnection failed: " + exception.getMessage()));
            }
            ConfigManager.sendDebugMessage(1, () -> "[UpdateChecker] Unable to check for updates: " + exception.getClass().getSimpleName() + " - " + exception.getMessage());
        }
        catch (Exception exception) {
            if (sender != null) {
                sender.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cUnexpected error during update check."));
            }
            ConfigManager.sendDebugMessage(1, () -> "[UpdateChecker] Unexpected error: " + exception.getClass().getSimpleName() + " - " + exception.getMessage());
        }
        finally {
            if (connection != null) {
                try {
                    connection.disconnect();
                }
                catch (Exception exception) {}
            }
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (player.hasPermission("buffeditems.admin") && this.latestVersion != null && UpdateHandler.isNewerVersion(this.plugin.getDescription().getVersion(), this.latestVersion)) {
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                player.sendMessage(ConfigManager.fromLegacy("&#FF6347[BuffedItems] &eA new version is available on GitHub: &a" + this.latestVersion));
                Component openGitHub = ConfigManager.fromLegacy("&aClick to open the GitHub releases page.");
                TextComponent downloadFrom = Component.text((String)"Download from: ", (TextColor)NamedTextColor.YELLOW);
                TextComponent openBracket = Component.text((String)"[", (TextColor)NamedTextColor.GRAY, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD});
                TextComponent closeBracket = Component.text((String)"]", (TextColor)NamedTextColor.GRAY, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD});
                TextComponent separator = Component.text((String)" | ", (TextColor)NamedTextColor.GRAY);
                Component githubLink = ((TextComponent)Component.text((String)"GitHub Page", (TextColor)NamedTextColor.GREEN, (TextDecoration[])new TextDecoration[]{TextDecoration.UNDERLINED}).clickEvent(ClickEvent.openUrl((String)this.GITHUB_REPO_URL))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)openGitHub));
                Component spigotLink = ((TextComponent)Component.text((String)"Spigot", (TextColor)NamedTextColor.GOLD, (TextDecoration[])new TextDecoration[]{TextDecoration.UNDERLINED}).clickEvent(ClickEvent.openUrl((String)SPIGOT_URL))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)ConfigManager.fromLegacy("&6Click to open SpigotMC page.")));
                Component fullMessage = downloadFrom.append((Component)openBracket).append(githubLink).append((Component)closeBracket).append((Component)separator).append((Component)openBracket).append(spigotLink).append((Component)closeBracket);
                player.sendMessage(fullMessage);
            }, 40L);
        }
    }

    public static boolean isNewerVersion(String currentVersion, String latestVersion) {
        if (currentVersion == null || latestVersion == null) {
            return false;
        }
        String current = currentVersion.replaceAll("[vV]", "").split("-")[0].trim();
        String latest = latestVersion.replaceAll("[vV]", "").split("-")[0].trim();
        String[] currentParts = current.split("\\.");
        String[] latestParts = latest.split("\\.");
        int length = Math.max(currentParts.length, latestParts.length);
        for (int i = 0; i < length; ++i) {
            try {
                int latestPart;
                int currentPart = i < currentParts.length ? Integer.parseInt(currentParts[i]) : 0;
                int n = latestPart = i < latestParts.length ? Integer.parseInt(latestParts[i]) : 0;
                if (latestPart > currentPart) {
                    return true;
                }
                if (latestPart >= currentPart) continue;
                return false;
            }
            catch (NumberFormatException e) {
                return !current.equalsIgnoreCase(latest);
            }
        }
        return false;
    }

    public String getLatestVersionCached() {
        return this.latestVersion;
    }

    public String getLatestDownloadUrl() {
        return this.latestDownloadUrl;
    }
}

