/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.BuffedItems;

import io.github.altkat.BuffedItems.bukkit.Metrics;
import io.github.altkat.BuffedItems.charts.SingleLineChart;
import io.github.altkat.BuffedItems.command.BuffedItemCommand;
import io.github.altkat.BuffedItems.command.TabCompleteHandler;
import io.github.altkat.BuffedItems.handler.UpdateHandler;
import io.github.altkat.BuffedItems.hooks.HookManager;
import io.github.altkat.BuffedItems.listener.ChatListener;
import io.github.altkat.BuffedItems.listener.CraftingListener;
import io.github.altkat.BuffedItems.listener.InventoryListener;
import io.github.altkat.BuffedItems.listener.ItemConsumeListener;
import io.github.altkat.BuffedItems.listener.ItemInteractListener;
import io.github.altkat.BuffedItems.listener.ItemProtectionListener;
import io.github.altkat.BuffedItems.listener.PlayerJoinListener;
import io.github.altkat.BuffedItems.listener.PlayerQuitListener;
import io.github.altkat.BuffedItems.manager.attribute.ActiveAttributeManager;
import io.github.altkat.BuffedItems.manager.config.ConfigManager;
import io.github.altkat.BuffedItems.manager.config.ConfigUpdater;
import io.github.altkat.BuffedItems.manager.config.ItemsConfig;
import io.github.altkat.BuffedItems.manager.config.RecipesConfig;
import io.github.altkat.BuffedItems.manager.config.SetsConfig;
import io.github.altkat.BuffedItems.manager.config.UpgradesConfig;
import io.github.altkat.BuffedItems.manager.cooldown.CooldownManager;
import io.github.altkat.BuffedItems.manager.cost.CostManager;
import io.github.altkat.BuffedItems.manager.crafting.CraftingManager;
import io.github.altkat.BuffedItems.manager.crafting.CustomRecipe;
import io.github.altkat.BuffedItems.manager.effect.EffectManager;
import io.github.altkat.BuffedItems.manager.item.ItemManager;
import io.github.altkat.BuffedItems.manager.set.SetManager;
import io.github.altkat.BuffedItems.manager.upgrade.UpgradeManager;
import io.github.altkat.BuffedItems.manager.upgrade.UpgradeRecipe;
import io.github.altkat.BuffedItems.menu.MenuListener;
import io.github.altkat.BuffedItems.menu.utility.PlayerMenuUtility;
import io.github.altkat.BuffedItems.task.CooldownVisualsTask;
import io.github.altkat.BuffedItems.task.EffectApplicatorTask;
import io.github.altkat.BuffedItems.utility.item.BuffedItem;
import io.github.altkat.BuffedItems.utility.item.ItemUpdater;
import io.github.altkat.BuffedItems.utility.set.BuffedSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public final class BuffedItems
extends JavaPlugin {
    private ItemManager itemManager;
    private EffectManager effectManager;
    private ActiveAttributeManager activeAttributeManager;
    private EffectApplicatorTask effectApplicatorTask;
    private static final ConcurrentHashMap<UUID, PlayerMenuUtility> playerMenuUtilityMap = new ConcurrentHashMap();
    private final Map<UUID, List<ItemStack>> deathKeptItems = new HashMap<UUID, List<ItemStack>>();
    private Metrics metrics;
    private InventoryListener inventoryListener;
    private UpdateHandler updateHandler;
    private CooldownManager cooldownManager;
    private CooldownVisualsTask cooldownVisualsTask;
    private CostManager costManager;
    private UpgradeManager upgradeManager;
    private HookManager hookManager;
    private ItemUpdater itemUpdater;
    private SetManager setManager;
    private CraftingManager craftingManager;

    public void onEnable() {
        this.isCompatible();
        this.metrics = new Metrics(this, 27592);
        this.metrics.addCustomChart(new SingleLineChart("total_items", () -> this.itemManager != null ? this.itemManager.getLoadedItems().size() : 0));
        this.metrics.addCustomChart(new SingleLineChart("valid_items", () -> {
            if (this.itemManager == null) {
                return 0;
            }
            return (int)this.itemManager.getLoadedItems().values().stream().filter(BuffedItem::isValid).count();
        }));
        this.metrics.addCustomChart(new SingleLineChart("items_with_errors", () -> {
            if (this.itemManager == null) {
                return 0;
            }
            return (int)this.itemManager.getLoadedItems().values().stream().filter(item -> !item.isValid()).count();
        }));
        ConfigManager.setup(this);
        this.saveDefaultConfig();
        ItemsConfig.setup(this);
        UpgradesConfig.setup(this);
        SetsConfig.setup(this);
        RecipesConfig.setup(this);
        this.initializeManagers();
        try {
            ConfigUpdater.update(this, "config.yml");
            ConfigUpdater.update(this, "items.yml");
            ConfigUpdater.update(this, "upgrades.yml");
            ConfigUpdater.update(this, "sets.yml");
            ConfigUpdater.update(this, "recipes.yml");
        }
        catch (Exception e) {
            this.getLogger().severe("WARNING: Failed to run file updater tasks.");
            e.printStackTrace();
        }
        this.reloadConfig();
        ConfigManager.loadGlobalSettings();
        this.registerListenersAndCommands();
        this.startEffectTask();
        String GITHUB_REPO = "altkat/BuffedItems";
        this.updateHandler = new UpdateHandler(this, "altkat/BuffedItems");
        this.updateHandler.checkAsync();
        new BukkitRunnable(){

            public void run() {
                ConfigManager.sendDebugMessage(1, () -> "[Startup] Delayed item loading task running...");
                BuffedItems.this.itemManager.loadItems(false);
                BuffedItems.this.upgradeManager.loadRecipes(false);
                BuffedItems.this.setManager.loadSets(false);
                BuffedItems.this.craftingManager.loadRecipes(false);
                BuffedItems.this.printStartupSummary();
                ConfigManager.sendDebugMessage(1, () -> "[Startup] Delayed item loading complete.");
            }
        }.runTaskLater((Plugin)this, 20L);
        ConfigManager.logInfo("&aBuffedItems has been enabled!");
    }

    public void onDisable() {
        ConfigManager.sendDebugMessage(1, () -> "[Shutdown] Cleaning up all online players...");
        int playerCount = Bukkit.getOnlinePlayers().size();
        int successCount = 0;
        int failCount = 0;
        for (Player player : Bukkit.getOnlinePlayers()) {
            try {
                ConfigManager.sendDebugMessage(1, () -> "[Shutdown] Clearing effects for: " + player.getName());
                this.effectManager.clearAllAttributes(player);
                this.effectApplicatorTask.getManagedEffects(player.getUniqueId()).forEach(arg_0 -> ((Player)player).removePotionEffect(arg_0));
                ++successCount;
            }
            catch (Exception e) {
                ++failCount;
                this.getLogger().warning("Failed to clear effects for player " + player.getName() + ": " + e.getMessage());
            }
        }
        if (this.craftingManager != null) {
            ConfigManager.sendDebugMessage(1, () -> "[Shutdown] Unloading custom recipes...");
            this.craftingManager.unloadRecipes();
        }
        ConfigManager.sendDebugMessage(1, () -> "[Shutdown] Saving final config...");
        ConfigManager.backupConfig();
        playerMenuUtilityMap.clear();
        if (this.cooldownVisualsTask != null) {
            this.cooldownVisualsTask.cleanup();
        }
        ConfigManager.logInfo("&aCleanup complete: &e" + successCount + "/" + playerCount + "&a players cleaned" + (String)(failCount > 0 ? "&c (" + failCount + " failed)" : ""));
        ConfigManager.logInfo("&cBuffedItems has been disabled!");
    }

    private void initializeManagers() {
        ConfigManager.loadGlobalSettings();
        this.hookManager = new HookManager(this);
        this.costManager = new CostManager(this);
        this.itemManager = new ItemManager(this);
        this.effectManager = new EffectManager(this);
        this.activeAttributeManager = new ActiveAttributeManager();
        this.cooldownManager = new CooldownManager();
        this.upgradeManager = new UpgradeManager(this);
        this.itemUpdater = new ItemUpdater(this);
        this.setManager = new SetManager(this);
        this.craftingManager = new CraftingManager(this);
    }

    private void registerListenersAndCommands() {
        this.getCommand("buffeditems").setExecutor((CommandExecutor)new BuffedItemCommand(this));
        this.getCommand("buffeditems").setTabCompleter((TabCompleter)new TabCompleteHandler(this));
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerJoinListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerQuitListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new MenuListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ChatListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ItemConsumeListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ItemProtectionListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ItemInteractListener(this), (Plugin)this);
        this.inventoryListener = new InventoryListener(this);
        this.getServer().getPluginManager().registerEvents((Listener)this.inventoryListener, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new CraftingListener(this), (Plugin)this);
    }

    private void startEffectTask() {
        this.effectApplicatorTask = new EffectApplicatorTask(this);
        this.effectApplicatorTask.runTaskTimer((Plugin)this, 0L, 20L);
        this.cooldownVisualsTask = new CooldownVisualsTask(this);
        this.cooldownVisualsTask.runTaskTimer((Plugin)this, 0L, 2L);
    }

    public static PlayerMenuUtility getPlayerMenuUtility(Player p) {
        UUID playerUUID = p.getUniqueId();
        if (playerMenuUtilityMap.containsKey(playerUUID)) {
            return playerMenuUtilityMap.get(playerUUID);
        }
        ConfigManager.sendDebugMessage(4, () -> "[Util] Creating new PlayerMenuUtility for " + p.getName());
        PlayerMenuUtility playerMenuUtility = new PlayerMenuUtility(p);
        playerMenuUtilityMap.put(playerUUID, playerMenuUtility);
        return playerMenuUtility;
    }

    private void printStartupSummary() {
        String latestVersion;
        String separator = "&#FF6347==================================================";
        ConfigManager.logInfo(separator);
        ConfigManager.logInfo("&#FCD05CBuffedItems v" + this.getDescription().getVersion() + " - Startup Summary");
        ConfigManager.logInfo("");
        Map<String, BuffedItem> items = this.itemManager.getLoadedItems();
        long validItems = items.values().stream().filter(BuffedItem::isValid).count();
        long invalidItems = (long)items.size() - validItems;
        ConfigManager.logInfo("&#5FE2C5  Items:");
        ConfigManager.logInfo("&#5FE2C5    \u2022 Total: &f" + items.size());
        ConfigManager.logInfo("&#5FE2C5    \u2022 Valid: &a" + validItems);
        if (invalidItems > 0L) {
            ConfigManager.logInfo("&#5FE2C5    \u2022 Errors: &c" + invalidItems + " &7(Check console logs)");
        }
        ConfigManager.logInfo("");
        ConfigManager.logInfo("&#FF9F43  Sets:");
        if (!SetsConfig.get().getBoolean("settings.enabled", true)) {
            ConfigManager.logInfo("&#FF9F43    \u2022 Status: &cDisabled");
        } else {
            Map<String, BuffedSet> sets = this.setManager.getSets();
            if (sets.isEmpty()) {
                ConfigManager.logInfo("&#FF9F43    \u2022 Total: &f0");
            } else {
                long validSets = sets.values().stream().filter(BuffedSet::isValid).count();
                long invalidSets = (long)sets.size() - validSets;
                ConfigManager.logInfo("&#FF9F43    \u2022 Total: &f" + sets.size());
                ConfigManager.logInfo("&#FF9F43    \u2022 Valid: &a" + validSets);
                if (invalidSets > 0L) {
                    ConfigManager.logInfo("&#FF9F43    \u2022 Errors: &c" + invalidSets + " &7(Check console logs)");
                }
            }
        }
        ConfigManager.logInfo("");
        ConfigManager.logInfo("&#F5CD66  Upgrades:");
        if (!UpgradesConfig.get().getBoolean("settings.enabled", true)) {
            ConfigManager.logInfo("&#F5CD66    \u2022 Status: &cDisabled");
        } else {
            Map<String, UpgradeRecipe> recipes = this.upgradeManager.getRecipes();
            if (recipes.isEmpty()) {
                ConfigManager.logInfo("&#F5CD66    \u2022 Total: &f0");
            } else {
                long validRecipes = recipes.values().stream().filter(UpgradeRecipe::isValid).count();
                long invalidRecipes = (long)recipes.size() - validRecipes;
                ConfigManager.logInfo("&#F5CD66    \u2022 Total: &f" + recipes.size());
                ConfigManager.logInfo("&#F5CD66    \u2022 Valid: &a" + validRecipes);
                if (invalidRecipes > 0L) {
                    ConfigManager.logInfo("&#F5CD66    \u2022 Errors: &c" + invalidRecipes + " &7(Check console logs)");
                }
            }
        }
        ConfigManager.logInfo("");
        ConfigManager.logInfo("&#82E0AA  Crafting:");
        if (!RecipesConfig.get().getBoolean("settings.enabled", true)) {
            ConfigManager.logInfo("&#82E0AA    \u2022 Status: &cDisabled");
        } else {
            Map<String, CustomRecipe> craftingRecipes = this.craftingManager.getRecipes();
            if (craftingRecipes.isEmpty()) {
                ConfigManager.logInfo("&#82E0AA    \u2022 Total: &f0");
            } else {
                long validCrafting = craftingRecipes.values().stream().filter(CustomRecipe::isValid).count();
                long invalidCrafting = (long)craftingRecipes.size() - validCrafting;
                ConfigManager.logInfo("&#82E0AA    \u2022 Total: &f" + craftingRecipes.size());
                ConfigManager.logInfo("&#82E0AA    \u2022 Valid: &a" + validCrafting);
                if (invalidCrafting > 0L) {
                    ConfigManager.logInfo("&#82E0AA    \u2022 Errors: &c" + invalidCrafting + " &7(Check console logs)");
                }
            }
        }
        ArrayList<String> activeHooks = new ArrayList<String>();
        if (this.hookManager.isPlaceholderAPILoaded()) {
            activeHooks.add("PlaceholderAPI");
        }
        if (this.hookManager.isVaultLoaded()) {
            activeHooks.add("Vault");
        }
        if (this.hookManager.isCoinsEngineLoaded()) {
            activeHooks.add("CoinsEngine");
        }
        if (this.hookManager.isItemsAdderLoaded()) {
            activeHooks.add("ItemsAdder");
        }
        if (this.hookManager.isNexoLoaded()) {
            activeHooks.add("Nexo");
        }
        ConfigManager.logInfo("");
        ConfigManager.logInfo("&#9B59B6  Hooks:");
        if (activeHooks.isEmpty()) {
            ConfigManager.logInfo("&#9B59B6    \u2022 &7None");
        } else {
            ConfigManager.logInfo("&#9B59B6    \u2022 Active: &f" + String.join((CharSequence)", ", activeHooks));
        }
        int currentDebugLevel = ConfigManager.getDebugLevel();
        String debugLevelInfo = currentDebugLevel <= 0 ? "OFF" : (currentDebugLevel == 1 ? "INFO" : (currentDebugLevel == 2 ? "TASK" : (currentDebugLevel == 3 ? "DETAILED" : "VERBOSE")));
        String currentVersion = this.getDescription().getVersion();
        String string = latestVersion = this.updateHandler != null ? this.updateHandler.getLatestVersionCached() : null;
        Object versionStatus = latestVersion == null ? "&7(Checking...)" : (UpdateHandler.isNewerVersion(currentVersion, latestVersion) ? "&c(Update Available: " + latestVersion + ")" : "&a(Latest)");
        ConfigManager.logInfo("");
        ConfigManager.logInfo("&#5DADE2  System:");
        ConfigManager.logInfo("&#5DADE2    \u2022 Version: &f" + currentVersion + " " + (String)versionStatus);
        ConfigManager.logInfo("&#5DADE2    \u2022 Debug Level: &f" + debugLevelInfo + " (" + currentDebugLevel + ")");
        ConfigManager.logInfo("&#5DADE2    \u2022 Server: &f" + Bukkit.getName() + " " + Bukkit.getMinecraftVersion());
        ConfigManager.logInfo(separator);
    }

    public ItemManager getItemManager() {
        return this.itemManager;
    }

    public EffectManager getEffectManager() {
        return this.effectManager;
    }

    public ActiveAttributeManager getActiveAttributeManager() {
        return this.activeAttributeManager;
    }

    public EffectApplicatorTask getEffectApplicatorTask() {
        return this.effectApplicatorTask;
    }

    public Map<UUID, List<ItemStack>> getDeathKeptItems() {
        return this.deathKeptItems;
    }

    public static void removePlayerMenuUtility(UUID uuid) {
        if (playerMenuUtilityMap.containsKey(uuid)) {
            ConfigManager.sendDebugMessage(4, () -> "[Util] Removing PlayerMenuUtility for " + String.valueOf(uuid));
        }
        playerMenuUtilityMap.remove(uuid);
    }

    public InventoryListener getInventoryChangeListener() {
        return this.inventoryListener;
    }

    public CooldownManager getCooldownManager() {
        return this.cooldownManager;
    }

    public CostManager getCostManager() {
        return this.costManager;
    }

    public UpgradeManager getUpgradeManager() {
        return this.upgradeManager;
    }

    public HookManager getHookManager() {
        return this.hookManager;
    }

    public UpdateHandler getUpdateHandler() {
        return this.updateHandler;
    }

    public ItemUpdater getItemUpdater() {
        return this.itemUpdater;
    }

    public SetManager getSetManager() {
        return this.setManager;
    }

    public CraftingManager getCraftingManager() {
        return this.craftingManager;
    }

    private void isCompatible() {
        try {
            Class.forName("com.destroystokyo.paper.event.player.PlayerArmorChangeEvent");
        }
        catch (ClassNotFoundException e) {
            this.getLogger().severe("==============================================================");
            this.getLogger().severe("! ! ! SEVERE WARNING ! ! !");
            this.getLogger().severe(" ");
            this.getLogger().severe("This plugin (BuffedItems) requires the Paper API to function properly.");
            this.getLogger().severe("It provides no guarantee to work on Spigot and will cause errors.");
            this.getLogger().severe("Please consider using a Paper-based server (Paper, Purpur, Pufferfish, etc.).");
            this.getLogger().severe("==============================================================");
        }
    }
}

