/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.BuffedItems.utility.item;

import io.github.altkat.BuffedItems.manager.config.ConfigManager;
import io.github.altkat.BuffedItems.utility.attribute.ParsedAttribute;
import io.github.altkat.BuffedItems.utility.item.BuffedItem;
import io.github.altkat.BuffedItems.utility.item.BuffedItemEffect;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class ItemBuilder {
    private final BuffedItem buffedItem;
    private final ItemStack itemStack;
    private final Plugin plugin;
    private final int serverVersion;
    protected static final EquipmentSlot[] VALID_SLOTS = new EquipmentSlot[]{EquipmentSlot.HAND, EquipmentSlot.OFF_HAND, EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};

    public ItemBuilder(BuffedItem buffedItem, Plugin plugin) {
        this.buffedItem = buffedItem;
        this.plugin = plugin;
        this.itemStack = new ItemStack(buffedItem.getMaterial());
        this.serverVersion = this.getMinecraftVersion();
    }

    private int getMinecraftVersion() {
        String version = Bukkit.getBukkitVersion();
        try {
            String[] parts = version.split("-")[0].split("\\.");
            if (parts.length >= 2) {
                int major = Integer.parseInt(parts[0]);
                int minor = Integer.parseInt(parts[1]);
                int patch = parts.length > 2 ? Integer.parseInt(parts[2]) : 0;
                return major * 100 + minor * 10 + patch;
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Could not parse MC version: " + version);
        }
        return 1165;
    }

    /*
     * WARNING - void declaration
     */
    public ItemStack build() {
        boolean hasRealEnchants;
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta == null) {
            return this.itemStack;
        }
        meta.displayName(ConfigManager.fromLegacy(this.buffedItem.getDisplayName()));
        List<Component> coloredLore = ConfigManager.loreFromLegacy(this.buffedItem.getLore());
        meta.lore(coloredLore);
        if (this.buffedItem.getCustomModelData().isPresent()) {
            int cmdValue = this.buffedItem.getCustomModelData().get();
            if (this.serverVersion < 1210) {
                meta.setCustomModelData(Integer.valueOf(cmdValue));
                ConfigManager.sendDebugMessage(4, () -> "[ItemBuilder] Applied CMD (legacy): " + cmdValue + " to " + this.buffedItem.getId());
            } else {
                try {
                    meta.setCustomModelData(Integer.valueOf(cmdValue));
                    ConfigManager.sendDebugMessage(4, () -> "[ItemBuilder] Applied CMD (Paper): " + cmdValue + " to " + this.buffedItem.getId());
                }
                catch (Exception e) {
                    ConfigManager.sendDebugMessage(1, () -> "[ItemBuilder] Legacy CMD failed, trying NMS for " + this.buffedItem.getId());
                    try {
                        this.applyCustomModelDataNMS(cmdValue);
                    }
                    catch (Exception nmsException) {
                        this.plugin.getLogger().warning("[ItemBuilder] Failed to apply CMD via NMS: " + nmsException.getMessage());
                    }
                }
            }
        }
        if (this.buffedItem.getFlag("UNBREAKABLE")) {
            meta.setUnbreakable(true);
        }
        boolean bl = hasRealEnchants = !this.buffedItem.getEnchantments().isEmpty();
        if (hasRealEnchants) {
            for (Map.Entry<Enchantment, Integer> entry : this.buffedItem.getEnchantments().entrySet()) {
                Enchantment enchantment = entry.getKey();
                int n = entry.getValue();
                try {
                    meta.addEnchant(enchantment, n, true);
                    ConfigManager.sendDebugMessage(3, () -> "[ItemBuilder] Applied enchantment: " + enchantment.getKey().getKey() + " Level: " + level + " to item " + this.buffedItem.getId());
                }
                catch (IllegalArgumentException e) {
                    ConfigManager.sendDebugMessage(1, () -> "[ItemBuilder] Failed to apply enchantment " + enchantment.getKey().getKey() + " with level " + level + " to item " + this.buffedItem.getId() + ": " + e.getMessage());
                }
            }
        }
        if (this.buffedItem.hasGlow() && (!hasRealEnchants || this.buffedItem.getFlag("HIDE_ENCHANTS"))) {
            meta.addEnchant(Enchantment.LUCK_OF_THE_SEA, 1, false);
        }
        meta.setAttributeModifiers(null);
        boolean forceHideAttributes = false;
        if (this.buffedItem.getAttributeMode() == BuffedItem.AttributeMode.STATIC) {
            boolean hasAnyAttribute = false;
            for (Map.Entry entry : this.buffedItem.getEffects().entrySet()) {
                String slotKey = ((String)entry.getKey()).toUpperCase();
                BuffedItemEffect itemEffect = (BuffedItemEffect)entry.getValue();
                EquipmentSlot equipmentSlot = this.getEquipmentSlot(slotKey);
                if (equipmentSlot == null) continue;
                for (ParsedAttribute parsedAttr : itemEffect.getParsedAttributes()) {
                    AttributeModifier modifier = new AttributeModifier(parsedAttr.getUuid(), "buffeditems." + this.buffedItem.getId() + "." + slotKey, parsedAttr.getAmount(), parsedAttr.getOperation(), equipmentSlot);
                    meta.addAttributeModifier(parsedAttr.getAttribute(), modifier);
                    hasAnyAttribute = true;
                }
            }
            if (!hasAnyAttribute) {
                Attribute dummyAttr = Attribute.GENERIC_LUCK;
                for (EquipmentSlot slot : VALID_SLOTS) {
                    UUID dummyUUID = UUID.nameUUIDFromBytes(("buffeditems.dummy.static." + this.buffedItem.getId() + "." + slot.name()).getBytes(StandardCharsets.UTF_8));
                    AttributeModifier dummyMod = new AttributeModifier(dummyUUID, "buffeditems.dummy." + slot.name(), 0.0, AttributeModifier.Operation.ADD_NUMBER, slot);
                    meta.addAttributeModifier(dummyAttr, dummyMod);
                }
                forceHideAttributes = true;
            }
        } else {
            Attribute dummyAttr = Attribute.GENERIC_LUCK;
            for (Attribute slot : VALID_SLOTS) {
                UUID dummyUUID = UUID.nameUUIDFromBytes(("buffeditems.dummy.dynamic." + this.buffedItem.getId() + "." + slot.name()).getBytes(StandardCharsets.UTF_8));
                AttributeModifier dummyMod = new AttributeModifier(dummyUUID, "buffeditems.dummy." + slot.name(), 0.0, AttributeModifier.Operation.ADD_NUMBER, (EquipmentSlot)slot);
                meta.addAttributeModifier(dummyAttr, dummyMod);
            }
            forceHideAttributes = true;
        }
        if (this.buffedItem.getFlag("HIDE_ENCHANTS")) {
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        }
        if (this.buffedItem.getFlag("HIDE_ATTRIBUTES") || forceHideAttributes) {
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
        }
        if (this.buffedItem.getFlag("HIDE_UNBREAKABLE")) {
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_UNBREAKABLE});
        }
        if (this.buffedItem.getFlag("HIDE_DESTROYS")) {
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DESTROYS});
        }
        if (this.buffedItem.getFlag("HIDE_PLACED_ON")) {
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_PLACED_ON});
        }
        if (this.buffedItem.getFlag("HIDE_ADDITIONAL_TOOLTIP")) {
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ADDITIONAL_TOOLTIP});
        }
        if (this.buffedItem.getFlag("HIDE_ARMOR_TRIM")) {
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ARMOR_TRIM});
        }
        NamespacedKey key = new NamespacedKey(this.plugin, "buffeditem_id");
        meta.getPersistentDataContainer().set(key, PersistentDataType.STRING, (Object)this.buffedItem.getId());
        if (this.buffedItem.isActiveMode() && this.buffedItem.getMaxUses() > 0) {
            void var7_18;
            NamespacedKey maxKey = new NamespacedKey(this.plugin, "remaining_active_uses");
            meta.getPersistentDataContainer().set(maxKey, PersistentDataType.INTEGER, (Object)this.buffedItem.getMaxUses());
            List list = meta.lore();
            if (list == null) {
                ArrayList arrayList = new ArrayList();
            }
            String dynamicLore = this.buffedItem.getUsageLore(this.buffedItem.getMaxUses());
            var7_18.add(ConfigManager.fromLegacy(dynamicLore));
            meta.lore((List)var7_18);
        }
        this.itemStack.setItemMeta(meta);
        return this.itemStack;
    }

    private void applyCustomModelDataNMS(int cmdValue) throws Exception {
        block3: {
            try {
                Class<ItemMeta> itemMetaClass = ItemMeta.class;
                Method setCustomModelData = itemMetaClass.getMethod("setCustomModelData", Integer.TYPE);
                ItemMeta meta = this.itemStack.getItemMeta();
                if (meta != null) {
                    setCustomModelData.invoke((Object)meta, cmdValue);
                    this.itemStack.setItemMeta(meta);
                }
            }
            catch (NoSuchMethodException e) {
                ItemMeta meta = this.itemStack.getItemMeta();
                if (meta == null) break block3;
                meta.setCustomModelData(Integer.valueOf(cmdValue));
                this.itemStack.setItemMeta(meta);
            }
        }
        ConfigManager.sendDebugMessage(3, () -> "[ItemBuilder] Applied CMD: " + cmdValue);
    }

    private EquipmentSlot getEquipmentSlot(String slot) {
        switch (slot.toUpperCase()) {
            case "MAIN_HAND": {
                return EquipmentSlot.HAND;
            }
            case "OFF_HAND": {
                return EquipmentSlot.OFF_HAND;
            }
            case "HELMET": {
                return EquipmentSlot.HEAD;
            }
            case "CHESTPLATE": {
                return EquipmentSlot.CHEST;
            }
            case "LEGGINGS": {
                return EquipmentSlot.LEGS;
            }
            case "BOOTS": {
                return EquipmentSlot.FEET;
            }
        }
        return null;
    }
}

