/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.BuffedItems.menu.utility;

import io.github.altkat.BuffedItems.BuffedItems;
import io.github.altkat.BuffedItems.hooks.HookManager;
import io.github.altkat.BuffedItems.manager.config.ConfigManager;
import io.github.altkat.BuffedItems.menu.base.PaginatedMenu;
import io.github.altkat.BuffedItems.menu.editor.ItemEditorMenu;
import io.github.altkat.BuffedItems.menu.utility.ConfirmationMenu;
import io.github.altkat.BuffedItems.menu.utility.MainMenu;
import io.github.altkat.BuffedItems.menu.utility.PlayerMenuUtility;
import io.github.altkat.BuffedItems.utility.item.BuffedItem;
import io.github.altkat.BuffedItems.utility.item.ItemBuilder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class ItemListMenu
extends PaginatedMenu {
    private final BuffedItems plugin;
    private final HookManager hooks;

    public ItemListMenu(PlayerMenuUtility playerMenuUtility, BuffedItems plugin) {
        super(playerMenuUtility);
        this.plugin = plugin;
        this.hooks = plugin.getHookManager();
        this.maxItemsPerPage = 36;
    }

    @Override
    public String getMenuName() {
        return "Item Editor List";
    }

    @Override
    public int getSlots() {
        return 54;
    }

    @Override
    public void handleMenu(InventoryClickEvent e) {
        Player p = (Player)e.getWhoClicked();
        ArrayList<BuffedItem> items = new ArrayList<BuffedItem>(this.plugin.getItemManager().getLoadedItems().values());
        items.sort(Comparator.comparing(BuffedItem::getId));
        ItemStack clickedItem = e.getCurrentItem();
        if (clickedItem == null) {
            return;
        }
        if (this.handlePageChange(e, items.size())) {
            return;
        }
        if (e.getSlot() >= 9 && e.getSlot() < 45 && clickedItem.hasItemMeta() && clickedItem.getItemMeta().getPersistentDataContainer().has(new NamespacedKey((Plugin)this.plugin, "buffeditem_id"), PersistentDataType.STRING)) {
            String itemId = (String)clickedItem.getItemMeta().getPersistentDataContainer().get(new NamespacedKey((Plugin)this.plugin, "buffeditem_id"), PersistentDataType.STRING);
            this.playerMenuUtility.setItemToEditId(itemId);
            if (e.getClick() == ClickType.SHIFT_LEFT) {
                BuffedItem item = this.plugin.getItemManager().getBuffedItem(itemId);
                if (item != null) {
                    ItemStack stack = new ItemBuilder(item, (Plugin)this.plugin).build();
                    ItemMeta meta = stack.getItemMeta();
                    if (meta != null) {
                        List originalLore;
                        Component originalName;
                        if (meta.hasDisplayName() && (originalName = meta.displayName()) != null) {
                            String legacyNameWithSection = ConfigManager.toSection(originalName);
                            String parsedName = this.hooks.processPlaceholders((OfflinePlayer)p, legacyNameWithSection);
                            meta.displayName(ConfigManager.fromSection(parsedName));
                        }
                        if (meta.hasLore() && (originalLore = meta.lore()) != null) {
                            List parsedLore = originalLore.stream().map(ConfigManager::toSection).map(line -> this.hooks.processPlaceholders((OfflinePlayer)p, (String)line)).map(ConfigManager::fromSection).collect(Collectors.toList());
                            meta.lore(parsedLore);
                        }
                        stack.setItemMeta(meta);
                    }
                    p.getInventory().addItem(new ItemStack[]{stack});
                    p.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aItem received: \u00a7f" + itemId));
                    p.playSound(p.getLocation(), Sound.ENTITY_ITEM_PICKUP, 1.0f, 1.0f);
                    this.plugin.getEffectApplicatorTask().markPlayerForUpdate(p.getUniqueId());
                }
            } else if (e.isLeftClick()) {
                new ItemEditorMenu(this.playerMenuUtility, this.plugin).open();
            } else if (e.getClick() == ClickType.SHIFT_RIGHT) {
                this.playerMenuUtility.setWaitingForChatInput(true);
                this.playerMenuUtility.setChatInputPath("duplicateitem");
                p.closeInventory();
                p.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aDuplicating '\u00a7e" + itemId + "\u00a7a'."));
                p.sendMessage(ConfigManager.fromSection("\u00a7aPlease type the NEW unique ID for the copy in chat."));
                p.sendMessage(ConfigManager.fromSection("\u00a77(e.g., 'new_fire_sword'). (Type 'cancel' to exit)"));
            } else if (e.isRightClick()) {
                new ConfirmationMenu(this.playerMenuUtility, this.plugin, itemId).open();
            }
            return;
        }
        if (e.getSlot() == 49) {
            this.playerMenuUtility.setWaitingForChatInput(true);
            this.playerMenuUtility.setChatInputPath("createnewitem");
            p.closeInventory();
            p.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aPlease type the unique ID for the new item in chat (e.g., 'fire_sword')."));
            p.sendMessage(ConfigManager.fromSection("\u00a77(Type 'cancel' to exit)"));
        } else if (e.getSlot() == 53) {
            new MainMenu(this.playerMenuUtility, this.plugin).open();
        }
    }

    @Override
    public void setMenuItems() {
        int i;
        ItemStack filler = this.makeItem(Material.BLACK_STAINED_GLASS_PANE, " ", new String[0]);
        for (i = 0; i < 9; ++i) {
            this.inventory.setItem(i, filler);
        }
        for (i = 45; i < 54; ++i) {
            this.inventory.setItem(i, filler);
        }
        this.addMenuControls();
        this.inventory.setItem(49, this.makeItem(Material.ANVIL, "\u00a7bCreate New Item", "\u00a77Click to create a brand new item."));
        this.inventory.setItem(53, this.makeItem(Material.BARRIER, "\u00a7cBack to Dashboard", new String[0]));
        ArrayList<BuffedItem> items = new ArrayList<BuffedItem>(this.plugin.getItemManager().getLoadedItems().values());
        items.sort(Comparator.comparing(BuffedItem::getId));
        if (!items.isEmpty()) {
            int index;
            for (int i2 = 0; i2 < this.maxItemsPerPage && (index = this.maxItemsPerPage * this.page + i2) < items.size(); ++i2) {
                ItemStack itemStack;
                BuffedItem currentItem = (BuffedItem)items.get(index);
                if (currentItem.isValid()) {
                    itemStack = new ItemBuilder(currentItem, (Plugin)this.plugin).build();
                    meta = itemStack.getItemMeta();
                    ArrayList<Object> newLore = meta.getLore() != null ? new ArrayList<Object>(meta.getLore()) : new ArrayList();
                    newLore.add("");
                    newLore.add("\u00a77ID: \u00a7f" + currentItem.getId());
                    newLore.add("\u00a78\u00a7m------------------");
                    newLore.add("\u00a7eLeft-Click to Edit");
                    newLore.add("\u00a7aShift + Left-Click to Get");
                    newLore.add("\u00a7cRight-Click to Delete");
                    newLore.add("\u00a7bShift + Right Click to Duplicate");
                    newLore.add("\u00a78\u00a7m------------------");
                    meta.setLore(newLore);
                    itemStack.setItemMeta(meta);
                } else {
                    itemStack = new ItemStack(Material.BARRIER);
                    meta = itemStack.getItemMeta();
                    meta.setDisplayName("\u00a7c\u00a7lERROR: " + currentItem.getId());
                    ArrayList<String> errorLore = new ArrayList<String>();
                    errorLore.add("\u00a77This item has configuration errors.");
                    errorLore.add("");
                    errorLore.addAll(currentItem.getErrorMessages());
                    errorLore.add("");
                    errorLore.add("\u00a78\u00a7m------------------");
                    errorLore.add("\u00a7eLeft-Click to Edit and fix the errors.");
                    errorLore.add("\u00a7aShift + Left-Click to Get (as-is)");
                    errorLore.add("\u00a7cRight-Click to Delete");
                    errorLore.add("\u00a7bShift + Right Click to Duplicate (as-is)");
                    errorLore.add("\u00a78\u00a7m------------------");
                    meta.setLore(errorLore);
                    NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "buffeditem_id");
                    meta.getPersistentDataContainer().set(key, PersistentDataType.STRING, (Object)currentItem.getId());
                    itemStack.setItemMeta(meta);
                }
                this.inventory.setItem(9 + i2, itemStack);
            }
        }
    }
}

