/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.BuffedItems.menu.set;

import io.github.altkat.BuffedItems.BuffedItems;
import io.github.altkat.BuffedItems.manager.config.ConfigManager;
import io.github.altkat.BuffedItems.manager.config.SetsConfig;
import io.github.altkat.BuffedItems.menu.base.PaginatedMenu;
import io.github.altkat.BuffedItems.menu.set.SetEditorMenu;
import io.github.altkat.BuffedItems.menu.utility.MainMenu;
import io.github.altkat.BuffedItems.menu.utility.PlayerMenuUtility;
import io.github.altkat.BuffedItems.utility.set.BuffedSet;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class SetListMenu
extends PaginatedMenu {
    private final BuffedItems plugin;

    public SetListMenu(PlayerMenuUtility playerMenuUtility, BuffedItems plugin) {
        super(playerMenuUtility);
        this.plugin = plugin;
        this.maxItemsPerPage = 36;
    }

    @Override
    public String getMenuName() {
        return "Item Sets (Page " + (this.page + 1) + ")";
    }

    @Override
    public int getSlots() {
        return 54;
    }

    @Override
    public void handleMenu(InventoryClickEvent e) {
        Player p = (Player)e.getWhoClicked();
        List<BuffedSet> sets = this.getSortedSets();
        if (e.getCurrentItem() == null) {
            return;
        }
        if (this.handlePageChange(e, sets.size())) {
            return;
        }
        if (e.getSlot() == 53) {
            new MainMenu(this.playerMenuUtility, this.plugin).open();
            return;
        }
        if (e.getSlot() == 49) {
            this.playerMenuUtility.setWaitingForChatInput(true);
            this.playerMenuUtility.setChatInputPath("create_set");
            p.closeInventory();
            p.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aEnter a unique ID for the new Item Set (e.g. 'paladin_set')."));
            p.sendMessage(ConfigManager.fromSection("\u00a77(Type 'cancel' to exit)"));
            return;
        }
        if (e.getSlot() >= 9 && e.getSlot() < 45) {
            int index = this.maxItemsPerPage * this.page + (e.getSlot() - 9);
            if (index >= sets.size()) {
                return;
            }
            BuffedSet set = sets.get(index);
            if (e.getClick() == ClickType.LEFT) {
                this.playerMenuUtility.setItemToEditId(set.getId());
                new SetEditorMenu(this.playerMenuUtility, this.plugin).open();
                p.playSound(p.getLocation(), Sound.BLOCK_NOTE_BLOCK_PLING, 1.0f, 1.0f);
            } else if (e.getClick() == ClickType.RIGHT) {
                SetsConfig.get().set("sets." + set.getId(), null);
                SetsConfig.save();
                this.plugin.getSetManager().loadSets(true);
                p.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cSet '" + set.getId() + "' deleted."));
                p.playSound(p.getLocation(), Sound.BLOCK_LAVA_EXTINGUISH, 1.0f, 1.0f);
                this.open();
            }
        }
    }

    @Override
    public void setMenuItems() {
        int index;
        int i;
        ItemStack filler = this.makeItem(Material.BLACK_STAINED_GLASS_PANE, " ", new String[0]);
        for (i = 0; i < 9; ++i) {
            this.inventory.setItem(i, filler);
        }
        for (i = 45; i < 54; ++i) {
            this.inventory.setItem(i, filler);
        }
        this.addMenuControls();
        this.inventory.setItem(53, this.makeItem(Material.BARRIER, "\u00a7cBack to Main Menu", new String[0]));
        this.inventory.setItem(49, this.makeItem(Material.ANVIL, "\u00a7aCreate New Set", "\u00a77Click to create a new item set."));
        List<BuffedSet> sets = this.getSortedSets();
        for (int i2 = 0; i2 < this.maxItemsPerPage && (index = this.maxItemsPerPage * this.page + i2) < sets.size(); ++i2) {
            BuffedSet set = sets.get(index);
            Material iconMat = Material.ARMOR_STAND;
            if (!set.getItemIds().isEmpty()) {
                String firstItemId = set.getItemIds().get(0);
                if (this.plugin.getItemManager().getBuffedItem(firstItemId) != null) {
                    iconMat = this.plugin.getItemManager().getBuffedItem(firstItemId).getMaterial();
                }
            }
            ArrayList<Object> lore = new ArrayList<Object>();
            lore.add("\u00a77Display: " + ConfigManager.toSection(ConfigManager.fromLegacy(set.getDisplayName())));
            lore.add("");
            lore.add("\u00a77Items: \u00a7f" + set.getItemIds().size());
            lore.add("\u00a77Bonuses: \u00a7f" + set.getBonuses().size());
            if (!set.isValid()) {
                lore.add("");
                lore.add("\u00a7c\u26a0 CONFIG ERRORS:");
                for (String err : set.getErrorMessages()) {
                    lore.add("\u00a7c- " + err);
                }
            }
            lore.add("");
            lore.add("\u00a7eLeft-Click to Edit");
            lore.add("\u00a7cRight-Click to Delete");
            this.inventory.setItem(9 + i2, this.makeItem(iconMat, "\u00a76" + set.getId(), lore.toArray(new String[0])));
        }
    }

    private List<BuffedSet> getSortedSets() {
        ArrayList<BuffedSet> list = new ArrayList<BuffedSet>(this.plugin.getSetManager().getSets().values());
        list.sort(Comparator.comparing(BuffedSet::getId));
        return list;
    }
}

