/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.BuffedItems.menu.selector;

import io.github.altkat.BuffedItems.BuffedItems;
import io.github.altkat.BuffedItems.manager.config.ConfigManager;
import io.github.altkat.BuffedItems.menu.base.PaginatedMenu;
import io.github.altkat.BuffedItems.menu.passive.EffectListMenu;
import io.github.altkat.BuffedItems.menu.utility.PlayerMenuUtility;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffectType;

public class PotionEffectSelectorMenu
extends PaginatedMenu {
    private final BuffedItems plugin;
    private final List<PotionEffectType> effectTypes;

    public PotionEffectSelectorMenu(PlayerMenuUtility playerMenuUtility, BuffedItems plugin) {
        super(playerMenuUtility);
        this.plugin = plugin;
        this.effectTypes = Arrays.stream(PotionEffectType.values()).collect(Collectors.toList());
        this.maxItemsPerPage = 45;
    }

    @Override
    public String getMenuName() {
        return "Select an Effect (Page " + (this.page + 1) + ")";
    }

    @Override
    public int getSlots() {
        return 54;
    }

    @Override
    public void handleMenu(InventoryClickEvent e) {
        if (e.getCurrentItem() == null) {
            return;
        }
        int clickedSlot = e.getSlot();
        Material clickedType = e.getCurrentItem().getType();
        if (clickedSlot < this.maxItemsPerPage) {
            Player p = (Player)e.getWhoClicked();
            String effectName = e.getCurrentItem().getItemMeta().getDisplayName().substring(2);
            String targetSlot = this.playerMenuUtility.getTargetSlot();
            String prefix = "SET_BONUS".equals(targetSlot) ? "set.potion." : ("ACTIVE".equals(targetSlot) ? "active.potion_effects." : "potion_effects.");
            this.playerMenuUtility.setWaitingForChatInput(true);
            this.playerMenuUtility.setChatInputPath(prefix + "add." + effectName);
            p.closeInventory();
            p.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aPlease type the Potion Level (e.g., 1, 2, 5) in chat."));
            p.sendMessage(ConfigManager.fromSection("\u00a77(Type 'cancel' to exit)"));
            return;
        }
        if (this.handlePageChange(e, this.effectTypes.size())) {
            return;
        }
        if (clickedType == Material.BARRIER && clickedSlot == 49) {
            String targetSlot = this.playerMenuUtility.getTargetSlot();
            new EffectListMenu(this.playerMenuUtility, this.plugin, EffectListMenu.EffectType.POTION_EFFECT, targetSlot).open();
        }
    }

    @Override
    public void setMenuItems() {
        this.inventory.setItem(45, this.makeItem(Material.ARROW, "\u00a7aPrevious Page", new String[0]));
        this.inventory.setItem(53, this.makeItem(Material.ARROW, "\u00a7aNext Page", new String[0]));
        this.inventory.setItem(49, this.makeItem(Material.BARRIER, "\u00a7cBack to Effect List", new String[0]));
        for (int i = 0; i < this.maxItemsPerPage; ++i) {
            this.index = this.maxItemsPerPage * this.page + i;
            if (this.index >= this.effectTypes.size()) break;
            PotionEffectType currentType = this.effectTypes.get(this.index);
            if (currentType == null) continue;
            ItemStack itemStack = this.makeItem(Material.POTION, "\u00a7b" + currentType.getName(), "\u00a77Click to select this effect.");
            this.inventory.setItem(i, itemStack);
        }
    }
}

