/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.BuffedItems.menu.selector;

import io.github.altkat.BuffedItems.BuffedItems;
import io.github.altkat.BuffedItems.manager.config.ConfigManager;
import io.github.altkat.BuffedItems.manager.config.ItemsConfig;
import io.github.altkat.BuffedItems.menu.base.PaginatedMenu;
import io.github.altkat.BuffedItems.menu.editor.EnchantmentListMenu;
import io.github.altkat.BuffedItems.menu.selector.EnchantmentFinder;
import io.github.altkat.BuffedItems.menu.utility.PlayerMenuUtility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class EnchantmentSelectorMenu
extends PaginatedMenu {
    private final BuffedItems plugin;
    private List<Enchantment> enchantments;
    private List<Enchantment> filteredEnchantments;
    private final String itemId;
    private String searchQuery = "";
    private boolean isSearchMode = false;

    public EnchantmentSelectorMenu(PlayerMenuUtility playerMenuUtility, BuffedItems plugin) {
        super(playerMenuUtility);
        this.plugin = plugin;
        this.itemId = playerMenuUtility.getItemToEditId();
        this.enchantments = Arrays.stream(Enchantment.values()).filter(e -> e != null).sorted(Comparator.comparing(e -> e.getKey().getKey())).collect(Collectors.toList());
        this.filteredEnchantments = new ArrayList<Enchantment>(this.enchantments);
        this.maxItemsPerPage = 45;
    }

    @Override
    public String getMenuName() {
        if (this.isSearchMode && !this.searchQuery.isEmpty()) {
            return "Search: " + this.searchQuery + " (Found: " + this.filteredEnchantments.size() + ")";
        }
        return "Select Enchantment (Page " + (this.page + 1) + ")";
    }

    @Override
    public int getSlots() {
        return 54;
    }

    @Override
    public void handleMenu(InventoryClickEvent e) {
        if (e.getCurrentItem() == null) {
            return;
        }
        Player p = (Player)e.getWhoClicked();
        int clickedSlot = e.getSlot();
        Material clickedType = e.getCurrentItem().getType();
        if (clickedType == Material.COMPASS && clickedSlot == 51) {
            this.playerMenuUtility.setWaitingForChatInput(true);
            this.playerMenuUtility.setChatInputPath("enchantment_search");
            p.closeInventory();
            p.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aType the enchantment name to search (e.g., 'sharp', 'sharpness', 'quantum'):"));
            p.sendMessage(ConfigManager.fromSection("\u00a77Type 'clear' to clear search, 'cancel' to exit."));
            return;
        }
        if (clickedType == Material.BARRIER && clickedSlot == 52) {
            this.clearSearch();
            this.open();
            return;
        }
        if (clickedSlot < this.maxItemsPerPage && clickedType == Material.ENCHANTED_BOOK) {
            ItemMeta meta = e.getCurrentItem().getItemMeta();
            if (meta == null || meta.getLore() == null || meta.getLore().isEmpty()) {
                return;
            }
            Component loreLine = (Component)meta.lore().get(0);
            String rawEnchantName = ConfigManager.toPlainText(loreLine);
            if (!rawEnchantName.startsWith("ID: ")) {
                return;
            }
            String enchantKey = rawEnchantName.substring(4);
            Enchantment selectedEnchant = EnchantmentFinder.findEnchantment(enchantKey, this.plugin);
            if (selectedEnchant == null) {
                p.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cError: Could not identify selected enchantment '" + enchantKey + "'."));
                ConfigManager.sendDebugMessage(1, () -> "[EnchantmentSelector] Failed to find enchantment: " + enchantKey);
                return;
            }
            String configPath = "items." + this.itemId + ".enchantments";
            List currentEnchants = ItemsConfig.get().getStringList(configPath);
            boolean alreadyExists = currentEnchants.stream().anyMatch(s -> s.toUpperCase().startsWith(selectedEnchant.getName() + ";"));
            if (alreadyExists) {
                p.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cThis item already has the enchantment: " + selectedEnchant.getName()));
                p.playSound(p.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                return;
            }
            this.playerMenuUtility.setWaitingForChatInput(true);
            this.playerMenuUtility.setChatInputPath("enchantments.add." + selectedEnchant.getName());
            p.closeInventory();
            p.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aPlease type the Level for '" + selectedEnchant.getName() + "' in chat (e.g., 1, 5, 10)."));
            return;
        }
        if (this.handlePageChange(e, this.filteredEnchantments.size())) {
            return;
        }
        if (clickedType == Material.BARRIER && clickedSlot == 49) {
            new EnchantmentListMenu(this.playerMenuUtility, this.plugin).open();
            return;
        }
    }

    @Override
    public void setMenuItems() {
        int clearSlot;
        this.inventory.setItem(45, this.makeItem(Material.ARROW, "\u00a7aPrevious Page", new String[0]));
        this.inventory.setItem(53, this.makeItem(Material.ARROW, "\u00a7aNext Page", new String[0]));
        this.inventory.setItem(51, this.makeItem(Material.COMPASS, "\u00a7bSearch Enchantments", "\u00a77Current: " + (String)(this.searchQuery.isEmpty() ? "\u00a7cNone" : "\u00a7a" + this.searchQuery), "\u00a7eClick to search"));
        int n = clearSlot = this.isSearchMode && !this.searchQuery.isEmpty() ? 52 : -1;
        if (clearSlot != -1) {
            this.inventory.setItem(clearSlot, this.makeItem(Material.BARRIER, "\u00a7cClear Search", "\u00a77Reset to show all enchantments"));
        }
        this.inventory.setItem(49, this.makeItem(Material.BARRIER, "\u00a7cBack to Enchantment List", new String[0]));
        List<Enchantment> displayList = this.filteredEnchantments;
        for (int i = 0; i < this.maxItemsPerPage; ++i) {
            this.index = this.maxItemsPerPage * this.page + i;
            if (this.index >= displayList.size()) break;
            Enchantment currentEnchant = displayList.get(this.index);
            if (currentEnchant == null) continue;
            ArrayList<Object> lore = new ArrayList<Object>();
            lore.add("\u00a78ID: " + currentEnchant.getKey().getKey());
            lore.add("\u00a77Click to select this enchantment.");
            ItemStack itemStack = this.makeItem(Material.ENCHANTED_BOOK, "\u00a7b" + currentEnchant.getName(), lore.toArray(new String[0]));
            this.inventory.setItem(i, itemStack);
        }
        this.setFillerGlass();
    }

    public void searchEnchantments(String query) {
        if (query == null || query.isEmpty() || query.equalsIgnoreCase("clear")) {
            this.clearSearch();
            return;
        }
        this.searchQuery = query.toLowerCase().trim();
        this.isSearchMode = true;
        this.page = 0;
        this.filteredEnchantments = this.enchantments.stream().filter(e -> e != null && (e.getName().toLowerCase().contains(this.searchQuery) || e.getKey().getKey().toLowerCase().contains(this.searchQuery))).collect(Collectors.toList());
        ConfigManager.sendDebugMessage(3, () -> "[EnchantmentSearch] Search for '" + this.searchQuery + "' returned " + this.filteredEnchantments.size() + " results");
    }

    public void clearSearch() {
        this.searchQuery = "";
        this.isSearchMode = false;
        this.page = 0;
        this.filteredEnchantments = new ArrayList<Enchantment>(this.enchantments);
    }
}

