/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.BuffedItems.menu.selector;

import io.github.altkat.BuffedItems.BuffedItems;
import io.github.altkat.BuffedItems.menu.base.PaginatedMenu;
import io.github.altkat.BuffedItems.menu.passive.EffectListMenu;
import io.github.altkat.BuffedItems.menu.selector.AttributeOperationSelectorMenu;
import io.github.altkat.BuffedItems.menu.utility.PlayerMenuUtility;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class AttributeSelectorMenu
extends PaginatedMenu {
    private final BuffedItems plugin;
    private final List<Attribute> attributes;

    public AttributeSelectorMenu(PlayerMenuUtility playerMenuUtility, BuffedItems plugin) {
        super(playerMenuUtility);
        this.plugin = plugin;
        this.attributes = Arrays.stream(Attribute.values()).collect(Collectors.toList());
        this.maxItemsPerPage = 45;
    }

    @Override
    public String getMenuName() {
        return "Select an Attribute (Page " + (this.page + 1) + ")";
    }

    @Override
    public int getSlots() {
        return 54;
    }

    @Override
    public void handleMenu(InventoryClickEvent e) {
        if (e.getCurrentItem() == null) {
            return;
        }
        int clickedSlot = e.getSlot();
        Material clickedType = e.getCurrentItem().getType();
        if (clickedSlot < this.maxItemsPerPage) {
            String attributeName = e.getCurrentItem().getItemMeta().getDisplayName().substring(2);
            this.playerMenuUtility.setAttributeToEdit(attributeName);
            new AttributeOperationSelectorMenu(this.playerMenuUtility, this.plugin).open();
            return;
        }
        if (this.handlePageChange(e, this.attributes.size())) {
            return;
        }
        if (clickedType == Material.BARRIER && clickedSlot == 49) {
            String targetSlot = this.playerMenuUtility.getTargetSlot();
            new EffectListMenu(this.playerMenuUtility, this.plugin, EffectListMenu.EffectType.ATTRIBUTE, targetSlot).open();
        }
    }

    @Override
    public void setMenuItems() {
        this.inventory.setItem(45, this.makeItem(Material.ARROW, "\u00a7aPrevious Page", new String[0]));
        this.inventory.setItem(53, this.makeItem(Material.ARROW, "\u00a7aNext Page", new String[0]));
        this.inventory.setItem(49, this.makeItem(Material.BARRIER, "\u00a7cBack to Attribute List", new String[0]));
        for (int i = 0; i < this.maxItemsPerPage; ++i) {
            this.index = this.maxItemsPerPage * this.page + i;
            if (this.index >= this.attributes.size()) break;
            Attribute currentAttribute = this.attributes.get(this.index);
            if (currentAttribute == null) continue;
            ItemStack itemStack = this.makeItem(Material.IRON_CHESTPLATE, "\u00a7b" + currentAttribute.name(), "\u00a77Click to select this attribute.");
            this.inventory.setItem(i, itemStack);
        }
    }
}

