/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.BuffedItems.menu.selector;

import io.github.altkat.BuffedItems.BuffedItems;
import io.github.altkat.BuffedItems.manager.config.ConfigManager;
import io.github.altkat.BuffedItems.menu.base.Menu;
import io.github.altkat.BuffedItems.menu.selector.AttributeSelectorMenu;
import io.github.altkat.BuffedItems.menu.utility.PlayerMenuUtility;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;

public class AttributeOperationSelectorMenu
extends Menu {
    private final BuffedItems plugin;

    public AttributeOperationSelectorMenu(PlayerMenuUtility playerMenuUtility, BuffedItems plugin) {
        super(playerMenuUtility);
        this.plugin = plugin;
    }

    @Override
    public String getMenuName() {
        return "Select an Operation";
    }

    @Override
    public int getSlots() {
        return 27;
    }

    @Override
    public void handleMenu(InventoryClickEvent e) {
        if (e.getCurrentItem() == null) {
            return;
        }
        if (e.getCurrentItem().getType() == Material.BARRIER || e.getCurrentItem().getType() == Material.BLACK_STAINED_GLASS_PANE) {
            if (e.getCurrentItem().getType() == Material.BARRIER) {
                new AttributeSelectorMenu(this.playerMenuUtility, this.plugin).open();
            }
            return;
        }
        Player p = (Player)e.getWhoClicked();
        String operationName = e.getCurrentItem().getItemMeta().getDisplayName().substring(2);
        String attributeName = this.playerMenuUtility.getAttributeToEdit();
        this.playerMenuUtility.setWaitingForChatInput(true);
        String targetSlot = this.playerMenuUtility.getTargetSlot();
        String prefix = "SET_BONUS".equals(targetSlot) ? "set.attribute." : ("ACTIVE".equals(targetSlot) ? "active.attributes." : "attributes.");
        this.playerMenuUtility.setChatInputPath(prefix + "add." + attributeName + "." + operationName);
        p.closeInventory();
        p.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aPlease type the Amount (e.g., 2.0, -1.5, 0.1) in chat."));
        p.sendMessage(ConfigManager.fromSection("\u00a77(Type 'cancel' to exit)"));
    }

    @Override
    public void setMenuItems() {
        this.inventory.setItem(11, this.makeItem(Material.GREEN_WOOL, "\u00a7aADD_NUMBER", "\u00a77Adds a flat value."));
        this.inventory.setItem(13, this.makeItem(Material.YELLOW_WOOL, "\u00a7eADD_SCALAR", "\u00a77Adds a percentage of the base value."));
        this.inventory.setItem(15, this.makeItem(Material.RED_WOOL, "\u00a7cMULTIPLY_SCALAR_1", "\u00a77Multiplies the final value."));
        this.addBackButton(new AttributeSelectorMenu(this.playerMenuUtility, this.plugin));
        this.setFillerGlass();
    }
}

