/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.BuffedItems.menu.passive;

import io.github.altkat.BuffedItems.BuffedItems;
import io.github.altkat.BuffedItems.manager.config.ConfigManager;
import io.github.altkat.BuffedItems.menu.base.Menu;
import io.github.altkat.BuffedItems.menu.editor.ItemEditorMenu;
import io.github.altkat.BuffedItems.menu.passive.SlotSelectionMenu;
import io.github.altkat.BuffedItems.menu.utility.PlayerMenuUtility;
import io.github.altkat.BuffedItems.utility.item.BuffedItem;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;

public class PassiveItemSettingsMenu
extends Menu {
    private final BuffedItems plugin;
    private final String itemId;

    public PassiveItemSettingsMenu(PlayerMenuUtility playerMenuUtility, BuffedItems plugin) {
        super(playerMenuUtility);
        this.plugin = plugin;
        this.itemId = playerMenuUtility.getItemToEditId();
    }

    @Override
    public String getMenuName() {
        return "Passive Effects: " + this.itemId;
    }

    @Override
    public int getSlots() {
        return 27;
    }

    @Override
    public void handleMenu(InventoryClickEvent e) {
        if (e.getCurrentItem() == null) {
            return;
        }
        Material type = e.getCurrentItem().getType();
        Player p = (Player)e.getWhoClicked();
        if (e.getSlot() == 8) {
            BuffedItem item = this.plugin.getItemManager().getBuffedItem(this.itemId);
            if (item != null) {
                BuffedItem.AttributeMode current = item.getAttributeMode();
                BuffedItem.AttributeMode next = current == BuffedItem.AttributeMode.STATIC ? BuffedItem.AttributeMode.DYNAMIC : BuffedItem.AttributeMode.STATIC;
                ConfigManager.setItemValue(item.getId(), "attribute_mode", next.name());
                p.playSound(p.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
                this.open();
            }
            return;
        }
        if (type == Material.BARRIER) {
            new ItemEditorMenu(this.playerMenuUtility, this.plugin).open();
            return;
        }
        switch (type) {
            case POTION: {
                new SlotSelectionMenu(this.playerMenuUtility, this.plugin, SlotSelectionMenu.MenuType.POTION_EFFECT).open();
                break;
            }
            case IRON_SWORD: {
                new SlotSelectionMenu(this.playerMenuUtility, this.plugin, SlotSelectionMenu.MenuType.ATTRIBUTE).open();
            }
        }
    }

    @Override
    public void setMenuItems() {
        this.setFillerGlass();
        BuffedItem item = this.plugin.getItemManager().getBuffedItem(this.itemId);
        if (item != null) {
            BuffedItem.AttributeMode attrMode = item.getAttributeMode();
            String modeColor = attrMode == BuffedItem.AttributeMode.DYNAMIC ? "\u00a7b" : "\u00a77";
            Material modeIcon = attrMode == BuffedItem.AttributeMode.DYNAMIC ? Material.GOLD_BLOCK : Material.IRON_BLOCK;
            this.inventory.setItem(8, this.makeItem(modeIcon, "\u00a76Attribute Mode", "\u00a77Current: " + modeColor + attrMode.name(), "", "\u00a7fSTATIC (Iron): \u00a77Native NBT Attributes.", "\u00a77\u2714 \u00a7aBest Performance (Zero Latency)", "\u00a77\u2714 \u00a7aUniversal (NPCs, Minions)", "\u00a77\u2716 \u00a7cIgnores Passive Permissions", "", "\u00a7bDYNAMIC (Gold): \u00a77Plugin Managed.", "\u00a77\u2714 \u00a7bEnforces Permissions", "\u00a77\u2716 \u00a7cReal Players Only", "\u00a77\u2716 \u00a7cSlight Update Delay (Task)", "", "\u00a7eClick to Toggle"));
        }
        this.inventory.setItem(11, this.makeItem(Material.POTION, "\u00a7aPassive Potion Effects", "\u00a77Add constant potion effects like", "\u00a77Speed, Jump Boost, etc.", "", "\u00a77(Requires selecting a slot)", "\u00a7eClick to Edit"));
        this.inventory.setItem(15, this.makeItem(Material.IRON_SWORD, "\u00a7bPassive Attributes", "\u00a77Add permanent stats like", "\u00a77Max Health, Damage, Speed, etc.", "", "\u00a77(Requires selecting a slot)", "\u00a7eClick to Edit"));
        this.inventory.setItem(26, this.makeItem(Material.BARRIER, "\u00a7cBack to Main Editor", new String[0]));
    }
}

