/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.BuffedItems.menu.editor;

import io.github.altkat.BuffedItems.BuffedItems;
import io.github.altkat.BuffedItems.manager.config.ConfigManager;
import io.github.altkat.BuffedItems.menu.base.Menu;
import io.github.altkat.BuffedItems.menu.editor.ItemEditorMenu;
import io.github.altkat.BuffedItems.menu.utility.ItemListMenu;
import io.github.altkat.BuffedItems.menu.utility.PlayerMenuUtility;
import io.github.altkat.BuffedItems.utility.item.BuffedItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemFlagsMenu
extends Menu {
    private final BuffedItems plugin;
    private final String itemId;
    private final List<FlagInfo> flags = Arrays.asList(new FlagInfo("HIDE_ATTRIBUTES", Material.BOOK, "Hide Attributes", "Hides default attribute modifier text (e.g., '+5 Attack Damage')."), new FlagInfo("HIDE_ENCHANTS", Material.ENCHANTING_TABLE, "Hide Enchants", "Hides the enchantment list text."), new FlagInfo("HIDE_UNBREAKABLE", Material.BEDROCK, "Hide Unbreakable", "Hides the 'Unbreakable' text."), new FlagInfo("HIDE_ADDITIONAL_TOOLTIP", Material.POTION, "Hide Additional Tooltip", "Hides additional tooltip text on Potions, Arrows, Stew."), new FlagInfo("HIDE_DESTROYS", Material.IRON_PICKAXE, "Hide Destroys", "Hides 'Can Destroy:' list (Adventure mode)."), new FlagInfo("HIDE_PLACED_ON", Material.STONE, "Hide Placed On", "Hides 'Can Be Placed On:' list (Adventure mode)."), new FlagInfo("PREVENT_ANVIL_USE", Material.CHAINMAIL_CHESTPLATE, "Prevent Anvil Use", "Prevents renaming, repairing, or combining in an anvil."), new FlagInfo("PREVENT_ENCHANT_TABLE", Material.LAPIS_LAZULI, "Prevent Enchant Table", "Prevents placing the item in an enchanting table."), new FlagInfo("PREVENT_SMITHING_USE", Material.SMITHING_TABLE, "Prevent Smithing Use", "Prevents using the item in a smithing table."), new FlagInfo("HIDE_ARMOR_TRIM", Material.PINK_DYE, "Hide Armor Trim", "Hides 'Upgrade: ...' trim details."), new FlagInfo("PREVENT_CRAFTING_USE", Material.CRAFTING_TABLE, "Prevent Crafting Use", "Prevents using the item as a crafting ingredient."), new FlagInfo("PREVENT_DROP", Material.DROPPER, "Prevent Drop/Store", "Prevents dropping (Q/drag), storing in containers, or item frames."), new FlagInfo("PREVENT_CONSUME", Material.APPLE, "Prevent Consumption", "Prevents eating, drinking (potions), or consuming."), new FlagInfo("UNBREAKABLE", Material.ANVIL, "Unbreakable", "Prevents the item from losing durability."), new FlagInfo("PREVENT_PLACEMENT", Material.GRASS_BLOCK, "Prevent Placement", "Prevents placing blocks, boats, carts, armor stands, frames, etc."), new FlagInfo("PREVENT_DEATH_DROP", Material.TOTEM_OF_UNDYING, "Prevent Death Drop", "Keeps the item in inventory upon death."), new FlagInfo("PREVENT_INTERACT", Material.STRUCTURE_VOID, "Prevent Use (Right-Click)", "Prevents most right-clicks (axe strip, hoe till, flint&steel, shield, etc.)."), new FlagInfo("LOST_ON_DEATH", Material.WITHER_ROSE, "Lost On Death", "Item is permanently destroyed/vanishes upon death."));

    public ItemFlagsMenu(PlayerMenuUtility playerMenuUtility, BuffedItems plugin) {
        super(playerMenuUtility);
        this.plugin = plugin;
        this.itemId = playerMenuUtility.getItemToEditId();
    }

    @Override
    public String getMenuName() {
        return "Editing Flags for: " + this.itemId;
    }

    @Override
    public int getSlots() {
        return 45;
    }

    @Override
    public void handleMenu(InventoryClickEvent e) {
        int flagIndex;
        int clickedSlot;
        Player p = (Player)e.getWhoClicked();
        if (e.getCurrentItem() == null) {
            return;
        }
        Material clickedType = e.getCurrentItem().getType();
        if (clickedType == Material.BARRIER && e.getSlot() == this.getSlots() - 1) {
            new ItemEditorMenu(this.playerMenuUtility, this.plugin).open();
            return;
        }
        if (clickedType == Material.BLACK_STAINED_GLASS_PANE) {
            return;
        }
        List<Integer> itemSlots = Arrays.asList(10, 11, 12, 13, 14, 15, 16, 19, 20, 21, 22, 23, 24, 25, 28, 29, 30, 31, 32, 33, 34);
        if (itemSlots.contains(clickedSlot = e.getSlot()) && (flagIndex = itemSlots.indexOf(clickedSlot)) >= 0 && flagIndex < this.flags.size()) {
            FlagInfo flag = this.flags.get(flagIndex);
            String clickedFlagName = flag.id;
            BuffedItem item = this.plugin.getItemManager().getBuffedItem(this.itemId);
            boolean currentValue = item.getFlag(clickedFlagName);
            boolean newValue = !currentValue;
            String configPath = "flags." + clickedFlagName.toUpperCase();
            ConfigManager.setItemValue(this.itemId, configPath, newValue);
            p.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aFlag '" + clickedFlagName + "' set to " + (newValue ? "\u00a7aEnabled" : "\u00a7cDisabled")));
            this.open();
        }
    }

    @Override
    public void setMenuItems() {
        int i;
        BuffedItem item = this.plugin.getItemManager().getBuffedItem(this.itemId);
        if (item == null) {
            this.playerMenuUtility.getOwner().sendMessage("\u00a7cError: Item not found.");
            new ItemListMenu(this.playerMenuUtility, this.plugin).open();
            return;
        }
        ItemStack filler = this.makeItem(Material.BLACK_STAINED_GLASS_PANE, " ", new String[0]);
        for (i = 0; i < 9; ++i) {
            this.inventory.setItem(i, filler);
        }
        for (i = 36; i < 44; ++i) {
            this.inventory.setItem(i, filler);
        }
        this.inventory.setItem(9, filler);
        this.inventory.setItem(17, filler);
        this.inventory.setItem(18, filler);
        this.inventory.setItem(26, filler);
        this.inventory.setItem(27, filler);
        this.inventory.setItem(35, filler);
        List<Integer> itemSlots = Arrays.asList(10, 11, 12, 13, 14, 15, 16, 19, 20, 21, 22, 23, 24, 25, 28, 29, 30, 31, 32, 33, 34);
        for (int i2 = 0; i2 < this.flags.size() && i2 < itemSlots.size(); ++i2) {
            FlagInfo flag = this.flags.get(i2);
            boolean isEnabled = item.getFlag(flag.id);
            String status = isEnabled ? "\u00a7aEnabled" : "\u00a7cDisabled";
            ArrayList<Object> lore = new ArrayList<Object>();
            lore.add("\u00a77" + flag.description);
            lore.add("");
            lore.add("\u00a77Status: " + status);
            lore.add("\u00a77Internal ID: " + flag.id);
            lore.add("");
            lore.add("\u00a7aClick to " + (isEnabled ? "Disable" : "Enable"));
            ItemStack itemStack = this.makeItem(flag.icon, "\u00a7e" + flag.displayName, lore.toArray(new String[0]));
            if (isEnabled) {
                ItemMeta meta = itemStack.getItemMeta();
                meta.addEnchant(Enchantment.LUCK_OF_THE_SEA, 1, false);
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                itemStack.setItemMeta(meta);
            }
            this.inventory.setItem(itemSlots.get(i2).intValue(), itemStack);
        }
        this.addBackButton(new ItemEditorMenu(this.playerMenuUtility, this.plugin));
    }

    private static class FlagInfo {
        final String id;
        final Material icon;
        final String displayName;
        final String description;

        FlagInfo(String id, Material icon, String displayName, String description) {
            this.id = id;
            this.icon = icon;
            this.displayName = displayName;
            this.description = description;
        }
    }
}

