/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.BuffedItems.menu.crafting;

import io.github.altkat.BuffedItems.BuffedItems;
import io.github.altkat.BuffedItems.manager.config.ConfigManager;
import io.github.altkat.BuffedItems.manager.crafting.CustomRecipe;
import io.github.altkat.BuffedItems.menu.base.PaginatedMenu;
import io.github.altkat.BuffedItems.menu.crafting.RecipePreviewMenu;
import io.github.altkat.BuffedItems.menu.utility.PlayerMenuUtility;
import io.github.altkat.BuffedItems.utility.item.BuffedItem;
import io.github.altkat.BuffedItems.utility.item.ItemBuilder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class PublicRecipeListMenu
extends PaginatedMenu {
    private final BuffedItems plugin;

    public PublicRecipeListMenu(PlayerMenuUtility playerMenuUtility, BuffedItems plugin) {
        super(playerMenuUtility);
        this.plugin = plugin;
        this.maxItemsPerPage = 36;
    }

    @Override
    public String getMenuName() {
        return "Server Recipes (Page " + (this.page + 1) + ")";
    }

    @Override
    public int getSlots() {
        return 54;
    }

    @Override
    public void handleMenu(InventoryClickEvent e) {
        List<CustomRecipe> recipes = this.getValidRecipes();
        if (e.getCurrentItem() == null) {
            return;
        }
        if (this.handlePageChange(e, recipes.size())) {
            return;
        }
        if (e.getSlot() == 49) {
            e.getWhoClicked().closeInventory();
            return;
        }
        if (e.getSlot() >= 9 && e.getSlot() < 45) {
            int index = this.maxItemsPerPage * this.page + (e.getSlot() - 9);
            if (index >= recipes.size()) {
                return;
            }
            CustomRecipe recipe = recipes.get(index);
            new RecipePreviewMenu(this.playerMenuUtility, this.plugin, recipe).open();
        }
    }

    @Override
    public void setMenuItems() {
        int index;
        int i;
        ItemStack filler = this.makeItem(Material.BLACK_STAINED_GLASS_PANE, " ", new String[0]);
        for (i = 0; i < 9; ++i) {
            this.inventory.setItem(i, filler);
        }
        for (i = 45; i < 54; ++i) {
            this.inventory.setItem(i, filler);
        }
        this.addMenuControls();
        this.inventory.setItem(49, this.makeItem(Material.BARRIER, "\u00a7cClose Menu", new String[0]));
        List<CustomRecipe> recipes = this.getValidRecipes();
        for (int i2 = 0; i2 < this.maxItemsPerPage && (index = this.maxItemsPerPage * this.page + i2) < recipes.size(); ++i2) {
            CustomRecipe recipe = recipes.get(index);
            BuffedItem item = this.plugin.getItemManager().getBuffedItem(recipe.getResultItemId());
            ItemStack icon = item != null ? new ItemBuilder(item, (Plugin)this.plugin).build() : this.makeItem(Material.CHEST, "\u00a7f" + recipe.getId(), new String[0]);
            ItemMeta meta = icon.getItemMeta();
            if (meta != null) {
                ArrayList<Object> lore = new ArrayList<Object>();
                lore.add(Component.empty());
                lore.add(ConfigManager.fromSection("\u00a7eClick to view recipe"));
                meta.lore(lore);
                icon.setItemMeta(meta);
            }
            icon.setAmount(1);
            this.inventory.setItem(9 + i2, icon);
        }
    }

    private List<CustomRecipe> getValidRecipes() {
        return this.plugin.getCraftingManager().getRecipes().values().stream().filter(CustomRecipe::isValid).sorted(Comparator.comparing(CustomRecipe::getId)).collect(Collectors.toList());
    }
}

