/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.BuffedItems.menu.crafting;

import io.github.altkat.BuffedItems.BuffedItems;
import io.github.altkat.BuffedItems.manager.config.ConfigManager;
import io.github.altkat.BuffedItems.manager.config.RecipesConfig;
import io.github.altkat.BuffedItems.manager.crafting.CustomRecipe;
import io.github.altkat.BuffedItems.manager.crafting.MatchType;
import io.github.altkat.BuffedItems.manager.crafting.RecipeIngredient;
import io.github.altkat.BuffedItems.menu.base.Menu;
import io.github.altkat.BuffedItems.menu.crafting.RecipeEditorMenu;
import io.github.altkat.BuffedItems.menu.selector.BuffedItemSelectorMenu;
import io.github.altkat.BuffedItems.menu.selector.MaterialSelectorMenu;
import io.github.altkat.BuffedItems.menu.utility.PlayerMenuUtility;
import io.github.altkat.BuffedItems.utility.Serializer;
import io.github.altkat.BuffedItems.utility.item.BuffedItem;
import io.github.altkat.BuffedItems.utility.item.ItemBuilder;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class IngredientSettingsMenu
extends Menu {
    private final BuffedItems plugin;
    private final String recipeId;
    private final int slotIndex;
    private final boolean processSelection;

    public IngredientSettingsMenu(PlayerMenuUtility playerMenuUtility, BuffedItems plugin) {
        this(playerMenuUtility, plugin, false);
    }

    public IngredientSettingsMenu(PlayerMenuUtility playerMenuUtility, BuffedItems plugin, boolean processSelection) {
        super(playerMenuUtility);
        this.plugin = plugin;
        this.recipeId = playerMenuUtility.getRecipeToEditId();
        this.slotIndex = playerMenuUtility.getSelectedRecipeSlot();
        this.processSelection = processSelection;
    }

    @Override
    public String getMenuName() {
        return "Edit Slot: " + this.slotIndex;
    }

    @Override
    public int getSlots() {
        return 27;
    }

    @Override
    public void open() {
        if (this.processSelection) {
            if (this.playerMenuUtility.getTempMaterial() != null) {
                this.saveIngredient(MatchType.MATERIAL, this.playerMenuUtility.getTempMaterial(), this.playerMenuUtility.getTempMaterial().name(), 1);
                this.playerMenuUtility.setTempMaterial(null);
            } else if (this.playerMenuUtility.getTempId() != null) {
                BuffedItem bi = this.plugin.getItemManager().getBuffedItem(this.playerMenuUtility.getTempId());
                Material mat = bi != null ? bi.getMaterial() : Material.BARRIER;
                this.saveIngredient(MatchType.BUFFED_ITEM, mat, this.playerMenuUtility.getTempId(), 1);
                this.playerMenuUtility.setTempId(null);
            }
        }
        super.open();
    }

    @Override
    public void handleMenu(InventoryClickEvent e) {
        Player p = (Player)e.getWhoClicked();
        if (e.getCurrentItem() == null) {
            return;
        }
        if (e.getSlot() == 10) {
            this.handleScanHand(p);
        } else if (e.getSlot() == 11) {
            ItemStack hand = p.getInventory().getItemInMainHand();
            if (hand == null || hand.getType().isAir()) {
                p.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cHand is empty!"));
            } else {
                String base64 = Serializer.toBase64(hand);
                this.saveIngredient(MatchType.EXACT, hand.getType(), base64, 1);
                p.playSound(p.getLocation(), Sound.BLOCK_ENCHANTMENT_TABLE_USE, 1.0f, 1.0f);
                new IngredientSettingsMenu(this.playerMenuUtility, this.plugin).open();
            }
        } else if (e.getSlot() == 12) {
            this.playerMenuUtility.setMaterialContext(PlayerMenuUtility.MaterialSelectionContext.CRAFTING_INGREDIENT);
            new MaterialSelectorMenu(this.playerMenuUtility, this.plugin).open();
        } else if (e.getSlot() == 13) {
            new BuffedItemSelectorMenu(this.playerMenuUtility, this.plugin, BuffedItemSelectorMenu.SelectionContext.CRAFTING_INGREDIENT).open();
        } else if (e.getSlot() == 15) {
            this.playerMenuUtility.setWaitingForChatInput(true);
            this.playerMenuUtility.setChatInputPath("recipe_ingredient_amount");
            p.closeInventory();
            p.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aEnter required amount in chat."));
        } else if (e.getSlot() == 16) {
            this.saveIngredient(null, null, null, 1);
            p.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aSlot cleared."));
            new RecipeEditorMenu(this.playerMenuUtility, this.plugin).open();
        } else if (e.getSlot() == 26) {
            new RecipeEditorMenu(this.playerMenuUtility, this.plugin).open();
        }
    }

    private void handleScanHand(Player p) {
        MatchType detectedType;
        String detectedValue;
        ItemStack item = p.getInventory().getItemInMainHand();
        if (item == null || item.getType().isAir()) {
            p.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cHand is empty!"));
            return;
        }
        Material displayMat = item.getType();
        int amount = 1;
        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "buffeditem_id");
        if (item.hasItemMeta() && item.getItemMeta().getPersistentDataContainer().has(key, PersistentDataType.STRING)) {
            detectedValue = (String)item.getItemMeta().getPersistentDataContainer().get(key, PersistentDataType.STRING);
            detectedType = MatchType.BUFFED_ITEM;
        } else {
            detectedValue = item.getType().name();
            detectedType = MatchType.MATERIAL;
        }
        this.saveIngredient(detectedType, displayMat, detectedValue, amount);
        p.playSound(p.getLocation(), Sound.BLOCK_NOTE_BLOCK_PLING, 1.0f, 2.0f);
        new IngredientSettingsMenu(this.playerMenuUtility, this.plugin).open();
    }

    private void saveIngredient(MatchType type, Material mat, String value, int amount) {
        char key = (char)(65 + this.slotIndex);
        String path = "recipes." + this.recipeId + ".ingredients." + key;
        String shapePath = "recipes." + this.recipeId + ".shape";
        FileConfiguration config = RecipesConfig.get();
        if (type == null) {
            config.set(path, null);
        } else {
            config.set(path + ".type", (Object)type.name());
            config.set(path + ".value", (Object)value);
            config.set(path + ".amount", (Object)amount);
        }
        List rawShape = config.getStringList(shapePath);
        ArrayList<String> shape = new ArrayList<String>();
        for (int i = 0; i < 3; ++i) {
            String line;
            String string = line = i < rawShape.size() ? (String)rawShape.get(i) : "   ";
            if (line == null) {
                line = "   ";
            }
            StringBuilder sb = new StringBuilder(line);
            while (sb.length() < 3) {
                sb.append(" ");
            }
            if (sb.length() > 3) {
                sb.setLength(3);
            }
            shape.add(sb.toString());
        }
        int row = this.slotIndex / 3;
        int col = this.slotIndex % 3;
        StringBuilder targetLine = new StringBuilder((String)shape.get(row));
        targetLine.setCharAt(col, type == null ? (char)' ' : (char)key);
        shape.set(row, targetLine.toString());
        config.set(shapePath, shape);
        RecipesConfig.save();
        this.plugin.getCraftingManager().loadRecipes(true);
    }

    @Override
    public void setMenuItems() {
        ItemStack currentIcon;
        Component displayName;
        this.setFillerGlass();
        CustomRecipe recipe = this.plugin.getCraftingManager().getRecipes().get(this.recipeId);
        RecipeIngredient ing = null;
        if (recipe != null) {
            String rowStr;
            List<String> shape = recipe.getShape();
            int row = this.slotIndex / 3;
            int col = this.slotIndex % 3;
            if (shape != null && shape.size() > row && (rowStr = shape.get(row)).length() > col) {
                char key = rowStr.charAt(col);
                ing = recipe.getIngredient(key);
            }
        }
        ArrayList<Component> lore = new ArrayList<Component>();
        if (ing != null) {
            displayName = ConfigManager.fromSection("\u00a7aCurrent Ingredient");
            Material mat = ing.getMaterial() != null ? ing.getMaterial() : Material.BARRIER;
            currentIcon = new ItemStack(mat);
            if (ing.getMatchType() == MatchType.BUFFED_ITEM) {
                BuffedItem bi = this.plugin.getItemManager().getBuffedItem(ing.getData());
                if (bi != null) {
                    currentIcon = new ItemBuilder(bi, (Plugin)this.plugin).build();
                }
            } else if (ing.getMatchType() == MatchType.EXACT && ing.getExactReferenceItem() != null) {
                currentIcon = ing.getExactReferenceItem().clone();
            }
            lore.add(ConfigManager.fromSection("\u00a77Type: " + ing.getMatchType().name()));
            if (ing.getMatchType() != MatchType.EXACT) {
                lore.add(ConfigManager.fromSection("\u00a77Value: " + ing.getData()));
            } else {
                lore.add(ConfigManager.fromSection("\u00a77Value: (Exact NBT Data)"));
            }
            lore.add(ConfigManager.fromSection("\u00a77Amount: \u00a7e" + ing.getAmount()));
            currentIcon.setAmount(Math.max(1, ing.getAmount()));
        } else {
            displayName = ConfigManager.fromSection("\u00a7cEmpty Slot");
            currentIcon = new ItemStack(Material.BARRIER);
            lore.add(ConfigManager.fromSection("\u00a77No item set."));
        }
        ItemMeta meta = currentIcon.getItemMeta();
        if (meta != null) {
            meta.displayName(displayName);
            meta.lore(lore);
            currentIcon.setItemMeta(meta);
        }
        this.inventory.setItem(4, currentIcon);
        this.inventory.setItem(10, this.makeItem(Material.HOPPER, "\u00a7bScan Hand", "\u00a77Detect item from hand."));
        this.inventory.setItem(11, this.makeItem(Material.ENDER_EYE, "\u00a75Scan as EXACT", "\u00a77Saves the item in your hand", "\u00a77with ALL metadata (Name, Lore, NBT).", "\u00a77Useful for special vanilla items."));
        this.inventory.setItem(12, this.makeItem(Material.GRASS_BLOCK, "\u00a7aVanilla Material", "\u00a77Select from list."));
        this.inventory.setItem(13, this.makeItem(Material.NETHER_STAR, "\u00a76Buffed Item", "\u00a77Select custom item."));
        this.inventory.setItem(15, this.makeItem(Material.GOLD_NUGGET, "\u00a7eSet Amount", "\u00a77Current: " + (ing != null ? ing.getAmount() : 1)));
        this.inventory.setItem(16, this.makeItem(Material.RED_STAINED_GLASS_PANE, "\u00a7cClear Slot", new String[0]));
        this.inventory.setItem(26, this.makeItem(Material.BARRIER, "\u00a7cBack", new String[0]));
    }
}

