/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.BuffedItems.menu.active;

import io.github.altkat.BuffedItems.BuffedItems;
import io.github.altkat.BuffedItems.manager.config.ConfigManager;
import io.github.altkat.BuffedItems.menu.active.ActiveItemSettingsMenu;
import io.github.altkat.BuffedItems.menu.active.UsageLimitSettingsMenu;
import io.github.altkat.BuffedItems.menu.base.PaginatedMenu;
import io.github.altkat.BuffedItems.menu.utility.PlayerMenuUtility;
import io.github.altkat.BuffedItems.utility.item.BuffedItem;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class CommandListMenu
extends PaginatedMenu {
    private final BuffedItems plugin;
    private final String itemId;
    private final CommandContext context;

    public CommandListMenu(PlayerMenuUtility playerMenuUtility, BuffedItems plugin, CommandContext context) {
        super(playerMenuUtility);
        this.plugin = plugin;
        this.itemId = playerMenuUtility.getItemToEditId();
        this.context = context;
        this.maxItemsPerPage = 36;
    }

    @Override
    public String getMenuName() {
        return this.context.title + ": " + this.itemId;
    }

    @Override
    public int getSlots() {
        return 54;
    }

    @Override
    public void handleMenu(InventoryClickEvent e) {
        ArrayList<String> commands;
        Player p = (Player)e.getWhoClicked();
        BuffedItem item = this.plugin.getItemManager().getBuffedItem(this.itemId);
        if (item == null) {
            return;
        }
        ArrayList<String> arrayList = commands = this.context == CommandContext.ACTIVE ? new ArrayList<String>(item.getActiveCommands()) : new ArrayList<String>(item.getDepletionCommands());
        if (this.handlePageChange(e, commands.size())) {
            return;
        }
        if (e.getCurrentItem() == null) {
            return;
        }
        Material type = e.getCurrentItem().getType();
        if (type == Material.BARRIER && e.getSlot() == 53) {
            if (this.context == CommandContext.ACTIVE) {
                new ActiveItemSettingsMenu(this.playerMenuUtility, this.plugin).open();
            } else {
                new UsageLimitSettingsMenu(this.playerMenuUtility, this.plugin).open();
            }
            return;
        }
        if (type == Material.ANVIL && e.getSlot() == 49) {
            this.playerMenuUtility.setWaitingForChatInput(true);
            this.playerMenuUtility.setChatInputPath(this.context.chatPrefix + "add");
            p.closeInventory();
            p.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aEnter the command in chat."));
            p.sendMessage(ConfigManager.fromSection("\u00a76Logic Prefixes:"));
            p.sendMessage(ConfigManager.fromSection("\u00a7f[console], [chance:50], [delay:20], [else]"));
            p.sendMessage(ConfigManager.fromSection("\u00a76Actions:"));
            p.sendMessage(ConfigManager.fromSection("\u00a7f[message], [title], [actionbar], [sound]"));
            p.sendMessage(ConfigManager.fromSection("\u00a76Variables & PAPI:"));
            p.sendMessage(ConfigManager.fromSection("\u00a7eInternals: \u00a7f%player%, %player_x%, %player_yaw%..."));
            p.sendMessage(ConfigManager.fromSection("\u00a7ePAPI Supported! \u00a7f(e.g %vault_eco_balance%)"));
            p.sendMessage(ConfigManager.fromSection("\u00a76Chaining:"));
            p.sendMessage(ConfigManager.fromSection("\u00a7fUse '\u00a7e;;\u00a7f' to separate commands."));
            p.sendMessage(ConfigManager.fromSection(""));
            p.sendMessage(ConfigManager.fromSection("\u00a7eFor full guide use: \u00a76/buffeditems wiki"));
            p.sendMessage(ConfigManager.fromSection("\u00a77(Type 'cancel' to exit)"));
            return;
        }
        if (e.getSlot() >= 9 && e.getSlot() < 45) {
            int slotIndex = e.getSlot() - 9;
            int commandIndex = this.maxItemsPerPage * this.page + slotIndex;
            if (commandIndex >= commands.size() || commandIndex < 0) {
                return;
            }
            if (e.isLeftClick()) {
                this.playerMenuUtility.setWaitingForChatInput(true);
                this.playerMenuUtility.setChatInputPath(this.context.chatPrefix + "edit." + commandIndex);
                p.closeInventory();
                p.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aEnter the new command in chat."));
                p.sendMessage(ConfigManager.fromSection("\u00a77Current: \u00a7f" + (String)commands.get(commandIndex)));
            } else if (e.isRightClick()) {
                commands.remove(commandIndex);
                ConfigManager.setItemValue(this.itemId, this.context.configKey, commands);
                p.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cRemoved command."));
                this.open();
            }
        }
    }

    @Override
    public void setMenuItems() {
        List<String> commands;
        int i;
        ItemStack filler = this.makeItem(Material.BLACK_STAINED_GLASS_PANE, " ", new String[0]);
        for (i = 0; i < 9; ++i) {
            this.inventory.setItem(i, filler);
        }
        for (i = 45; i < 54; ++i) {
            this.inventory.setItem(i, filler);
        }
        this.addMenuControls();
        this.inventory.setItem(53, this.makeItem(Material.BARRIER, "\u00a7cBack to Settings", new String[0]));
        this.inventory.setItem(49, this.makeItem(Material.ANVIL, "\u00a7aAdd New Command", "\u00a77Click to add a command via chat."));
        this.inventory.setItem(4, this.makeItem(Material.BOOK, "\u00a7eCommand Info & Help", "\u00a77Mode: \u00a76" + this.context.description, "", "\u00a76Logic Prefixes:", "\u00a7f\u2022 \u00a7e[console] \u00a7f-> \u00a77Run as Console", "\u00a7f\u2022 \u00a7e[chance:%] \u00a7f-> \u00a77Success Chance", "\u00a7f\u2022 \u00a7e[delay:ticks] \u00a7f-> \u00a77Wait before run", "\u00a7f\u2022 \u00a7c[else] \u00a7f-> \u00a77Run if prev [chance] failed", "", "\u00a76Actions:", "\u00a7f\u2022 \u00a7e[message] \u00a7f-> \u00a77Send Chat Msg", "\u00a7f\u2022 \u00a7e[title] \u00a7f-> \u00a77Show Title", "\u00a7f\u2022 \u00a7e[actionbar] \u00a7f-> \u00a77Show Actionbar", "\u00a7f\u2022 \u00a7e[sound] \u00a7f-> \u00a77Play Sound", "", "\u00a76Variables & PAPI:", "\u00a7f\u2022 \u00a7eInternals: \u00a77%player%, %player_x%...", "\u00a7f\u2022 \u00a7ePAPI Supported!", "", "\u00a76Chaining:", "\u00a77Use '\u00a7e;;\u00a77' to run multiple commands.", "", "\u00a7eFull Guide: \u00a76/buffeditems wiki"));
        BuffedItem item = this.plugin.getItemManager().getBuffedItem(this.itemId);
        if (item == null) {
            return;
        }
        List<String> list = commands = this.context == CommandContext.ACTIVE ? item.getActiveCommands() : item.getDepletionCommands();
        if (!commands.isEmpty()) {
            int index;
            for (int i2 = 0; i2 < this.maxItemsPerPage && (index = this.maxItemsPerPage * this.page + i2) < commands.size(); ++i2) {
                String title;
                Material icon;
                String rawCmd = commands.get(index);
                String lowerCmd = rawCmd.toLowerCase().trim();
                boolean isElse = lowerCmd.startsWith("[else]");
                boolean isChain = rawCmd.contains(";;");
                int commandNumber = index + 1;
                if (isElse) {
                    int connectedTo = Math.max(1, commandNumber - 1);
                    icon = Material.CHAIN_COMMAND_BLOCK;
                    title = "\u00a7c\u26a1 Else Block of #" + connectedTo;
                } else if (isChain) {
                    icon = Material.REPEATING_COMMAND_BLOCK;
                    title = "\u00a7e\u25b6 Command #" + commandNumber + " \u00a77(Chain)";
                } else {
                    icon = Material.COMMAND_BLOCK;
                    title = "\u00a7a\u25b6 Command #" + commandNumber;
                }
                List<String> formattedLore = this.formatCommandForDisplay(rawCmd);
                formattedLore.add("");
                formattedLore.add("\u00a7eLeft-Click to Edit");
                formattedLore.add("\u00a7cRight-Click to Remove");
                this.inventory.setItem(9 + i2, this.makeItem(icon, title, formattedLore.toArray(new String[0])));
            }
        }
    }

    private List<String> formatCommandForDisplay(String rawCmd) {
        ArrayList<String> lore = new ArrayList<String>();
        String[] steps = rawCmd.split(";;");
        for (int i = 0; i < steps.length; ++i) {
            String step = steps[i].trim();
            String stepLabel = steps.length > 1 ? "\u00a77Step " + (i + 1) + ": " : "";
            Object displayPrefixes = "";
            String cleanCmd = step;
            boolean parsing = true;
            while (parsing) {
                parsing = false;
                String lower = cleanCmd.toLowerCase();
                if (lower.startsWith("[else]")) {
                    displayPrefixes = (String)displayPrefixes + "\u00a7e(Else) ";
                    cleanCmd = cleanCmd.substring(6).trim();
                    parsing = true;
                } else if (lower.startsWith("[delay:")) {
                    close = cleanCmd.indexOf("]");
                    if (close != -1) {
                        val = cleanCmd.substring(7, close);
                        try {
                            double sec = (double)Long.parseLong(val) / 20.0;
                            displayPrefixes = (String)displayPrefixes + "\u00a7d\u23f3" + val + "t ";
                        }
                        catch (Exception e) {
                            displayPrefixes = (String)displayPrefixes + "\u00a7d\u23f3" + val + " ";
                        }
                        cleanCmd = cleanCmd.substring(close + 1).trim();
                        parsing = true;
                    }
                } else if (lower.startsWith("[chance:")) {
                    close = cleanCmd.indexOf("]");
                    if (close != -1) {
                        val = cleanCmd.substring(8, close);
                        displayPrefixes = (String)displayPrefixes + "\u00a7b\ud83c\udfb2" + val + "% ";
                        cleanCmd = cleanCmd.substring(close + 1).trim();
                        parsing = true;
                    }
                } else if (lower.startsWith("[console]")) {
                    displayPrefixes = (String)displayPrefixes + "\u00a7c(Console) ";
                    cleanCmd = cleanCmd.substring(9).trim();
                    parsing = true;
                }
                if (lower.startsWith("[message]") || lower.startsWith("[msg]")) {
                    displayPrefixes = (String)displayPrefixes + "\u00a76(Chat) ";
                    cleanCmd = cleanCmd.substring(cleanCmd.indexOf("]") + 1).trim();
                    parsing = false;
                    continue;
                }
                if (lower.startsWith("[actionbar]") || lower.startsWith("[ab]")) {
                    displayPrefixes = (String)displayPrefixes + "\u00a7b(Action Bar) ";
                    cleanCmd = cleanCmd.substring(cleanCmd.indexOf("]") + 1).trim();
                    parsing = false;
                    continue;
                }
                if (!lower.startsWith("[title]")) continue;
                displayPrefixes = (String)displayPrefixes + "\u00a7d(Title) ";
                cleanCmd = cleanCmd.substring(7).trim();
                parsing = false;
            }
            lore.add(stepLabel + (String)displayPrefixes);
            Object displayCmd = cleanCmd;
            if (((String)displayCmd).length() > 40) {
                displayCmd = ((String)displayCmd).substring(0, 37) + "...";
            }
            lore.add(" \u00a77\u27a5 \u00a7f" + (String)displayCmd);
            if (i >= steps.length - 1) continue;
            lore.add("\u00a78\u00a7m  \u2b07  ");
        }
        return lore;
    }

    public static enum CommandContext {
        ACTIVE("Active Commands", "active.commands.", "commands", "When Right-Clicked"),
        DEPLETION("Depletion Commands", "usage-limit.commands.", "usage-limit.commands", "When Item Depletes");

        private final String title;
        private final String chatPrefix;
        private final String configKey;
        private final String description;

        private CommandContext(String title, String chatPrefix, String configKey, String description) {
            this.title = title;
            this.chatPrefix = chatPrefix;
            this.configKey = configKey;
            this.description = description;
        }
    }
}

