/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.BuffedItems.menu.active;

import io.github.altkat.BuffedItems.BuffedItems;
import io.github.altkat.BuffedItems.manager.config.ConfigManager;
import io.github.altkat.BuffedItems.menu.active.ActiveItemSettingsMenu;
import io.github.altkat.BuffedItems.menu.base.Menu;
import io.github.altkat.BuffedItems.menu.selector.BossBarColorMenu;
import io.github.altkat.BuffedItems.menu.selector.BossBarStyleMenu;
import io.github.altkat.BuffedItems.menu.utility.ItemListMenu;
import io.github.altkat.BuffedItems.menu.utility.PlayerMenuUtility;
import io.github.altkat.BuffedItems.utility.item.BuffedItem;
import java.util.ArrayList;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ActiveItemVisualsMenu
extends Menu {
    private final BuffedItems plugin;
    private final String itemId;

    public ActiveItemVisualsMenu(PlayerMenuUtility playerMenuUtility, BuffedItems plugin) {
        super(playerMenuUtility);
        this.plugin = plugin;
        this.itemId = playerMenuUtility.getItemToEditId();
    }

    @Override
    public String getMenuName() {
        return "Visual Settings: " + this.itemId;
    }

    @Override
    public int getSlots() {
        return 54;
    }

    @Override
    public void handleMenu(InventoryClickEvent e) {
        Player p = (Player)e.getWhoClicked();
        if (e.getCurrentItem() == null) {
            return;
        }
        Material type = e.getCurrentItem().getType();
        BuffedItem item = this.plugin.getItemManager().getBuffedItem(this.itemId);
        if (item == null) {
            new ItemListMenu(this.playerMenuUtility, this.plugin).open();
            return;
        }
        if (type == Material.BARRIER && e.getSlot() == 53) {
            new ActiveItemSettingsMenu(this.playerMenuUtility, this.plugin).open();
            return;
        }
        switch (type) {
            case PAPER: {
                ConfigManager.setItemValue(this.itemId, "visuals.chat", !item.isVisualChat());
                this.open();
                break;
            }
            case NAME_TAG: {
                ConfigManager.setItemValue(this.itemId, "visuals.title", !item.isVisualTitle());
                this.open();
                break;
            }
            case IRON_BARS: {
                ConfigManager.setItemValue(this.itemId, "visuals.action-bar", !item.isVisualActionBar());
                this.open();
                break;
            }
            case WITHER_SKELETON_SKULL: {
                ConfigManager.setItemValue(this.itemId, "visuals.boss-bar", !item.isVisualBossBar());
                this.open();
                break;
            }
            case GLOW_INK_SAC: {
                new BossBarColorMenu(this.playerMenuUtility, this.plugin).open();
                break;
            }
            case PAINTING: {
                new BossBarStyleMenu(this.playerMenuUtility, this.plugin).open();
                break;
            }
            case WRITABLE_BOOK: {
                int slot = e.getSlot();
                String path = "";
                String title = "";
                if (slot == 19) {
                    path = "active.msg.chat";
                    title = "Chat Message";
                } else if (slot == 21) {
                    path = "active.msg.title";
                    title = "Title Message (Split with '|' for subtitle)";
                } else if (slot == 23) {
                    path = "active.msg.actionbar";
                    title = "Action Bar Message";
                } else if (slot == 25) {
                    path = "active.msg.bossbar";
                    title = "Boss Bar Message";
                }
                if (path.isEmpty()) break;
                if (e.isRightClick()) {
                    String configPath = null;
                    String subtitlePath = null;
                    switch (path) {
                        case "active.msg.chat": {
                            configPath = "visuals.messages.cooldown-chat";
                            break;
                        }
                        case "active.msg.title": {
                            configPath = "visuals.messages.cooldown-title";
                            subtitlePath = "visuals.messages.cooldown-subtitle";
                            break;
                        }
                        case "active.msg.actionbar": {
                            configPath = "visuals.messages.cooldown-action-bar";
                            break;
                        }
                        case "active.msg.bossbar": {
                            configPath = "visuals.messages.cooldown-boss-bar";
                        }
                    }
                    if (subtitlePath != null) {
                        ConfigManager.setItemValue(this.itemId, subtitlePath, null);
                    }
                    ConfigManager.setItemValue(this.itemId, configPath, null);
                    p.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aReset to default config message."));
                    this.open();
                    break;
                }
                this.playerMenuUtility.setWaitingForChatInput(true);
                this.playerMenuUtility.setChatInputPath(path);
                p.closeInventory();
                p.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aEnter new " + title + " in chat."));
                p.sendMessage(ConfigManager.fromSection("\u00a77Use {time} for remaining seconds."));
                p.sendMessage(ConfigManager.fromSection("\u00a77Type 'default' to reset, 'cancel' to exit."));
            }
        }
    }

    @Override
    public void setMenuItems() {
        BuffedItem item = this.plugin.getItemManager().getBuffedItem(this.itemId);
        if (item == null) {
            return;
        }
        this.setFillerGlass();
        this.inventory.setItem(10, this.createVisualToggle(Material.PAPER, "Chat Message", item.isVisualChat()));
        this.inventory.setItem(12, this.createVisualToggle(Material.NAME_TAG, "Title Alert", item.isVisualTitle()));
        this.inventory.setItem(14, this.createVisualToggle(Material.IRON_BARS, "Action Bar", item.isVisualActionBar()));
        this.inventory.setItem(16, this.createVisualToggle(Material.WITHER_SKELETON_SKULL, "Boss Bar", item.isVisualBossBar()));
        this.inventory.setItem(19, this.makeItem(Material.WRITABLE_BOOK, "\u00a7eEdit Chat Msg", this.formatMessageLore(item.getCustomChatMsg(), "active-items.messages.cooldown-chat")));
        this.inventory.setItem(21, this.makeItem(Material.WRITABLE_BOOK, "\u00a7eEdit Title Msg", this.formatTitleLore(item.getCustomTitleMsg(), item.getCustomSubtitleMsg())));
        this.inventory.setItem(23, this.makeItem(Material.WRITABLE_BOOK, "\u00a7eEdit Action Bar", this.formatMessageLore(item.getCustomActionBarMsg(), "active-items.messages.cooldown-action-bar")));
        this.inventory.setItem(25, this.makeItem(Material.WRITABLE_BOOK, "\u00a7eEdit Boss Bar", this.formatMessageLore(item.getCustomBossBarMsg(), "active-items.messages.cooldown-boss-bar")));
        this.inventory.setItem(34, this.makeItem(Material.PAINTING, "\u00a7dBossBar Style", "\u00a77Current: \u00a7e" + item.getBossBarStyle(), "\u00a7eClick to Change"));
        this.inventory.setItem(43, this.makeItem(Material.GLOW_INK_SAC, "\u00a7dBossBar Color", "\u00a77Current: \u00a7e" + item.getBossBarColor(), "\u00a7eClick to Change"));
        this.inventory.setItem(53, this.makeItem(Material.BARRIER, "\u00a7cBack", new String[0]));
    }

    private ItemStack createVisualToggle(Material mat, String name, boolean state) {
        String status = state ? "\u00a7aEnabled" : "\u00a7cDisabled";
        ItemStack item = this.makeItem(mat, "\u00a76Visual: " + name, "\u00a77Status: " + status, "", "\u00a7eClick to Toggle");
        if (state) {
            ItemMeta meta = item.getItemMeta();
            meta.addEnchant(Enchantment.LUCK_OF_THE_SEA, 1, true);
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            item.setItemMeta(meta);
        }
        return item;
    }

    private String[] formatMessageLore(String msg, String configPath) {
        ArrayList<Object> lore = new ArrayList<Object>();
        lore.add("\u00a77Current:");
        if (msg == null) {
            String defMsg = this.plugin.getConfig().getString(configPath, "\u00a7cMissing Config");
            String formatted = ConfigManager.toSection(ConfigManager.fromLegacy(defMsg));
            lore.add("\u00a7r" + formatted);
            lore.add("\u00a78(Default Value)");
        } else {
            String formatted = ConfigManager.toSection(ConfigManager.fromLegacy(msg));
            lore.add("\u00a7r" + formatted);
        }
        lore.add("");
        lore.add("\u00a7eLeft-Click to Edit");
        lore.add("\u00a7cRight-Click to Reset");
        return lore.toArray(new String[0]);
    }

    private String[] formatTitleLore(String title, String subtitle) {
        ArrayList<Object> lore = new ArrayList<Object>();
        lore.add("\u00a77Includes Subtitle (Split with '|')");
        lore.add("");
        lore.add("\u00a77Title:");
        if (title == null) {
            String defTitle = this.plugin.getConfig().getString("active-items.messages.cooldown-title", "");
            lore.add("\u00a7r" + ConfigManager.toSection(ConfigManager.fromLegacy(defTitle)));
            lore.add("\u00a78(Default Value)");
        } else {
            lore.add("\u00a7r" + ConfigManager.toSection(ConfigManager.fromLegacy(title)));
        }
        lore.add("");
        lore.add("\u00a77Subtitle:");
        if (subtitle == null) {
            String defSub = this.plugin.getConfig().getString("active-items.messages.cooldown-subtitle", "");
            lore.add("\u00a7r" + ConfigManager.toSection(ConfigManager.fromLegacy(defSub)));
            lore.add("\u00a78(Default Value)");
        } else {
            lore.add("\u00a7r" + ConfigManager.toSection(ConfigManager.fromLegacy(subtitle)));
        }
        lore.add("");
        lore.add("\u00a7eLeft-Click to Edit");
        lore.add("\u00a7cRight-Click to Reset");
        return lore.toArray(new String[0]);
    }
}

