/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.BuffedItems.manager.crafting;

import io.github.altkat.BuffedItems.manager.crafting.RecipeIngredient;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CustomRecipe {
    private final String id;
    private final String resultItemId;
    private final int amount;
    private final List<String> shape;
    private final String permission;
    private final Map<Integer, RecipeIngredient> ingredients;
    private boolean valid;
    private final List<String> errorMessages;

    public CustomRecipe(String id, String resultItemId, int amount, List<String> shape, String permission) {
        this.id = id;
        this.resultItemId = resultItemId;
        this.amount = amount;
        this.shape = shape;
        this.permission = permission;
        this.ingredients = new HashMap<Integer, RecipeIngredient>();
        this.valid = true;
        this.errorMessages = new ArrayList<String>();
    }

    public void addIngredient(int slot, RecipeIngredient ingredient) {
        this.ingredients.put(slot, ingredient);
    }

    public RecipeIngredient getIngredient(int slot) {
        return this.ingredients.get(slot);
    }

    public Map<Integer, RecipeIngredient> getIngredients() {
        return this.ingredients;
    }

    public String getId() {
        return this.id;
    }

    public String getResultItemId() {
        return this.resultItemId;
    }

    public int getAmount() {
        return this.amount;
    }

    public List<String> getShape() {
        return this.shape;
    }

    public String getPermission() {
        return this.permission;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public List<String> getErrorMessages() {
        return this.errorMessages;
    }

    public void addErrorMessage(String message) {
        this.errorMessages.add(message);
        this.valid = false;
    }
}

