/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.BuffedItems.manager.cost.types;

import io.github.altkat.BuffedItems.hooks.VaultHook;
import io.github.altkat.BuffedItems.manager.config.ConfigManager;
import io.github.altkat.BuffedItems.manager.cost.ICost;
import java.util.Map;
import org.bukkit.entity.Player;

public class MoneyCost
implements ICost {
    private final double amount;
    private final String failureMessage;
    private final VaultHook vault;

    public MoneyCost(Map<String, Object> data, VaultHook vault) {
        this.vault = vault;
        if (vault == null || !vault.isHooked()) {
            throw new IllegalStateException("Vault economy is not hooked/loaded.");
        }
        this.amount = ((Number)data.getOrDefault("amount", 0)).doubleValue();
        if (this.amount <= 0.0) {
            throw new IllegalArgumentException("Amount must be positive.");
        }
        String defaultMsg = ConfigManager.getDefaultCostMessage("MONEY");
        this.failureMessage = (String)data.getOrDefault("message", defaultMsg);
    }

    @Override
    public String getDisplayString() {
        return "$" + this.amount;
    }

    @Override
    public boolean hasEnough(Player player) {
        return this.vault.has(player, this.amount);
    }

    @Override
    public void deduct(Player player) {
        this.vault.withdraw(player, this.amount);
    }

    @Override
    public String getFailureMessage() {
        return ConfigManager.stripLegacy(this.failureMessage).replace("{amount}", String.valueOf(this.amount));
    }
}

