/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.BuffedItems.manager.cost.types;

import io.github.altkat.BuffedItems.hooks.CoinsEngineHook;
import io.github.altkat.BuffedItems.manager.config.ConfigManager;
import io.github.altkat.BuffedItems.manager.cost.ICost;
import java.util.Map;
import org.bukkit.entity.Player;
import su.nightexpress.coinsengine.api.currency.Currency;

public class CoinsEngineCost
implements ICost {
    private final double amount;
    private final String currencyId;
    private final String failureMessage;
    private final CoinsEngineHook hook;

    public CoinsEngineCost(Map<String, Object> data, CoinsEngineHook hook) {
        this.hook = hook;
        this.currencyId = (String)data.getOrDefault("currency_id", "coins");
        Currency currency = hook.getCurrency(this.currencyId);
        if (currency == null) {
            throw new IllegalArgumentException("Invalid CoinsEngine Currency ID: '" + this.currencyId + "'");
        }
        this.amount = ((Number)data.getOrDefault("amount", 0)).doubleValue();
        if (this.amount <= 0.0) {
            throw new IllegalArgumentException("Amount must be positive.");
        }
        String defaultMsg = ConfigManager.getDefaultCostMessage("COINSENGINE");
        this.failureMessage = (String)data.getOrDefault("message", defaultMsg);
    }

    @Override
    public String getDisplayString() {
        return this.amount + " " + this.currencyId;
    }

    @Override
    public boolean hasEnough(Player player) {
        Currency currency = this.hook.getCurrency(this.currencyId);
        if (currency == null) {
            return false;
        }
        return this.hook.getBalance(player, currency) >= this.amount;
    }

    @Override
    public void deduct(Player player) {
        Currency currency = this.hook.getCurrency(this.currencyId);
        if (currency != null) {
            this.hook.removeBalance(player, currency, this.amount);
        }
    }

    @Override
    public String getFailureMessage() {
        Currency currency = this.hook.getCurrency(this.currencyId);
        String currencyName = currency != null ? currency.getName() : this.currencyId;
        return ConfigManager.stripLegacy(this.failureMessage).replace("{amount}", String.valueOf(this.amount)).replace("{currency_name}", currencyName);
    }
}

