/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.BuffedItems.manager.cost;

import io.github.altkat.BuffedItems.BuffedItems;
import io.github.altkat.BuffedItems.manager.config.ConfigManager;
import io.github.altkat.BuffedItems.manager.cost.CostFactory;
import io.github.altkat.BuffedItems.manager.cost.ICost;
import io.github.altkat.BuffedItems.manager.cost.types.BuffedItemCost;
import io.github.altkat.BuffedItems.manager.cost.types.CoinsEngineCost;
import io.github.altkat.BuffedItems.manager.cost.types.ExperienceCost;
import io.github.altkat.BuffedItems.manager.cost.types.HealthCost;
import io.github.altkat.BuffedItems.manager.cost.types.HungerCost;
import io.github.altkat.BuffedItems.manager.cost.types.ItemCost;
import io.github.altkat.BuffedItems.manager.cost.types.LevelCost;
import io.github.altkat.BuffedItems.manager.cost.types.MoneyCost;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CostManager {
    private final BuffedItems plugin;
    private final Map<String, CostFactory> factories = new HashMap<String, CostFactory>();

    public CostManager(BuffedItems plugin) {
        this.plugin = plugin;
        this.registerDefaults();
    }

    public void registerFactory(String type, CostFactory factory) {
        this.factories.put(type.toUpperCase(), factory);
        ConfigManager.sendDebugMessage(1, () -> "[CostManager] Registered cost type: " + type.toUpperCase());
    }

    private void registerDefaults() {
        this.registerFactory("EXPERIENCE", ExperienceCost::new);
        this.registerFactory("LEVEL", LevelCost::new);
        this.registerFactory("HUNGER", HungerCost::new);
        this.registerFactory("HEALTH", HealthCost::new);
        this.registerFactory("ITEM", ItemCost::new);
        this.registerFactory("BUFFED_ITEM", data -> new BuffedItemCost(data, this.plugin));
        if (this.plugin.getHookManager().isCoinsEngineLoaded()) {
            this.registerFactory("COINSENGINE", data -> new CoinsEngineCost(data, this.plugin.getHookManager().getCoinsEngineHook()));
        }
        if (this.plugin.getHookManager().isVaultLoaded()) {
            this.registerFactory("MONEY", data -> new MoneyCost(data, this.plugin.getHookManager().getVaultHook()));
        }
    }

    public ICost parseCost(Map<?, ?> rawMap) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        for (Map.Entry<?, ?> entry : rawMap.entrySet()) {
            data.put(entry.getKey().toString(), entry.getValue());
        }
        String type = (String)data.get("type");
        if (type == null) {
            return null;
        }
        CostFactory factory = this.factories.get(type.toUpperCase());
        if (factory != null) {
            return factory.create(data);
        }
        ConfigManager.sendDebugMessage(1, () -> "[CostManager] Unknown cost type: " + type);
        return null;
    }

    public List<ICost> parseCosts(List<Map<?, ?>> configList) {
        ArrayList<ICost> costs = new ArrayList<ICost>();
        if (configList == null) {
            return costs;
        }
        for (Map<?, ?> rawMap : configList) {
            ICost cost = this.parseCost(rawMap);
            if (cost == null) continue;
            costs.add(cost);
        }
        return costs;
    }
}

