/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.BuffedItems.manager.cooldown;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.Player;

public class CooldownManager {
    private final Map<UUID, Map<String, Long>> cooldowns = new HashMap<UUID, Map<String, Long>>();

    public boolean isOnCooldown(Player player, String itemId) {
        if (!this.cooldowns.containsKey(player.getUniqueId())) {
            return false;
        }
        Map<String, Long> playerCooldowns = this.cooldowns.get(player.getUniqueId());
        if (!playerCooldowns.containsKey(itemId)) {
            return false;
        }
        return playerCooldowns.get(itemId) > System.currentTimeMillis();
    }

    public void setCooldown(Player player, String itemId, int seconds) {
        long expiry = System.currentTimeMillis() + (long)seconds * 1000L;
        this.cooldowns.computeIfAbsent(player.getUniqueId(), k -> new HashMap()).put(itemId, expiry);
    }

    public double getRemainingSeconds(Player player, String itemId) {
        if (!this.isOnCooldown(player, itemId)) {
            return 0.0;
        }
        long expiry = this.cooldowns.get(player.getUniqueId()).get(itemId);
        return (double)(expiry - System.currentTimeMillis()) / 1000.0;
    }

    public void clearPlayer(Player player) {
        this.cooldowns.remove(player.getUniqueId());
    }
}

