/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.BuffedItems.listener.handler;

import io.github.altkat.BuffedItems.BuffedItems;
import io.github.altkat.BuffedItems.listener.handler.ChatInputHandler;
import io.github.altkat.BuffedItems.manager.config.ConfigManager;
import io.github.altkat.BuffedItems.manager.config.UpgradesConfig;
import io.github.altkat.BuffedItems.menu.upgrade.IngredientListMenu;
import io.github.altkat.BuffedItems.menu.upgrade.UpgradeRecipeEditorMenu;
import io.github.altkat.BuffedItems.menu.utility.PlayerMenuUtility;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.entity.Player;

public class IngredientInputHandler
implements ChatInputHandler {
    private final BuffedItems plugin;

    public IngredientInputHandler(BuffedItems plugin) {
        this.plugin = plugin;
    }

    @Override
    public void handle(Player player, PlayerMenuUtility pmu, String input, String path, String recipeId) {
        if (path.equals("upgrade.ingredients.add.ITEM_QUANTITY")) {
            this.handleItemQuantityInput(player, pmu, input, recipeId);
            return;
        }
        if (path.equals("upgrade.ingredients.add.BUFFED_ITEM_QUANTITY")) {
            this.handleBuffedItemQuantityInput(player, pmu, input, recipeId);
            return;
        }
        if (path.startsWith("upgrade.ingredients.add.")) {
            String type = path.substring(24);
            this.handleAddIngredient(player, pmu, input, type, recipeId);
        } else if (path.equals("upgrade.base.set_id")) {
            this.handleSetBaseId(player, pmu, input, recipeId);
        } else if (path.equals("upgrade.ingredients.edit.amount")) {
            this.handleEditIngredientAmount(player, pmu, input, recipeId);
        }
    }

    private void handleSetBaseId(Player player, PlayerMenuUtility pmu, String input, String recipeId) {
        String itemId = input.trim();
        if (this.plugin.getItemManager().getBuffedItem(itemId) == null) {
            player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7eWarning: Item ID '" + itemId + "' not found in loaded items."));
        }
        ConfigManager.setUpgradeValue(recipeId, "base", itemId);
        player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aBase item updated to: \u00a7e" + itemId));
        this.closeChat(pmu);
        new UpgradeRecipeEditorMenu(pmu, this.plugin).open();
    }

    private void handleAddIngredient(Player player, PlayerMenuUtility pmu, String input, String type, String recipeId) {
        Map<String, Object> data = this.parseCostInput(player, input, type);
        if (data == null) {
            pmu.setWaitingForChatInput(true);
            pmu.setChatInputPath("upgrade.ingredients.add." + type);
            return;
        }
        List currentList = UpgradesConfig.get().getMapList("upgrades." + recipeId + ".ingredients");
        ArrayList<Map<String, Object>> newList = new ArrayList<Map<String, Object>>();
        for (Map map : currentList) {
            newList.add(map);
        }
        newList.add(data);
        ConfigManager.setUpgradeValue(recipeId, "ingredients", newList);
        player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aIngredient added successfully!"));
        this.closeChat(pmu);
        new IngredientListMenu(pmu, this.plugin).open();
    }

    private void handleEditIngredientAmount(Player player, PlayerMenuUtility pmu, String input, String recipeId) {
        int index = pmu.getEditIndex();
        List currentList = UpgradesConfig.get().getMapList("upgrades." + recipeId + ".ingredients");
        if (index < 0 || index >= currentList.size()) {
            this.closeChat(pmu);
            new IngredientListMenu(pmu, this.plugin).open();
            return;
        }
        ArrayList<Map> editableList = new ArrayList<Map>();
        for (Map map : currentList) {
            editableList.add(map);
        }
        Map target = (Map)editableList.get(index);
        LinkedHashMap<String, Object> orderedMap = new LinkedHashMap<String, Object>();
        String type = (String)target.get("type");
        orderedMap.put("type", type);
        for (Map.Entry entry : target.entrySet()) {
            String key = (String)entry.getKey();
            if (key.equals("type") || key.equals("amount")) continue;
            orderedMap.put(key, entry.getValue());
        }
        try {
            if (this.isIntegerType(type)) {
                int val = Integer.parseInt(input);
                if (val <= 0) {
                    throw new NumberFormatException();
                }
                orderedMap.put("amount", val);
            } else {
                double val = Double.parseDouble(input);
                if (val <= 0.0) {
                    throw new NumberFormatException();
                }
                orderedMap.put("amount", val % 1.0 == 0.0 ? (double)((int)val) : val);
            }
            editableList.set(index, orderedMap);
            ConfigManager.setUpgradeValue(recipeId, "ingredients", editableList);
            player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aAmount updated!"));
            this.closeChat(pmu);
            new IngredientListMenu(pmu, this.plugin).open();
        }
        catch (NumberFormatException e) {
            player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cInvalid amount. Enter a positive number."));
            player.sendMessage(ConfigManager.fromSection("\u00a77(Type 'cancel' to exit)"));
            pmu.setWaitingForChatInput(true);
            pmu.setChatInputPath("upgrade.ingredients.edit.amount");
        }
    }

    private Map<String, Object> parseCostInput(Player player, String input, String type) {
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
        data.put("type", type);
        try {
            if (type.equals("ITEM")) {
                String[] parts = input.split(";");
                if (parts.length != 2) {
                    throw new IllegalArgumentException();
                }
                int amount = Integer.parseInt(parts[0]);
                String material = parts[1].toUpperCase();
                if (Material.matchMaterial((String)material) == null) {
                    player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cInvalid material: " + material));
                    player.sendMessage(ConfigManager.fromSection("\u00a77(Type 'cancel' to exit)"));
                    return null;
                }
                data.put("material", material);
                data.put("amount", amount);
            } else if (type.equals("BUFFED_ITEM")) {
                String[] parts = input.split(";");
                if (parts.length != 2) {
                    throw new IllegalArgumentException();
                }
                int amount = Integer.parseInt(parts[0]);
                String itemId = parts[1];
                if (this.plugin.getItemManager().getBuffedItem(itemId) == null) {
                    player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7eWarning: Item ID '" + itemId + "' not found (yet)."));
                }
                data.put("item_id", itemId);
                data.put("amount", amount);
            } else if (type.equals("COINSENGINE")) {
                if (input.contains(";")) {
                    String[] parts = input.split(";");
                    data.put("currency_id", parts[1]);
                    data.put("amount", Double.parseDouble(parts[0]));
                } else {
                    data.put("currency_id", "coins");
                    data.put("amount", Double.parseDouble(input));
                }
            } else if (this.isIntegerType(type)) {
                data.put("amount", Integer.parseInt(input));
            } else {
                double val = Double.parseDouble(input);
                data.put("amount", val % 1.0 == 0.0 ? (double)((int)val) : val);
            }
            return data;
        }
        catch (Exception e) {
            player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cInvalid format."));
            if (type.equals("ITEM")) {
                player.sendMessage(ConfigManager.fromSection("\u00a77Format: AMOUNT;MATERIAL (e.g., 5;DIAMOND)"));
            } else if (type.equals("BUFFED_ITEM")) {
                player.sendMessage(ConfigManager.fromSection("\u00a77Format: AMOUNT;ITEM_ID"));
            } else {
                player.sendMessage(ConfigManager.fromSection("\u00a77Enter a valid number."));
            }
            player.sendMessage(ConfigManager.fromSection("\u00a77(Type 'cancel' to exit)"));
            return null;
        }
    }

    private void handleBuffedItemQuantityInput(Player player, PlayerMenuUtility pmu, String input, String recipeId) {
        try {
            int amount = Integer.parseInt(input);
            if (amount <= 0) {
                throw new NumberFormatException();
            }
            String itemId = pmu.getTempId();
            String simulatedInput = amount + ";" + itemId;
            this.handleAddIngredient(player, pmu, simulatedInput, "BUFFED_ITEM", recipeId);
        }
        catch (NumberFormatException e) {
            player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cInvalid amount. Please enter a valid number."));
            player.sendMessage(ConfigManager.fromSection("\u00a77(Type 'cancel' to exit)"));
            pmu.setWaitingForChatInput(true);
            pmu.setChatInputPath("upgrade.ingredients.add.BUFFED_ITEM_QUANTITY");
        }
    }

    private void handleItemQuantityInput(Player player, PlayerMenuUtility pmu, String input, String recipeId) {
        try {
            int amount = Integer.parseInt(input);
            if (amount <= 0) {
                throw new NumberFormatException();
            }
            Material selectedMat = pmu.getTempMaterial();
            if (selectedMat == null) {
                player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cError: Session lost. Please select material again."));
                this.closeChat(pmu);
                return;
            }
            String simulatedInput = amount + ";" + selectedMat.name();
            this.handleAddIngredient(player, pmu, simulatedInput, "ITEM", recipeId);
        }
        catch (NumberFormatException e) {
            player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cInvalid amount. Please enter a valid number."));
            pmu.setWaitingForChatInput(true);
            pmu.setChatInputPath("upgrade.ingredients.add.ITEM_QUANTITY");
        }
    }

    private boolean isIntegerType(String type) {
        return type.equals("EXPERIENCE") || type.equals("LEVEL") || type.equals("HUNGER") || type.equals("ITEM") || type.equals("BUFFED_ITEM");
    }

    private void closeChat(PlayerMenuUtility pmu) {
        pmu.setWaitingForChatInput(false);
        pmu.setChatInputPath(null);
    }
}

