/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.BuffedItems.listener;

import io.github.altkat.BuffedItems.BuffedItems;
import io.github.altkat.BuffedItems.manager.config.ConfigManager;
import io.github.altkat.BuffedItems.manager.config.RecipesConfig;
import java.util.ArrayList;
import java.util.Collection;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class PlayerJoinListener
implements Listener {
    private final BuffedItems plugin;
    private static final int MAX_MANAGED_DURATION = 600;

    public PlayerJoinListener(BuffedItems plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        ConfigManager.sendDebugMessage(2, () -> "[Join] Cleaning up any potentially stale tracked/orphaned attributes for " + player.getName());
        this.plugin.getEffectManager().clearAllAttributes(player);
        try {
            Collection activeEffects = player.getActivePotionEffects();
            if (!activeEffects.isEmpty()) {
                ArrayList<PotionEffectType> staleEffectsToClear = new ArrayList<PotionEffectType>();
                for (PotionEffect effect : activeEffects) {
                    if (effect.getDuration() > 600) continue;
                    staleEffectsToClear.add(effect.getType());
                }
                if (!staleEffectsToClear.isEmpty()) {
                    ConfigManager.sendDebugMessage(2, () -> "[Join] Found " + staleEffectsToClear.size() + " stale managed potion effect(s) for " + player.getName() + ". Clearing them...");
                    staleEffectsToClear.forEach(arg_0 -> ((Player)player).removePotionEffect(arg_0));
                }
            }
        }
        catch (Exception e) {
            ConfigManager.sendDebugMessage(1, () -> "[Join] Error while clearing stale potion effects for " + player.getName() + ": " + e.getMessage());
        }
        this.updateArmorSlots(player);
        if (RecipesConfig.get().getBoolean("settings.register-to-book", true)) {
            for (String recipeId : this.plugin.getCraftingManager().getRecipes().keySet()) {
                NamespacedKey key = new NamespacedKey((Plugin)this.plugin, recipeId);
                try {
                    player.discoverRecipe(key);
                }
                catch (Exception exception) {}
            }
        }
        ConfigManager.sendDebugMessage(2, () -> "[Join] Attribute cleanup check finished for " + player.getName());
        this.plugin.getEffectApplicatorTask().markPlayerForUpdate(player.getUniqueId());
    }

    private void updateArmorSlots(Player player) {
        ItemStack[] armorContents = player.getInventory().getArmorContents();
        boolean changed = false;
        for (int i = 0; i < armorContents.length; ++i) {
            ItemStack updated;
            ItemStack item = armorContents[i];
            if (item == null || item.getType().isAir() || (updated = this.plugin.getItemUpdater().updateItem(item, player)) == null || updated.isSimilar(item)) continue;
            armorContents[i] = updated;
            changed = true;
        }
        if (changed) {
            player.getInventory().setArmorContents(armorContents);
            ConfigManager.sendDebugMessage(3, () -> "[LiveUpdate] Updated armor for " + player.getName() + " on join.");
        }
    }
}

