/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.BuffedItems.listener;

import io.github.altkat.BuffedItems.BuffedItems;
import io.github.altkat.BuffedItems.manager.config.ConfigManager;
import io.github.altkat.BuffedItems.utility.item.BuffedItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.enchantment.EnchantItemEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.hanging.HangingPlaceEvent;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.event.inventory.PrepareSmithingEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.inventory.BlockInventoryHolder;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class ItemProtectionListener
implements Listener {
    private final BuffedItems plugin;
    private final NamespacedKey nbtKey;

    public ItemProtectionListener(BuffedItems plugin) {
        this.plugin = plugin;
        this.nbtKey = new NamespacedKey((Plugin)plugin, "buffeditem_id");
    }

    private boolean itemHasFlag(ItemStack item, String flagName) {
        if (item == null || !item.hasItemMeta()) {
            return false;
        }
        String itemId = (String)item.getItemMeta().getPersistentDataContainer().get(this.nbtKey, PersistentDataType.STRING);
        if (itemId == null) {
            return false;
        }
        BuffedItem buffedItem = this.plugin.getItemManager().getBuffedItem(itemId);
        if (buffedItem == null) {
            return false;
        }
        return buffedItem.getFlag(flagName);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerDeath(PlayerDeathEvent e) {
        Player player = e.getEntity();
        ConfigManager.sendDebugMessage(2, () -> "[DeathListener] Player " + player.getName() + " died. Cleaning up effects and cache.");
        this.plugin.getEffectManager().clearAllAttributes(player);
        this.plugin.getEffectApplicatorTask().playerQuit(player);
        this.plugin.getEffectApplicatorTask().getManagedEffects(player.getUniqueId()).forEach(arg_0 -> ((Player)player).removePotionEffect(arg_0));
        ArrayList<ItemStack> keptItems = new ArrayList<ItemStack>();
        Iterator iterator = e.getDrops().iterator();
        while (iterator.hasNext()) {
            ItemStack item = (ItemStack)iterator.next();
            if (this.itemHasFlag(item, "LOST_ON_DEATH")) {
                iterator.remove();
                this.sendProtectionMessage(player, "protection-lost-on-death");
                continue;
            }
            if (!this.itemHasFlag(item, "PREVENT_DEATH_DROP")) continue;
            iterator.remove();
            keptItems.add(item);
        }
        if (!keptItems.isEmpty()) {
            this.plugin.getDeathKeptItems().put(e.getEntity().getUniqueId(), keptItems);
        }
    }

    @EventHandler
    public void onPlayerRespawn(PlayerRespawnEvent e) {
        UUID playerUuid = e.getPlayer().getUniqueId();
        Map<UUID, List<ItemStack>> itemsMap = this.plugin.getDeathKeptItems();
        if (itemsMap.containsKey(playerUuid)) {
            List<ItemStack> keptItems = itemsMap.get(playerUuid);
            HashMap didNotFit = e.getPlayer().getInventory().addItem(keptItems.toArray(new ItemStack[0]));
            if (!didNotFit.isEmpty()) {
                for (ItemStack item : didNotFit.values()) {
                    e.getPlayer().getWorld().dropItemNaturally(e.getRespawnLocation(), item);
                }
            }
            itemsMap.remove(playerUuid);
        }
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            ConfigManager.sendDebugMessage(2, () -> "[RespawnListener] Player " + e.getPlayer().getName() + " respawned. Scheduling inventory update (1-tick delay).");
            this.plugin.getEffectApplicatorTask().markPlayerForUpdate(playerUuid);
        }, 1L);
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onPlayerUse(PlayerInteractEvent e) {
        ItemStack item = e.getItem();
        if (item == null) {
            return;
        }
        Action action = e.getAction();
        if (action != Action.RIGHT_CLICK_AIR && action != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (this.itemHasFlag(item, "PREVENT_INTERACT")) {
            if (item.getType().isEdible()) {
                return;
            }
            if (item.getType().isBlock()) {
                return;
            }
            e.setCancelled(true);
            this.sendProtectionMessage(e.getPlayer(), "protection-prevent-interact");
        }
    }

    @EventHandler
    public void onEntityPlace(PlayerInteractEvent e) {
        if (e.getAction() != Action.RIGHT_CLICK_BLOCK || e.getItem() == null) {
            return;
        }
        Material itemType = e.getItem().getType();
        if ((itemType == Material.ARMOR_STAND || itemType.name().endsWith("_BOAT") || itemType.name().endsWith("_MINECART")) && this.itemHasFlag(e.getItem(), "PREVENT_PLACEMENT")) {
            e.setCancelled(true);
            this.sendProtectionMessage(e.getPlayer(), "protection-prevent-placement-entity");
        }
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent e) {
        if (this.itemHasFlag(e.getItemInHand(), "PREVENT_PLACEMENT")) {
            e.setCancelled(true);
            this.sendProtectionMessage(e.getPlayer(), "protection-prevent-placement-block");
        }
    }

    @EventHandler
    public void onHangingPlace(HangingPlaceEvent e) {
        if (this.itemHasFlag(e.getPlayer().getInventory().getItemInMainHand(), "PREVENT_PLACEMENT")) {
            e.setCancelled(true);
            this.sendProtectionMessage(e.getPlayer(), "protection-prevent-placement");
        }
    }

    @EventHandler
    public void onPrepareAnvil(PrepareAnvilEvent e) {
        boolean prevent;
        boolean bl = prevent = this.itemHasFlag(e.getInventory().getItem(0), "PREVENT_ANVIL_USE") || this.itemHasFlag(e.getInventory().getItem(1), "PREVENT_ANVIL_USE");
        if (prevent) {
            e.setResult(null);
            for (HumanEntity viewer : e.getViewers()) {
                if (!(viewer instanceof Player)) continue;
                this.sendProtectionMessage((Player)viewer, "protection-prevent-anvil-use");
                break;
            }
        }
    }

    @EventHandler
    public void onEnchantItem(EnchantItemEvent e) {
        if (this.itemHasFlag(e.getItem(), "PREVENT_ENCHANT_TABLE")) {
            e.setCancelled(true);
            this.sendProtectionMessage(e.getEnchanter(), "protection-prevent-enchant-table");
        }
    }

    @EventHandler
    public void onPrepareSmithing(PrepareSmithingEvent e) {
        boolean prevent;
        ItemStack base = e.getInventory().getItem(0);
        ItemStack addition = e.getInventory().getItem(1);
        ItemStack material = e.getInventory().getItem(2);
        HumanEntity viewer = e.getView().getPlayer();
        if (!(viewer instanceof Player)) {
            return;
        }
        Player player = (Player)viewer;
        boolean bl = prevent = this.itemHasFlag(base, "PREVENT_SMITHING_USE") || this.itemHasFlag(addition, "PREVENT_SMITHING_USE") || this.itemHasFlag(material, "PREVENT_SMITHING_USE");
        if (prevent) {
            e.setResult(null);
        }
    }

    @EventHandler
    public void onCraftItem(CraftItemEvent e) {
        for (ItemStack item : e.getInventory().getMatrix()) {
            if (!this.itemHasFlag(item, "PREVENT_CRAFTING_USE")) continue;
            e.setCancelled(true);
            if (e.getWhoClicked() instanceof Player) {
                this.sendProtectionMessage((Player)e.getWhoClicked(), "protection-prevent-crafting-use");
            }
            return;
        }
    }

    @EventHandler
    public void onItemDrop(PlayerDropItemEvent e) {
        if (this.itemHasFlag(e.getItemDrop().getItemStack(), "PREVENT_DROP")) {
            e.setCancelled(true);
            this.sendProtectionMessage(e.getPlayer(), "protection-prevent-drop");
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onInventoryClickPreventDrop(InventoryClickEvent e) {
        Inventory clickedInv = e.getClickedInventory();
        ItemStack cursorItem = e.getCursor();
        ItemStack currentItem = e.getCurrentItem();
        InventoryAction action = e.getAction();
        Inventory targetInventory = null;
        ItemStack itemToCheck = null;
        if (clickedInv != null && !(clickedInv.getHolder() instanceof Player) && cursorItem != null && cursorItem.getType() != Material.AIR) {
            if (this.isContainerInventory(clickedInv)) {
                targetInventory = clickedInv;
                itemToCheck = cursorItem;
            }
        } else if (action == InventoryAction.MOVE_TO_OTHER_INVENTORY && currentItem != null && currentItem.getType() != Material.AIR) {
            Inventory topInv = e.getView().getTopInventory();
            Inventory bottomInv = e.getView().getBottomInventory();
            Inventory sourceInv = e.getClickedInventory();
            if (sourceInv != null && sourceInv.equals((Object)bottomInv) && this.isContainerInventory(topInv)) {
                targetInventory = topInv;
                itemToCheck = currentItem;
            }
        }
        if (targetInventory != null && itemToCheck != null && this.itemHasFlag(itemToCheck, "PREVENT_DROP")) {
            e.setCancelled(true);
            if (e.getWhoClicked() instanceof Player) {
                this.sendProtectionMessage((Player)e.getWhoClicked(), "protection-prevent-container-store");
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onInteractItemFramePreventDrop(PlayerInteractEntityEvent e) {
        ItemFrame frame;
        Player player;
        ItemStack itemInHand;
        if (e.getRightClicked() instanceof ItemFrame && this.itemHasFlag(itemInHand = (player = e.getPlayer()).getInventory().getItem(e.getHand()), "PREVENT_DROP") && ((frame = (ItemFrame)e.getRightClicked()).getItem() == null || frame.getItem().getType() == Material.AIR)) {
            e.setCancelled(true);
            this.sendProtectionMessage(player, "protection-prevent-itemframe-store");
        }
    }

    private boolean isContainerInventory(Inventory inv) {
        if (inv == null) {
            return false;
        }
        InventoryType type = inv.getType();
        return inv.getHolder() instanceof BlockInventoryHolder && type != InventoryType.ENDER_CHEST;
    }

    private void sendProtectionMessage(Player p, String key) {
        String rawMsg = this.plugin.getConfig().getString("messages." + key);
        if (rawMsg == null) {
            rawMsg = "&cAction blocked.";
        }
        String parsedMsg = this.plugin.getHookManager().processPlaceholders((OfflinePlayer)p, rawMsg);
        p.sendMessage(ConfigManager.fromLegacyWithPrefix(parsedMsg));
    }
}

