/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.BuffedItems.hooks;

import io.github.altkat.BuffedItems.manager.config.ConfigManager;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.RegisteredServiceProvider;

public class VaultHook {
    private Economy economy;

    public VaultHook() {
        if (this.setupEconomy()) {
            ConfigManager.logInfo("&aVault hooked successfully");
        } else {
            ConfigManager.logInfo("&cVault found but failed to hook Economy provider.");
        }
    }

    private boolean setupEconomy() {
        RegisteredServiceProvider rsp = Bukkit.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            return false;
        }
        this.economy = (Economy)rsp.getProvider();
        return this.economy != null;
    }

    public boolean has(Player player, double amount) {
        if (this.economy == null) {
            return false;
        }
        return this.economy.has((OfflinePlayer)player, amount);
    }

    public void withdraw(Player player, double amount) {
        if (this.economy == null) {
            return;
        }
        this.economy.withdrawPlayer((OfflinePlayer)player, amount);
    }

    public boolean isHooked() {
        return this.economy != null;
    }
}

