/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.BuffedItems.hooks;

import io.github.altkat.BuffedItems.BuffedItems;
import io.github.altkat.BuffedItems.hooks.CoinsEngineHook;
import io.github.altkat.BuffedItems.hooks.ItemsAdderHook;
import io.github.altkat.BuffedItems.hooks.NexoHook;
import io.github.altkat.BuffedItems.hooks.PlaceholderAPIHook;
import io.github.altkat.BuffedItems.hooks.VaultHook;
import org.bukkit.OfflinePlayer;

public class HookManager {
    private final BuffedItems plugin;
    private ItemsAdderHook itemsAdderHook;
    private NexoHook nexoHook;
    private PlaceholderAPIHook placeholderAPIHook;
    private VaultHook vaultHook;
    private CoinsEngineHook coinsEngineHook;

    public HookManager(BuffedItems plugin) {
        this.plugin = plugin;
        this.setupHooks();
    }

    private void setupHooks() {
        if (this.plugin.getServer().getPluginManager().getPlugin("ItemsAdder") != null) {
            this.itemsAdderHook = new ItemsAdderHook();
        }
        if (this.plugin.getServer().getPluginManager().getPlugin("Nexo") != null) {
            this.nexoHook = new NexoHook();
        }
        if (this.plugin.getServer().getPluginManager().getPlugin("PlaceholderAPI") != null) {
            this.placeholderAPIHook = new PlaceholderAPIHook();
        }
        if (this.plugin.getServer().getPluginManager().getPlugin("Vault") != null) {
            this.vaultHook = new VaultHook();
            if (!this.vaultHook.isHooked()) {
                this.vaultHook = null;
            }
        }
        if (this.plugin.getServer().getPluginManager().getPlugin("CoinsEngine") != null) {
            this.coinsEngineHook = new CoinsEngineHook();
        }
    }

    public ItemsAdderHook getItemsAdderHook() {
        return this.itemsAdderHook;
    }

    public NexoHook getNexoHook() {
        return this.nexoHook;
    }

    public PlaceholderAPIHook getPlaceholderAPIHook() {
        return this.placeholderAPIHook;
    }

    public VaultHook getVaultHook() {
        return this.vaultHook;
    }

    public CoinsEngineHook getCoinsEngineHook() {
        return this.coinsEngineHook;
    }

    public boolean isItemsAdderLoaded() {
        return this.itemsAdderHook != null;
    }

    public boolean isNexoLoaded() {
        return this.nexoHook != null;
    }

    public boolean isPlaceholderAPILoaded() {
        return this.placeholderAPIHook != null;
    }

    public boolean isVaultLoaded() {
        return this.vaultHook != null;
    }

    public boolean isCoinsEngineLoaded() {
        return this.coinsEngineHook != null;
    }

    public String processPlaceholders(OfflinePlayer p, String s) {
        if (s == null) {
            return null;
        }
        if (s.indexOf(37) == -1) {
            return s;
        }
        if (this.placeholderAPIHook == null) {
            return s;
        }
        return this.placeholderAPIHook.setPlaceholders(p, s);
    }
}

