/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.BuffedItems.handler;

import io.github.altkat.BuffedItems.BuffedItems;
import io.github.altkat.BuffedItems.manager.config.ConfigManager;

public class CustomModelDataHandler {
    private final BuffedItems plugin;
    private boolean itemsAdderAvailable = false;
    private boolean nexoAvailable = false;

    public CustomModelDataHandler(BuffedItems plugin) {
        this.plugin = plugin;
    }

    public CustomModelData resolve(String input, String itemId) {
        if (input == null || input.trim().isEmpty()) {
            return null;
        }
        String trimmed = input.trim();
        try {
            int value = Integer.parseInt(trimmed);
            if (value < 0) {
                ConfigManager.sendDebugMessage(1, () -> "[CMD] Invalid custom-model-data for item '" + itemId + "': negative value " + value);
                return null;
            }
            ConfigManager.sendDebugMessage(3, () -> "[CMD] Resolved direct integer custom-model-data for '" + itemId + "': " + value);
            return new CustomModelData(value, trimmed, CustomModelData.Source.DIRECT);
        }
        catch (NumberFormatException value) {
            if (trimmed.contains(":")) {
                String[] parts = trimmed.split(":", 2);
                String pluginName = parts[0].toLowerCase();
                String externalItemId = parts[1];
                switch (pluginName) {
                    case "itemsadder": {
                        return this.resolveItemsAdder(externalItemId, trimmed, itemId);
                    }
                    case "nexo": {
                        return this.resolveNexo(externalItemId, trimmed, itemId);
                    }
                }
                ConfigManager.sendDebugMessage(1, () -> "[CMD] Unknown plugin prefix for item '" + itemId + "': " + pluginName);
                return null;
            }
            ConfigManager.sendDebugMessage(1, () -> "[CMD] Invalid custom-model-data format for item '" + itemId + "': " + trimmed);
            return null;
        }
    }

    private CustomModelData resolveItemsAdder(String externalItemId, String rawValue, String buffedItemId) {
        if (!this.plugin.getHookManager().isItemsAdderLoaded()) {
            ConfigManager.sendDebugMessage(1, () -> "[CMD] ItemsAdder format used but plugin not hooked: " + buffedItemId);
            return null;
        }
        Integer cmd = this.plugin.getHookManager().getItemsAdderHook().getCustomModelData(externalItemId);
        if (cmd != null) {
            ConfigManager.sendDebugMessage(3, () -> "[CMD] Resolved ItemsAdder CMD for '" + buffedItemId + "': " + externalItemId + " -> " + cmd);
            return new CustomModelData(cmd, rawValue, CustomModelData.Source.ITEMSADDER);
        }
        ConfigManager.sendDebugMessage(1, () -> "[CMD] ItemsAdder item '" + externalItemId + "' not found or has no CMD.");
        return null;
    }

    private CustomModelData resolveNexo(String externalItemId, String rawValue, String buffedItemId) {
        if (!this.plugin.getHookManager().isNexoLoaded()) {
            ConfigManager.sendDebugMessage(1, () -> "[CMD] Nexo format used but plugin not hooked: " + buffedItemId);
            return null;
        }
        Integer cmd = this.plugin.getHookManager().getNexoHook().getCustomModelData(externalItemId);
        if (cmd != null) {
            ConfigManager.sendDebugMessage(3, () -> "[CMD] Resolved Nexo CMD for '" + buffedItemId + "': " + externalItemId + " -> " + cmd);
            return new CustomModelData(cmd, rawValue, CustomModelData.Source.NEXO);
        }
        ConfigManager.sendDebugMessage(1, () -> "[CMD] Nexo item '" + externalItemId + "' not found or has no CMD.");
        return null;
    }

    public static class CustomModelData {
        private final int value;
        private final String rawValue;
        private final Source source;

        public CustomModelData(int value, String rawValue, Source source) {
            this.value = value;
            this.rawValue = rawValue;
            this.source = source;
        }

        public int getValue() {
            return this.value;
        }

        public String getRawValue() {
            return this.rawValue;
        }

        public Source getSource() {
            return this.source;
        }

        public static enum Source {
            DIRECT,
            ITEMSADDER,
            NEXO;

        }
    }
}

