/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.authBB.Handlers;

import io.github.altkat.authBB.AuthBB;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.PluginMessageListener;
import org.bukkit.scheduler.BukkitRunnable;

public class ConnectionHandler
implements PluginMessageListener {
    private final AuthBB plugin;
    private final ConfigurationSection proxySection;
    private final Map<UUID, String> pendingServerChecks = new HashMap<UUID, String>();
    private final List<UUID> sending = new ArrayList<UUID>();

    public ConnectionHandler(AuthBB plugin) {
        this.plugin = plugin;
        this.proxySection = plugin.getConfig().getConfigurationSection("Proxy");
    }

    public void connectServer(Player player, String server) {
        if (this.sending.contains(player.getUniqueId())) {
            player.sendMessage(this.plugin.getMessageManager().PLAYER_ALREADY_CONNECTING);
            return;
        }
        this.pendingServerChecks.put(player.getUniqueId(), server);
        try {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(output);
            out.writeUTF("GetServers");
            player.sendPluginMessage((Plugin)this.plugin, "BungeeCord", output.toByteArray());
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not send GetServers plugin message", e);
        }
    }

    public void onPluginMessageReceived(String channel, Player player, byte[] message) {
        if (!channel.equals("BungeeCord")) {
            return;
        }
        UUID playerUUID = player.getUniqueId();
        if (!this.pendingServerChecks.containsKey(playerUUID)) {
            return;
        }
        String targetServer = this.pendingServerChecks.get(playerUUID);
        try (DataInputStream in = new DataInputStream(new ByteArrayInputStream(message));){
            String subchannel = in.readUTF();
            if (subchannel.equals("GetServers")) {
                String[] servers = in.readUTF().split(", ");
                this.pendingServerChecks.remove(playerUUID);
                if (!Arrays.asList(servers).contains(targetServer)) {
                    player.sendMessage(this.plugin.getMessageManager().SERVER_NOT_FOUND);
                    this.plugin.getServer().getConsoleSender().sendMessage("\u00a79[\u00a76AuthBB\u00a79] \u00a7c" + player.getName() + " tried to connect to a server ('" + targetServer + "') not found in the proxy's server list.");
                    player.resetTitle();
                    return;
                }
                this.sendPlayerToProxyServer(player, targetServer);
            }
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Error processing plugin message from BungeeCord", e);
            this.pendingServerChecks.remove(playerUUID);
        }
    }

    private void sendPlayerToProxyServer(final Player player, final String server) {
        int delay = this.proxySection.getInt("delay", 3);
        String successMessage = this.proxySection.getString("success", "&aConnecting you to the server...").replace("&", "\u00a7");
        final String errorMessage = this.proxySection.getString("error-command", "&cAn error occurred.").replace("&", "\u00a7");
        this.sending.add(player.getUniqueId());
        this.plugin.getConnectionTitle().sendTitle(player);
        player.sendMessage(successMessage);
        new BukkitRunnable(){

            public void run() {
                try {
                    ByteArrayOutputStream output = new ByteArrayOutputStream();
                    DataOutputStream out = new DataOutputStream(output);
                    out.writeUTF("Connect");
                    out.writeUTF(server);
                    player.sendPluginMessage((Plugin)ConnectionHandler.this.plugin, "BungeeCord", output.toByteArray());
                }
                catch (IOException error) {
                    ConnectionHandler.this.plugin.getLogger().log(Level.SEVERE, "Could not send Connect plugin message for " + player.getName(), error);
                    player.sendMessage(errorMessage);
                }
                finally {
                    ConnectionHandler.this.sending.remove(player.getUniqueId());
                }
            }
        }.runTaskLater((Plugin)this.plugin, (long)delay * 20L);
    }

    public boolean isPlayerSending(Player player) {
        return this.sending.contains(player.getUniqueId());
    }
}

