/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.authBB.BossBars;

import fr.xephi.authme.api.v3.AuthMeApi;
import io.github.altkat.authBB.AuthBB;
import io.github.altkat.authBB.Handlers.RandomServer;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.boss.KeyedBossBar;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public abstract class AbstractBossBar {
    protected final AuthBB plugin;
    protected final ConfigurationSection section;
    protected final AuthMeApi authMe;
    private final RandomServer randomServer;

    public AbstractBossBar(AuthBB plugin, String sectionName) {
        this.plugin = plugin;
        this.section = plugin.getConfig().getConfigurationSection(sectionName);
        this.authMe = AuthMeApi.getInstance();
        this.randomServer = new RandomServer(plugin);
    }

    public void createBB(final Player player) {
        BarStyle barStyle;
        BarColor barColor;
        final int time = this.section.getInt("time");
        String title = this.section.getString("title", "").replace("%time%", Integer.toString(time));
        String color = this.section.getString("color", "BLUE");
        String style = this.section.getString("style", "SEGMENTED_10");
        String kickMessage = this.section.getName().equals("LoginBossBar") ? this.plugin.getConfig().getString("Kick.login-message", "You were kicked for not logging in.").replace("&", "\u00a7") : this.plugin.getConfig().getString("Kick.register-message", "You were kicked for not registering in time.").replace("&", "\u00a7");
        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, player.getUniqueId().toString());
        KeyedBossBar existingBossBar = Bukkit.getBossBar((NamespacedKey)key);
        if (existingBossBar != null) {
            existingBossBar.removePlayer(player);
            Bukkit.removeBossBar((NamespacedKey)key);
        }
        try {
            barColor = BarColor.valueOf((String)color.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            this.plugin.getLogger().warning("Invalid BossBar color '" + color + "' in config.yml. Defaulting to BLUE.");
            barColor = BarColor.BLUE;
        }
        try {
            barStyle = BarStyle.valueOf((String)style.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            this.plugin.getLogger().warning("Invalid BossBar style '" + style + "' in config.yml. Defaulting to SEGMENTED_10.");
            barStyle = BarStyle.SEGMENTED_10;
        }
        KeyedBossBar bossBar = Bukkit.createBossBar((NamespacedKey)key, (String)title, (BarColor)barColor, (BarStyle)barStyle, (BarFlag[])new BarFlag[0]);
        bossBar.addPlayer(player);
        bossBar.setVisible(true);
        new BukkitRunnable((BossBar)bossBar, kickMessage){
            private int secondsRemaining;
            final /* synthetic */ BossBar val$bossBar;
            final /* synthetic */ String val$kickMessage;
            {
                this.val$bossBar = bossBar;
                this.val$kickMessage = string;
                this.secondsRemaining = time;
            }

            public void run() {
                if (AbstractBossBar.this.authMe.isAuthenticated(player)) {
                    this.val$bossBar.removePlayer(player);
                    player.resetTitle();
                    this.cancel();
                    if (AbstractBossBar.this.plugin.isProxyModeActive()) {
                        AbstractBossBar.this.plugin.getConnectionTitle().sendTitle(player);
                        String server = AbstractBossBar.this.randomServer.getRandomServer();
                        if (server != null) {
                            AbstractBossBar.this.plugin.getConnectionHandler().connectServer(player, server);
                        } else {
                            AbstractBossBar.this.plugin.getLogger().warning("Could not send player " + player.getName() + " to a server because the server list in config.yml is empty.");
                        }
                    }
                    return;
                }
                if (this.secondsRemaining <= 0) {
                    this.val$bossBar.removePlayer(player);
                    if (AbstractBossBar.this.plugin.getConfig().getBoolean("Kick.enabled")) {
                        player.kickPlayer(this.val$kickMessage);
                    }
                    this.cancel();
                } else {
                    --this.secondsRemaining;
                    String updatedTitle = AbstractBossBar.this.section.getString("title", "").replace("%time%", String.valueOf(this.secondsRemaining)).replace("&", "\u00a7");
                    this.val$bossBar.setTitle(updatedTitle);
                    this.val$bossBar.setProgress(Math.max(0.0, (double)this.secondsRemaining / (double)time));
                    if ((double)this.secondsRemaining <= (double)time * 0.2) {
                        this.val$bossBar.setColor(BarColor.RED);
                    } else if ((double)this.secondsRemaining <= (double)time * 0.5) {
                        this.val$bossBar.setColor(BarColor.YELLOW);
                    }
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 20L);
    }
}

