/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.advancementannouncer.util;

import com.google.common.base.Charsets;
import io.github.altkat.advancementannouncer.AdvancementAnnouncer;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigUpdater {
    public static void update(AdvancementAnnouncer plugin) throws IOException {
        ConfigUpdater.migratePresets(plugin);
        File configFile = new File(plugin.getDataFolder(), "config.yml");
        YamlConfiguration defaultConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(plugin.getResource("config.yml"), Charsets.UTF_8));
        YamlConfiguration userConfig = YamlConfiguration.loadConfiguration((File)configFile);
        userConfig.options().copyHeader(true);
        userConfig.options().header(defaultConfig.options().header());
        for (String key : defaultConfig.getKeys(true)) {
            if (key.startsWith("presets.") || key.startsWith("auto-announce.messages.") || key.startsWith("join-features.join-messages.messages.") || key.startsWith("join-features.first-join-messages.messages.") || userConfig.contains(key)) continue;
            userConfig.set(key, defaultConfig.get(key));
        }
        if (userConfig.isSet("lang-messages.edit-gui-title")) {
            userConfig.set("lang-messages.edit-gui-title", null);
        }
        if (userConfig.isSet("lang-messages.presets-gui-title")) {
            userConfig.set("lang-messages.presets-gui-title", null);
        }
        if (userConfig.isSet("lang-messages.auto-announce-gui-title")) {
            userConfig.set("lang-messages.auto-announce-gui-title", null);
        }
        if (userConfig.isSet("lang-messages.input-cancelled")) {
            userConfig.set("lang-messages.input-cancelled", null);
        }
        if (userConfig.isSet("bstats")) {
            userConfig.set("bstats", null);
        }
        ConfigUpdater.addMissingMessageFields(userConfig.getConfigurationSection("presets"));
        ConfigUpdater.addMissingMessageFields(userConfig.getConfigurationSection("auto-announce.messages"));
        ConfigUpdater.addMissingMessageFields(userConfig.getConfigurationSection("join-features.join-messages.messages"));
        ConfigUpdater.addMissingMessageFields(userConfig.getConfigurationSection("join-features.first-join-messages.messages"));
        if (!userConfig.contains("presets")) {
            userConfig.createSection("presets");
        }
        if (!userConfig.contains("auto-announce.messages")) {
            userConfig.createSection("auto-announce.messages");
        }
        if (!userConfig.contains("join-features.join-messages.messages")) {
            userConfig.createSection("join-features.join-messages.messages");
        }
        if (!userConfig.contains("join-features.first-join-messages.messages")) {
            userConfig.createSection("join-features.first-join-messages.messages");
        }
        userConfig.save(configFile);
    }

    private static void addMissingMessageFields(ConfigurationSection section) {
        if (section == null) {
            return;
        }
        for (String key : section.getKeys(false)) {
            ConfigurationSection messageConfig;
            if (!section.isConfigurationSection(key) || (messageConfig = section.getConfigurationSection(key)) == null) continue;
            if (!messageConfig.isSet("custom-model-data")) {
                messageConfig.set("custom-model-data", (Object)"");
            }
            if (messageConfig.isSet("sound")) continue;
            messageConfig.set("sound", (Object)"");
        }
    }

    private static void migratePresets(AdvancementAnnouncer plugin) {
        FileConfiguration config = plugin.getConfig();
        ConfigurationSection presets = config.getConfigurationSection("presets");
        if (presets == null) {
            return;
        }
        boolean migrated = false;
        boolean backupCreated = false;
        for (String key : presets.getKeys(false)) {
            if (!presets.isString(key)) continue;
            if (!backupCreated) {
                ConfigUpdater.createBackup(plugin);
                backupCreated = true;
            }
            String oldMessage = presets.getString(key);
            presets.set(key, null);
            ConfigurationSection newSection = presets.createSection(key);
            newSection.set("message", (Object)oldMessage);
            newSection.set("style", (Object)"GOAL");
            newSection.set("icon", (Object)"PAPER");
            newSection.set("custom-model-data", (Object)"");
            AdvancementAnnouncer.log("&#FCD05CMigrated legacy preset to new format: " + key);
            migrated = true;
        }
        if (migrated) {
            plugin.saveConfig();
            plugin.reloadConfig();
        }
    }

    private static void createBackup(AdvancementAnnouncer plugin) {
        try {
            File configFile = new File(plugin.getDataFolder(), "config.yml");
            File backupFile = new File(plugin.getDataFolder(), "config.yml.backup");
            Files.copy(configFile.toPath(), backupFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            AdvancementAnnouncer.log("&#FCD05CCreated backup of config.yml before migration.");
        }
        catch (IOException e) {
            AdvancementAnnouncer.log("&#F86B6BFailed to create config backup: " + e.getMessage());
        }
    }
}

