/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.advancementannouncer.feature;

import io.github.altkat.advancementannouncer.AdvancementAnnouncer;
import io.github.altkat.advancementannouncer.core.AdvancementHandler;
import io.github.altkat.advancementannouncer.core.PlayerData;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;

public class JoinListener
implements Listener {
    private final AdvancementAnnouncer plugin = AdvancementAnnouncer.getInstance();

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (!PlayerData.returnToggleData(player.getUniqueId())) {
            return;
        }
        String basePath = "join-features." + (player.hasPlayedBefore() ? "join-messages" : "first-join-messages");
        if (!this.plugin.getConfig().getBoolean(basePath + ".enabled")) {
            return;
        }
        ConfigurationSection messagesSection = this.plugin.getConfig().getConfigurationSection(basePath + ".messages");
        if (messagesSection == null) {
            return;
        }
        Set keys = messagesSection.getKeys(false);
        if (keys.isEmpty()) {
            return;
        }
        ArrayList keyList = new ArrayList(keys);
        String randomKey = (String)keyList.get(ThreadLocalRandom.current().nextInt(keyList.size()));
        String messagePath = basePath + ".messages." + randomKey;
        String message = this.plugin.getConfig().getString(messagePath + ".message");
        String styleString = this.plugin.getConfig().getString(messagePath + ".style", "GOAL").toUpperCase();
        String iconString = this.plugin.getConfig().getString(messagePath + ".icon", "STONE").toUpperCase();
        String customModelDataString = this.plugin.getConfig().getString(messagePath + ".custom-model-data", null);
        String soundString = this.plugin.getConfig().getString(messagePath + ".sound", "");
        try {
            AdvancementHandler.Style style = AdvancementHandler.Style.valueOf(styleString);
            Material icon = Material.valueOf((String)iconString);
            this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                if (player.isOnline()) {
                    AdvancementHandler.displayTo(player, icon.name().toLowerCase(), customModelDataString, message, style, soundString);
                }
            }, 20L);
        }
        catch (IllegalArgumentException e) {
            AdvancementAnnouncer.log("&eInvalid style or icon in join messages configuration: " + randomKey);
        }
    }
}

