/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.advancementannouncer.feature;

import io.github.altkat.advancementannouncer.AdvancementAnnouncer;
import io.github.altkat.advancementannouncer.core.AdvancementHandler;
import io.github.altkat.advancementannouncer.core.PlayerData;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class AutoAnnounce {
    static AdvancementAnnouncer plugin = AdvancementAnnouncer.getInstance();
    static int taskID;
    static int order;
    static int lastMessageIndex;
    static int failedAttempts;

    public static void startAutoAnnounce() {
        if (!plugin.getConfig().getBoolean("auto-announce.enabled")) {
            return;
        }
        ConfigurationSection mainSection = plugin.getConfig().getConfigurationSection("auto-announce");
        ConfigurationSection subSection = mainSection.getConfigurationSection("messages");
        if (subSection == null) {
            AdvancementAnnouncer.log("&eNo messages section found in the configuration. AutoAnnounce will not start.");
            return;
        }
        String mode = mainSection.getString("mode");
        order = 0;
        failedAttempts = 0;
        lastMessageIndex = -1;
        Set keySet = subSection.getKeys(false);
        List keyList = keySet.stream().toList();
        int messageCount = keyList.size();
        if (messageCount == 0) {
            AdvancementAnnouncer.log("&eNo messages found in the configuration. AutoAnnounce will not start.");
            return;
        }
        taskID = Bukkit.getScheduler().runTaskTimer((Plugin)plugin, () -> {
            AdvancementHandler.Style style;
            String key;
            if (failedAttempts >= 10) {
                if (failedAttempts == 10) {
                    AdvancementAnnouncer.log("&cFailed to find a valid message after 10 attempts. Stopping auto announcements... Please fix the issue in the config then reload the plugin.");
                    AutoAnnounce.stopAutoAnnounce();
                    ++failedAttempts;
                }
                return;
            }
            if (mode.equalsIgnoreCase("random")) {
                if (messageCount > 1) {
                    while ((order = ThreadLocalRandom.current().nextInt(messageCount)) == lastMessageIndex) {
                    }
                } else {
                    order = 0;
                }
                key = (String)keyList.get(order);
                lastMessageIndex = order;
            } else {
                if (order >= messageCount) {
                    order = 0;
                }
                key = (String)keyList.get(order);
                ++order;
            }
            ConfigurationSection messageSection = subSection.getConfigurationSection(key);
            if (messageSection == null) {
                AdvancementAnnouncer.log("&eInvalid message configuration for key: " + key + ". Skipping.");
                ++failedAttempts;
                return;
            }
            String styleString = messageSection.getString("style", "GOAL").toUpperCase();
            try {
                style = AdvancementHandler.Style.valueOf(styleString);
            }
            catch (IllegalArgumentException e) {
                AdvancementAnnouncer.log("&eInvalid style: " + styleString + ". Skipping announcement (" + key + ").");
                ++failedAttempts;
                return;
            }
            String icon = messageSection.getString("icon", "PAPER").toLowerCase();
            if (Material.matchMaterial((String)icon) == null) {
                AdvancementAnnouncer.log("&eInvalid icon: " + icon + ". Skipping announcement (" + key + ").");
                ++failedAttempts;
                return;
            }
            String message = messageSection.getString("message");
            String customModelData = messageSection.getString("custom-model-data", "");
            String soundString = messageSection.getString("sound", "");
            Collection playerList = Bukkit.getOnlinePlayers();
            if (playerList.isEmpty()) {
                return;
            }
            if (failedAttempts > 0) {
                AdvancementAnnouncer.log("&aValid message found after " + failedAttempts + " attempts. Continuing auto announcements.");
                failedAttempts = 0;
            }
            for (Player player : playerList) {
                if (!PlayerData.returnToggleData(player.getUniqueId())) continue;
                AdvancementHandler.displayTo(player, icon, customModelData, message, style, soundString);
            }
        }, 60L, (long)mainSection.getInt("interval") * 20L).getTaskId();
    }

    public static void stopAutoAnnounce() {
        Bukkit.getScheduler().cancelTask(taskID);
    }

    static {
        order = 0;
        lastMessageIndex = -1;
        failedAttempts = 0;
    }
}

