/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.advancementannouncer.editor;

import io.github.altkat.advancementannouncer.AdvancementAnnouncer;
import io.github.altkat.advancementannouncer.cmd.ResolvedIconData;
import io.github.altkat.advancementannouncer.editor.menu.AutoAnnounceGUI;
import io.github.altkat.advancementannouncer.editor.menu.ConfirmationGUI;
import io.github.altkat.advancementannouncer.editor.menu.EditorGUI;
import io.github.altkat.advancementannouncer.editor.menu.IconSelectionGUI;
import io.github.altkat.advancementannouncer.editor.menu.JoinFeaturesGUI;
import io.github.altkat.advancementannouncer.editor.menu.JoinMessageListGUI;
import io.github.altkat.advancementannouncer.editor.menu.MainMenuGUI;
import io.github.altkat.advancementannouncer.editor.menu.PresetsGUI;
import io.github.altkat.advancementannouncer.editor.menu.SoundSelectionGUI;
import io.github.altkat.advancementannouncer.editor.menu.StyleSelectionGUI;
import io.github.altkat.advancementannouncer.util.TextUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class GUIHandler
implements Listener {
    private final AdvancementAnnouncer plugin = AdvancementAnnouncer.getInstance();
    public static final Map<UUID, Runnable> confirmationActions = new HashMap<UUID, Runnable>();
    private final Set<UUID> isNavigating = new HashSet<UUID>();
    public static final ItemStack FILLER_GLASS = new ItemStack(Material.GRAY_STAINED_GLASS_PANE);

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        String title = event.getView().getTitle();
        Player player = (Player)event.getWhoClicked();
        if (!this.isRelevantGUI(title)) {
            return;
        }
        event.setCancelled(true);
        if (event.getCurrentItem() == null || event.getCurrentItem().getType().isAir()) {
            return;
        }
        if (this.isNavigating.contains(player.getUniqueId())) {
            return;
        }
        this.isNavigating.add(player.getUniqueId());
        this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> this.isNavigating.remove(player.getUniqueId()), 5L);
        if (title.equals(TextUtil.color("&#7688FFAdvancement Announcer Edit"))) {
            MainMenuGUI.handleClick(event);
        } else if (title.equals(TextUtil.color("&#7688FFAdvancement Announcer Presets"))) {
            PresetsGUI.handleClick(event);
        } else if (title.equals(TextUtil.color("&#7688FFAuto Announce Config"))) {
            AutoAnnounceGUI.handleClick(event);
        } else if (title.contains("Join Features") || title.contains("Join Messages")) {
            if (title.contains("Join Features")) {
                JoinFeaturesGUI.handleClick(event);
            } else {
                JoinMessageListGUI.handleClick(event);
            }
        } else if (title.startsWith("Editing ") || title.startsWith("Creating ")) {
            EditorGUI.handleClick(event);
        } else if (title.equals("Select a Style")) {
            StyleSelectionGUI.handleClick(event);
        } else if (title.startsWith("Select an Icon")) {
            IconSelectionGUI.handleClick(event);
        } else if (title.equals("Select a Sound")) {
            SoundSelectionGUI.handleClick(event);
        } else if (title.equals("Confirm Deletion")) {
            ConfirmationGUI.handleClick(event);
        }
    }

    private boolean isRelevantGUI(String title) {
        return title.equals(TextUtil.color("&#7688FFAdvancement Announcer Edit")) || title.equals(TextUtil.color("&#7688FFAdvancement Announcer Presets")) || title.equals(TextUtil.color("&#7688FFAuto Announce Config")) || title.contains(TextUtil.color("Join Features")) || title.contains(TextUtil.color("Join Messages")) || title.startsWith("Editing ") || title.startsWith("Creating ") || title.equals("Select a Style") || title.startsWith("Select an Icon") || title.equals("Select a Sound") || title.equals("Confirm Deletion");
    }

    public static void fillBackground(Inventory gui) {
        for (int i = 0; i < gui.getSize(); ++i) {
            if (gui.getItem(i) != null && gui.getItem(i).getType() != Material.AIR) continue;
            gui.setItem(i, FILLER_GLASS);
        }
    }

    public static ItemStack createDisplayItem(String icon, String cmdInput, String displayName, List<String> lore) {
        ItemMeta meta;
        ResolvedIconData data;
        Material material;
        AdvancementAnnouncer plugin = AdvancementAnnouncer.getInstance();
        try {
            material = Material.valueOf((String)icon.toUpperCase());
        }
        catch (Exception e) {
            material = Material.PAPER;
        }
        ItemStack item = new ItemStack(material);
        int cmdValue = 0;
        if (plugin.isApiAvailable() && cmdInput != null && !cmdInput.isBlank() && (data = plugin.getCmdResolver().resolve(cmdInput, icon)) != null) {
            cmdValue = data.getValue();
        }
        if ((meta = item.getItemMeta()) != null) {
            meta.setDisplayName(displayName);
            meta.setLore(lore);
            if (cmdValue > 0) {
                try {
                    meta.setCustomModelData(Integer.valueOf(cmdValue));
                }
                catch (Exception e) {
                    plugin.getLogger().warning("Failed to apply CustomModelData to GUI icon: " + e.getMessage());
                }
            }
            item.setItemMeta(meta);
        }
        return item;
    }

    static {
        ItemMeta meta = FILLER_GLASS.getItemMeta();
        meta.setDisplayName(" ");
        FILLER_GLASS.setItemMeta(meta);
    }
}

