/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.advancementannouncer.core;

import com.fren_gor.ultimateAdvancementAPI.UltimateAdvancementAPI;
import com.fren_gor.ultimateAdvancementAPI.advancement.display.AdvancementFrameType;
import io.github.altkat.advancementannouncer.AdvancementAnnouncer;
import io.github.altkat.advancementannouncer.cmd.ResolvedIconData;
import io.github.altkat.advancementannouncer.core.PlayerData;
import io.github.altkat.advancementannouncer.util.TextUtil;
import java.util.HashMap;
import java.util.Map;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.advancement.Advancement;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class AdvancementHandler {
    public static void displayTo(Player player, String iconMaterial, String customModelDataInput, String message, Style style, String sound) {
        AdvancementAnnouncer plugin = AdvancementAnnouncer.getInstance();
        int cmdValue = 0;
        if (iconMaterial == null || iconMaterial.isBlank() || Material.matchMaterial((String)iconMaterial.toUpperCase()) == null) {
            iconMaterial = "PAPER";
        }
        if (customModelDataInput != null && !customModelDataInput.isBlank()) {
            ResolvedIconData data = plugin.getCmdResolver().resolve(customModelDataInput, iconMaterial);
            if (data != null) {
                cmdValue = data.getValue();
            } else {
                AdvancementAnnouncer.log("&eCould not resolve custom-model-data: '" + customModelDataInput + "' for icon '" + iconMaterial + "'. Using 0.");
            }
        }
        String finalMessage = TextUtil.color(message);
        if (plugin.isPAPIEnabled()) {
            finalMessage = PlaceholderAPI.setPlaceholders((Player)player, (String)finalMessage);
        }
        if (plugin.isApiAvailable()) {
            try {
                ItemStack iconStack = new ItemStack(Material.matchMaterial((String)iconMaterial.toUpperCase()));
                ItemMeta meta = iconStack.getItemMeta();
                if (meta != null) {
                    if (cmdValue > 0) {
                        meta.setCustomModelData(Integer.valueOf(cmdValue));
                    }
                    iconStack.setItemMeta(meta);
                }
                UltimateAdvancementAPI api = plugin.getAdvancementAPI();
                AdvancementFrameType frameType = AdvancementFrameType.valueOf(style.name());
                api.displayCustomToast(player, iconStack, finalMessage.replace("|", "\n"), frameType);
            }
            catch (Exception e) {
                AdvancementAnnouncer.log("&cFailed to display toast using UltimateAdvancementAPI: " + e.getMessage());
                LegacyAdvancementHandler.displayTo(player, iconMaterial, finalMessage, style);
            }
        } else {
            LegacyAdvancementHandler.displayTo(player, iconMaterial, finalMessage, style);
        }
        AdvancementHandler.playSound(player, sound);
    }

    public static void displayTo(Player player, String icon, String message, Style style) {
        AdvancementHandler.displayTo(player, icon, null, message, style, null);
    }

    private static void playSound(Player player, String soundKey) {
        if (soundKey == null || soundKey.isBlank()) {
            return;
        }
        if (!PlayerData.areSoundsEnabled(player.getUniqueId())) {
            return;
        }
        String finalKey = soundKey.trim();
        try {
            Sound sound = Sound.valueOf((String)finalKey.toUpperCase());
            player.playSound(player.getLocation(), sound, 1.0f, 1.0f);
        }
        catch (IllegalArgumentException e) {
            try {
                String customSoundKey = finalKey.toLowerCase().replace('_', '.');
                player.playSound(player.getLocation(), customSoundKey, 1.0f, 1.0f);
            }
            catch (Exception e2) {
                AdvancementAnnouncer.log("&c[Sound Error] Could not play sound: '" + finalKey + "'. Is it a valid Sound enum or custom sound string?");
            }
        }
        catch (Exception e) {
            AdvancementAnnouncer.log("&c[Sound Error] An unexpected error occurred while playing sound '" + finalKey + "': " + e.getMessage());
        }
    }

    public static enum Style {
        GOAL,
        TASK,
        CHALLENGE;

    }

    private static class LegacyAdvancementHandler {
        private final NamespacedKey key;
        private final String icon;
        private final String message;
        private final Style style;
        private final AdvancementAnnouncer plugin = AdvancementAnnouncer.getInstance();
        private static final Map<String, NamespacedKey> cachedKeys = new HashMap<String, NamespacedKey>();

        private LegacyAdvancementHandler(String icon, String message, Style style) {
            this.icon = icon;
            this.message = message;
            this.style = style;
            String cacheId = icon.toLowerCase() + "_" + style.toString().toLowerCase() + "_" + Integer.toHexString(message.hashCode());
            if (!cachedKeys.containsKey(cacheId)) {
                this.key = new NamespacedKey((Plugin)this.plugin, "t_" + cacheId);
                this.createAdvancement();
                cachedKeys.put(cacheId, this.key);
            } else {
                this.key = cachedKeys.get(cacheId);
            }
        }

        private void start(Player player) {
            this.revokeAdvancement(player);
            this.grantAdvancement(player);
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                if (player.isOnline()) {
                    this.revokeAdvancement(player);
                }
            }, 40L);
        }

        private void createAdvancement() {
            String itemKey = this.plugin.isModernVersion() ? "id" : "item";
            String advancementJson = "{\n    \"criteria\": {\n        \"trigger\": {\n            \"trigger\": \"minecraft:impossible\"\n        }\n    },\n    \"display\": {\n        \"icon\": {\n            \"" + itemKey + "\": \"minecraft:" + this.icon + "\"\n        },\n        \"title\": {\n            \"text\": \"" + this.message.replace("|", "\n") + "\"\n        },\n        \"description\": {\n            \"text\": \"\"\n        },\n        \"background\": \"minecraft:textures/gui/advancements/backgrounds/adventure.png\",\n        \"frame\": \"" + this.style.toString().toLowerCase() + "\",\n        \"announce_to_chat\": false,\n        \"show_toast\": true,\n        \"hidden\": true\n    },\n    \"requirements\": [\n        [\n            \"trigger\"\n        ]\n    ]\n}";
            try {
                Bukkit.getUnsafe().loadAdvancement(this.key, advancementJson);
            }
            catch (Exception e) {
                AdvancementAnnouncer.log("&cError creating legacy advancement: " + e.getMessage());
            }
        }

        private void grantAdvancement(Player player) {
            try {
                Advancement adv = Bukkit.getAdvancement((NamespacedKey)this.key);
                if (adv != null) {
                    player.getAdvancementProgress(adv).awardCriteria("trigger");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void revokeAdvancement(Player player) {
            try {
                Advancement adv = Bukkit.getAdvancement((NamespacedKey)this.key);
                if (adv != null && player.isOnline()) {
                    player.getAdvancementProgress(adv).revokeCriteria("trigger");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public static void displayTo(Player player, String icon, String message, Style style) {
            new LegacyAdvancementHandler(icon, message, style).start(player);
        }
    }
}

