/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.advancementannouncer.cmd;

import io.github.altkat.advancementannouncer.AdvancementAnnouncer;
import io.github.altkat.advancementannouncer.cmd.ResolvedIconData;
import org.bukkit.Bukkit;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class CustomModelDataResolver {
    private final AdvancementAnnouncer plugin;
    private boolean itemsAdderAvailable = false;
    private boolean nexoAvailable = false;
    private final int serverVersion;

    public CustomModelDataResolver(AdvancementAnnouncer plugin) {
        this.plugin = plugin;
        this.serverVersion = plugin.getVersion();
    }

    public void detectExternalPlugins() {
        this.itemsAdderAvailable = Bukkit.getPluginManager().getPlugin("ItemsAdder") != null;
        boolean bl = this.nexoAvailable = Bukkit.getPluginManager().getPlugin("Nexo") != null;
        if (this.itemsAdderAvailable) {
            AdvancementAnnouncer.log("&aItemsAdder detected - CustomModelData integration enabled.");
        }
        if (this.nexoAvailable) {
            AdvancementAnnouncer.log("&aNexo detected - CustomModelData integration enabled.");
        }
    }

    public ResolvedIconData resolve(String input, String itemId) {
        if (input == null || input.trim().isEmpty()) {
            return null;
        }
        String trimmed = input.trim();
        try {
            int value = Integer.parseInt(trimmed);
            if (value < 0) {
                AdvancementAnnouncer.log("&e[CMD] Invalid custom-model-data for item '" + itemId + "': negative value " + value);
                return null;
            }
            return new ResolvedIconData(value, trimmed, ResolvedIconData.Source.DIRECT);
        }
        catch (NumberFormatException value) {
            if (trimmed.contains(":")) {
                String[] parts = trimmed.split(":", 2);
                String pluginName = parts[0].toLowerCase();
                String externalItemId = parts[1];
                switch (pluginName) {
                    case "itemsadder": {
                        return this.resolveItemsAdder(externalItemId, trimmed, itemId);
                    }
                    case "nexo": {
                        return this.resolveNexo(externalItemId, trimmed, itemId);
                    }
                }
                AdvancementAnnouncer.log("&e[CMD] Unknown plugin prefix for item '" + itemId + "': " + pluginName);
                return null;
            }
            AdvancementAnnouncer.log("&e[CMD] Invalid custom-model-data format for item '" + itemId + "': " + trimmed);
            return null;
        }
    }

    private ResolvedIconData resolveItemsAdder(String externalItemId, String rawValue, String buffedItemId) {
        if (!this.itemsAdderAvailable) {
            AdvancementAnnouncer.log("&e[CMD] ItemsAdder format used but plugin not found for item: " + buffedItemId);
            return null;
        }
        try {
            Class<?> customStackClass = Class.forName("dev.lone.itemsadder.api.CustomStack");
            Object customStack = customStackClass.getMethod("getInstance", String.class).invoke(null, externalItemId);
            if (customStack == null) {
                AdvancementAnnouncer.log("&e[CMD] ItemsAdder item not found: " + externalItemId + " (for item: " + buffedItemId + ")");
                return null;
            }
            Object itemStackObj = customStackClass.getMethod("getItemStack", new Class[0]).invoke(customStack, new Object[0]);
            ItemStack itemStack = (ItemStack)itemStackObj;
            Integer cmd = this.extractCustomModelData(itemStack);
            if (cmd != null) {
                return new ResolvedIconData(cmd, rawValue, ResolvedIconData.Source.ITEMSADDER);
            }
            AdvancementAnnouncer.log("&e[CMD] ItemsAdder item '" + externalItemId + "' has no custom model data");
            return null;
        }
        catch (Exception e) {
            AdvancementAnnouncer.log("&c[CMD] Failed to resolve ItemsAdder item for '" + buffedItemId + "': " + e.getMessage());
            return null;
        }
    }

    private ResolvedIconData resolveNexo(String externalItemId, String rawValue, String buffedItemId) {
        if (!this.nexoAvailable) {
            AdvancementAnnouncer.log("&e[CMD] Nexo format used but plugin not found for item: " + buffedItemId);
            return null;
        }
        try {
            Class<?> nexoItemsClass = Class.forName("com.nexomc.nexo.api.NexoItems");
            Object itemBuilder = nexoItemsClass.getMethod("itemFromId", String.class).invoke(null, externalItemId);
            if (itemBuilder == null) {
                AdvancementAnnouncer.log("&e[CMD] Nexo item not found: " + externalItemId + " (for item: " + buffedItemId + ")");
                return null;
            }
            Object itemStackObj = itemBuilder.getClass().getMethod("build", new Class[0]).invoke(itemBuilder, new Object[0]);
            ItemStack itemStack = (ItemStack)itemStackObj;
            Integer cmd = this.extractCustomModelData(itemStack);
            if (cmd != null) {
                return new ResolvedIconData(cmd, rawValue, ResolvedIconData.Source.NEXO);
            }
            AdvancementAnnouncer.log("&e[CMD] Nexo item '" + externalItemId + "' has no custom model data");
            return null;
        }
        catch (Exception e) {
            AdvancementAnnouncer.log("&c[CMD] Failed to resolve Nexo item for '" + buffedItemId + "': " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    private Integer extractCustomModelData(ItemStack itemStack) {
        if (itemStack == null || !itemStack.hasItemMeta()) {
            return null;
        }
        ItemMeta meta = itemStack.getItemMeta();
        if (meta.hasCustomModelData()) {
            return meta.getCustomModelData();
        }
        return null;
    }

    public boolean isItemsAdderAvailable() {
        return this.itemsAdderAvailable;
    }

    public boolean isNexoAvailable() {
        return this.nexoAvailable;
    }
}

