/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.advancementannouncer;

import com.fren_gor.ultimateAdvancementAPI.AdvancementMain;
import com.fren_gor.ultimateAdvancementAPI.UltimateAdvancementAPI;
import com.fren_gor.ultimateAdvancementAPI.database.impl.SQLite;
import io.github.altkat.advancementannouncer.bukkit.Metrics;
import io.github.altkat.advancementannouncer.cmd.CustomModelDataResolver;
import io.github.altkat.advancementannouncer.core.PlayerData;
import io.github.altkat.advancementannouncer.editor.ChatInputListener;
import io.github.altkat.advancementannouncer.editor.GUIHandler;
import io.github.altkat.advancementannouncer.feature.AutoAnnounce;
import io.github.altkat.advancementannouncer.feature.CommandHandler;
import io.github.altkat.advancementannouncer.feature.JoinListener;
import io.github.altkat.advancementannouncer.util.ConfigUpdater;
import io.github.altkat.advancementannouncer.util.TextUtil;
import io.github.altkat.advancementannouncer.util.UpdateChecker;
import java.io.File;
import java.io.IOException;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class AdvancementAnnouncer
extends JavaPlugin {
    boolean IsPAPIEnabled;
    int version;
    int minorVersion;
    private CustomModelDataResolver cmdResolver;
    private AdvancementMain advancementMain;
    private UltimateAdvancementAPI ultimateAdvancementAPI;
    private boolean useApi = false;
    private String prefix = null;

    public void onLoad() {
        try {
            this.advancementMain = new AdvancementMain((Plugin)this);
            this.advancementMain.load();
        }
        catch (Exception e) {
            AdvancementAnnouncer.log("&e############################################################");
            AdvancementAnnouncer.log("&eWARNING: Failed to load UltimateAdvancementAPI (Shaded).");
            AdvancementAnnouncer.log("&eThis might be due to an unsupported server version.");
            AdvancementAnnouncer.log("&ePlugin will continue to run in legacy mode without CustomModelData support.");
            AdvancementAnnouncer.log("&e############################################################");
        }
    }

    public void onEnable() {
        this.updateConfig();
        String bukkitVersion = Bukkit.getServer().getBukkitVersion();
        String versionString = bukkitVersion.split("\\-")[0];
        String[] versions = versionString.split("\\.");
        this.version = Integer.parseInt(versions[1]);
        int n = this.minorVersion = versions.length > 2 ? Integer.parseInt(versions[2].split("-")[0]) : 0;
        if (this.version < 16) {
            AdvancementAnnouncer.log("&cThis plugin is only compatible with 1.16 and above!, disabling plugin...");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.cmdResolver = new CustomModelDataResolver(this);
        try {
            boolean created;
            File dataFolder;
            if (this.advancementMain == null) {
                AdvancementAnnouncer.log("&eAdvancementMain was null onEnable, attempting reload...");
                this.advancementMain = new AdvancementMain((Plugin)this);
                this.advancementMain.load();
            }
            if (!(dataFolder = new File(this.getDataFolder(), "data")).exists() && !(created = dataFolder.mkdirs())) {
                AdvancementAnnouncer.log("&c############################################################");
                AdvancementAnnouncer.log("&cCRITICAL: Could not create the '/data/' folder.");
                AdvancementAnnouncer.log("&cPlease check file permissions or delete any 'data' file.");
                AdvancementAnnouncer.log("&cAPI will not be loaded. Falling back to legacy mode.");
                AdvancementAnnouncer.log("&c############################################################");
                throw new IOException("Failed to create data folder.");
            }
            File databaseFile = new File(dataFolder, "uadb.db");
            this.advancementMain.enable(() -> new SQLite(this.advancementMain, databaseFile));
            this.ultimateAdvancementAPI = UltimateAdvancementAPI.getInstance((Plugin)this);
            this.useApi = true;
            AdvancementAnnouncer.log("&aCustomModelData (CMD) support is active.");
            this.cmdResolver.detectExternalPlugins();
        }
        catch (Exception e) {
            AdvancementAnnouncer.log("&e############################################################");
            AdvancementAnnouncer.log("&eWARNING: Failed to enable UltimateAdvancementAPI (Shaded).");
            AdvancementAnnouncer.log("&eYour server version might be incompatible with this shaded version of UAPI.");
            AdvancementAnnouncer.log("&ePlugin is falling back to 'legacy' mode without CustomModelData support.");
            AdvancementAnnouncer.log("&e############################################################");
            this.useApi = false;
        }
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            this.IsPAPIEnabled = true;
            AdvancementAnnouncer.log("&aPlaceholderAPI found! Enabling placeholder support...");
        }
        new PlayerData(this);
        CommandHandler commandHandler = new CommandHandler();
        this.getCommand("advancementannouncer").setExecutor((CommandExecutor)commandHandler);
        this.getCommand("advancementannouncer").setTabCompleter((TabCompleter)commandHandler);
        this.getServer().getPluginManager().registerEvents((Listener)new GUIHandler(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ChatInputListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new JoinListener(), (Plugin)this);
        AutoAnnounce.startAutoAnnounce();
        int pluginId = 24282;
        new Metrics(this, pluginId);
        new UpdateChecker(this, "altkat/AdvancementAnnouncer").checkAsync();
        AdvancementAnnouncer.log("&aPlugin has been enabled!");
    }

    private void updateConfig() {
        this.saveDefaultConfig();
        try {
            ConfigUpdater.update(this);
            this.reloadConfig();
            this.clearPrefixCache();
        }
        catch (IOException e) {
            AdvancementAnnouncer.log("&cCould not update config.yml!");
            e.printStackTrace();
        }
    }

    public void onDisable() {
        if (this.advancementMain != null) {
            this.advancementMain.disable();
        }
        AdvancementAnnouncer.log("&cPlugin has been disabled!");
    }

    public static void log(String message) {
        String prefix = "&#7688FF[Advancement Announcer] &r";
        Bukkit.getConsoleSender().sendMessage(TextUtil.color(prefix + message));
    }

    public static AdvancementAnnouncer getInstance() {
        return (AdvancementAnnouncer)AdvancementAnnouncer.getPlugin(AdvancementAnnouncer.class);
    }

    public boolean isPAPIEnabled() {
        return this.IsPAPIEnabled;
    }

    public int getVersion() {
        return this.version;
    }

    public boolean isModernVersion() {
        if (this.version > 20) {
            return true;
        }
        return this.version == 20 && this.minorVersion >= 5;
    }

    public CustomModelDataResolver getCmdResolver() {
        return this.cmdResolver;
    }

    public UltimateAdvancementAPI getAdvancementAPI() {
        return this.ultimateAdvancementAPI;
    }

    public boolean isApiAvailable() {
        return this.useApi;
    }

    public String getPrefix() {
        if (this.prefix == null) {
            String configPrefix = this.getConfig().getString("lang-messages.plugin-prefix", "&#7688FF[Advancement Announcer] &r");
            this.prefix = TextUtil.color(configPrefix);
        }
        return this.prefix;
    }

    public void clearPrefixCache() {
        this.prefix = null;
    }
}

