/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.advancementannouncer.guis;

import io.github.altkat.advancementannouncer.AdvancementAnnouncer;
import io.github.altkat.advancementannouncer.Handlers.GUIHandler;
import io.github.altkat.advancementannouncer.guis.ConfirmationGUI;
import io.github.altkat.advancementannouncer.guis.EditorGUI;
import io.github.altkat.advancementannouncer.guis.MainMenuGUI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class PresetsGUI {
    private static final AdvancementAnnouncer plugin = AdvancementAnnouncer.getInstance();
    private static final int SLOT_BACK_BUTTON = 45;
    private static final int SLOT_ADD_ITEM = 53;

    public static void open(Player player) {
        Inventory gui = Bukkit.createInventory(null, (int)54, (String)ChatColor.translateAlternateColorCodes((char)'&', (String)plugin.getConfig().getString("lang-messages.presets-gui-title")));
        ConfigurationSection presetsSection = plugin.getConfig().getConfigurationSection("presets");
        if (presetsSection != null) {
            for (String key : presetsSection.getKeys(false)) {
                Material iconMaterial;
                ConfigurationSection preset = presetsSection.getConfigurationSection(key);
                if (preset == null) continue;
                String iconStr = preset.getString("icon", "PAPER");
                try {
                    iconMaterial = Material.valueOf((String)iconStr.toUpperCase());
                }
                catch (Exception e) {
                    iconMaterial = Material.PAPER;
                }
                ItemStack item = new ItemStack(iconMaterial);
                ItemMeta meta = item.getItemMeta();
                meta.setDisplayName(String.valueOf(ChatColor.GREEN) + key);
                ArrayList<String> lore = new ArrayList<String>();
                lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)"&f&nCurrent Message:"));
                lore.add(" ");
                PresetsGUI.addFormattedMessage(lore, preset.getString("message"));
                lore.add(" ");
                lore.add(String.valueOf(ChatColor.GRAY) + "Style: " + String.valueOf(ChatColor.WHITE) + preset.getString("style", "GOAL"));
                lore.add(" ");
                lore.add(String.valueOf(ChatColor.YELLOW) + "Left click to edit this preset.");
                lore.add(String.valueOf(ChatColor.RED) + "Right click to delete this preset.");
                meta.setLore(lore);
                item.setItemMeta(meta);
                gui.addItem(new ItemStack[]{item});
            }
        }
        ItemStack backItem = new ItemStack(Material.BARRIER);
        ItemMeta backMeta = backItem.getItemMeta();
        backMeta.setDisplayName(String.valueOf(ChatColor.RED) + "Back");
        backItem.setItemMeta(backMeta);
        gui.setItem(45, backItem);
        ItemStack addItem = new ItemStack(Material.EMERALD);
        ItemMeta addMeta = addItem.getItemMeta();
        addMeta.setDisplayName(String.valueOf(ChatColor.GREEN) + "Add Preset");
        addItem.setItemMeta(addMeta);
        gui.setItem(53, addItem);
        player.openInventory(gui);
    }

    public static void handleClick(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        ItemStack clickedItem = event.getCurrentItem();
        int slot = event.getSlot();
        if (slot == 45) {
            MainMenuGUI.open(player);
            return;
        }
        if (slot == 53) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("isCreator", true);
            data.put("type", "preset");
            data.put("name", "<not set>");
            data.put("message", "Default message");
            data.put("style", "GOAL");
            data.put("icon", "GRASS_BLOCK");
            EditorGUI.open(player, data);
            return;
        }
        if (clickedItem != null && clickedItem.getType() != Material.AIR && slot < 45) {
            if (!clickedItem.hasItemMeta() || !clickedItem.getItemMeta().hasDisplayName()) {
                return;
            }
            String presetName = ChatColor.stripColor((String)clickedItem.getItemMeta().getDisplayName());
            if (!plugin.getConfig().contains("presets." + presetName)) {
                return;
            }
            if (event.isRightClick()) {
                ConfirmationGUI.open(player, presetName);
                GUIHandler.confirmationActions.put(player.getUniqueId(), () -> {
                    plugin.getConfig().set("presets." + presetName, null);
                    plugin.saveConfig();
                    player.sendMessage(String.valueOf(ChatColor.GREEN) + "Preset '" + presetName + "' has been deleted.");
                    PresetsGUI.open(player);
                });
            } else if (event.isLeftClick()) {
                ConfigurationSection preset = plugin.getConfig().getConfigurationSection("presets." + presetName);
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("isCreator", false);
                data.put("originalName", presetName);
                data.put("type", "preset");
                data.put("name", presetName);
                data.put("message", preset.getString("message"));
                data.put("style", preset.getString("style", "GOAL"));
                data.put("icon", preset.getString("icon", "STONE"));
                EditorGUI.open(player, data);
            }
        }
    }

    private static void addFormattedMessage(List<String> lore, String message) {
        if (message != null && message.contains("|")) {
            for (String line : message.split("\\|")) {
                lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)line));
            }
        } else if (message != null) {
            lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)message));
        }
    }
}

