/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.advancementannouncer.Handlers;

import io.github.altkat.advancementannouncer.AdvancementAnnouncer;
import io.github.altkat.advancementannouncer.Handlers.AdvancementHandler;
import io.github.altkat.advancementannouncer.PlayerData;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;

public class JoinListener
implements Listener {
    private final AdvancementAnnouncer plugin = AdvancementAnnouncer.getInstance();

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (!PlayerData.returnToggleData(player.getUniqueId())) {
            return;
        }
        String basePath = "join-features." + (player.hasPlayedBefore() ? "join-messages" : "first-join-messages");
        if (!this.plugin.getConfig().getBoolean(basePath + ".enabled")) {
            return;
        }
        ConfigurationSection messagesSection = this.plugin.getConfig().getConfigurationSection(basePath + ".messages");
        if (messagesSection == null) {
            return;
        }
        Set keys = messagesSection.getKeys(false);
        if (keys.isEmpty()) {
            return;
        }
        ArrayList keyList = new ArrayList(keys);
        String randomKey = (String)keyList.get(ThreadLocalRandom.current().nextInt(keyList.size()));
        String messagePath = basePath + ".messages." + randomKey;
        String message = this.plugin.getConfig().getString(messagePath + ".message");
        String styleString = this.plugin.getConfig().getString(messagePath + ".style", "GOAL").toUpperCase();
        String iconString = this.plugin.getConfig().getString(messagePath + ".icon", "STONE").toUpperCase();
        try {
            AdvancementHandler.Style style = AdvancementHandler.Style.valueOf(styleString);
            Material icon = Material.valueOf((String)iconString);
            this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                if (player.isOnline()) {
                    AdvancementHandler.displayTo(player, icon.name().toLowerCase(), message, style);
                }
            }, 20L);
        }
        catch (IllegalArgumentException e) {
            this.plugin.getLogger().warning("Invalid style or icon in join messages configuration: " + randomKey);
        }
    }
}

