/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.advancementannouncer.Handlers;

import io.github.altkat.advancementannouncer.AdvancementAnnouncer;
import io.github.altkat.advancementannouncer.guis.AutoAnnounceGUI;
import io.github.altkat.advancementannouncer.guis.ConfirmationGUI;
import io.github.altkat.advancementannouncer.guis.EditorGUI;
import io.github.altkat.advancementannouncer.guis.IconSelectionGUI;
import io.github.altkat.advancementannouncer.guis.JoinFeaturesGUI;
import io.github.altkat.advancementannouncer.guis.JoinMessageListGUI;
import io.github.altkat.advancementannouncer.guis.MainMenuGUI;
import io.github.altkat.advancementannouncer.guis.PresetsGUI;
import io.github.altkat.advancementannouncer.guis.StyleSelectionGUI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.plugin.Plugin;

public class GUIHandler
implements Listener {
    private final AdvancementAnnouncer plugin = AdvancementAnnouncer.getInstance();
    public static final Map<UUID, Runnable> confirmationActions = new HashMap<UUID, Runnable>();
    private final Set<UUID> isNavigating = new HashSet<UUID>();

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        String title = event.getView().getTitle();
        Player player = (Player)event.getWhoClicked();
        if (!this.isRelevantGUI(title)) {
            return;
        }
        event.setCancelled(true);
        if (event.getCurrentItem() == null || event.getCurrentItem().getType().isAir()) {
            return;
        }
        if (this.isNavigating.contains(player.getUniqueId())) {
            return;
        }
        this.isNavigating.add(player.getUniqueId());
        this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> this.isNavigating.remove(player.getUniqueId()), 5L);
        if (title.equals(ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getConfig().getString("lang-messages.edit-gui-title")))) {
            MainMenuGUI.handleClick(event);
        } else if (title.equals(ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getConfig().getString("lang-messages.presets-gui-title")))) {
            PresetsGUI.handleClick(event);
        } else if (title.equals(ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getConfig().getString("lang-messages.auto-announce-gui-title")))) {
            AutoAnnounceGUI.handleClick(event);
        } else if (title.contains("Join Features") || title.contains("Join Messages")) {
            if (title.contains("Join Features")) {
                JoinFeaturesGUI.handleClick(event);
            } else {
                JoinMessageListGUI.handleClick(event);
            }
        } else if (title.startsWith("Editing ") || title.startsWith("Creating ")) {
            EditorGUI.handleClick(event);
        } else if (title.equals("Select a Style")) {
            StyleSelectionGUI.handleClick(event);
        } else if (title.startsWith("Select an Icon")) {
            IconSelectionGUI.handleClick(event);
        } else if (title.equals("Confirm Deletion")) {
            ConfirmationGUI.handleClick(event);
        }
    }

    private boolean isRelevantGUI(String title) {
        return title.equals(ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getConfig().getString("lang-messages.edit-gui-title"))) || title.equals(ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getConfig().getString("lang-messages.presets-gui-title"))) || title.equals(ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getConfig().getString("lang-messages.auto-announce-gui-title"))) || title.contains("Join Features") || title.contains("Join Messages") || title.startsWith("Editing ") || title.startsWith("Creating ") || title.equals("Select a Style") || title.startsWith("Select an Icon") || title.equals("Confirm Deletion");
    }
}

