/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.advancementannouncer.Handlers;

import com.google.common.base.Charsets;
import io.github.altkat.advancementannouncer.AdvancementAnnouncer;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigUpdater {
    public static void update(AdvancementAnnouncer plugin) throws IOException {
        ConfigUpdater.migratePresets(plugin);
        File configFile = new File(plugin.getDataFolder(), "config.yml");
        YamlConfiguration defaultConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(plugin.getResource("config.yml"), Charsets.UTF_8));
        YamlConfiguration userConfig = YamlConfiguration.loadConfiguration((File)configFile);
        userConfig.options().copyHeader(true);
        userConfig.options().header(defaultConfig.options().header());
        for (String key : defaultConfig.getKeys(true)) {
            if (key.startsWith("presets.") || key.startsWith("auto-announce.messages.") || key.startsWith("join-features.join-messages.messages.") || key.startsWith("join-features.first-join-messages.messages.") || userConfig.contains(key)) continue;
            userConfig.set(key, defaultConfig.get(key));
        }
        if (!userConfig.contains("presets")) {
            userConfig.createSection("presets");
        }
        if (!userConfig.contains("auto-announce.messages")) {
            userConfig.createSection("auto-announce.messages");
        }
        if (!userConfig.contains("join-features.join-messages.messages")) {
            userConfig.createSection("join-features.join-messages.messages");
        }
        if (!userConfig.contains("join-features.first-join-messages.messages")) {
            userConfig.createSection("join-features.first-join-messages.messages");
        }
        userConfig.save(configFile);
    }

    private static void migratePresets(AdvancementAnnouncer plugin) {
        FileConfiguration config = plugin.getConfig();
        ConfigurationSection presets = config.getConfigurationSection("presets");
        if (presets == null) {
            return;
        }
        boolean migrated = false;
        boolean backupCreated = false;
        for (String key : presets.getKeys(false)) {
            if (!presets.isString(key)) continue;
            if (!backupCreated) {
                ConfigUpdater.createBackup(plugin);
                backupCreated = true;
            }
            String oldMessage = presets.getString(key);
            presets.set(key, null);
            ConfigurationSection newSection = presets.createSection(key);
            newSection.set("message", (Object)oldMessage);
            newSection.set("style", (Object)"GOAL");
            newSection.set("icon", (Object)"PAPER");
            plugin.getLogger().info("Migrated legacy preset to new format: " + key);
            migrated = true;
        }
        if (migrated) {
            plugin.saveConfig();
            plugin.reloadConfig();
        }
    }

    private static void createBackup(AdvancementAnnouncer plugin) {
        try {
            File configFile = new File(plugin.getDataFolder(), "config.yml");
            File backupFile = new File(plugin.getDataFolder(), "config.yml.backup");
            Files.copy(configFile.toPath(), backupFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            plugin.getLogger().info("Created backup of config.yml before migration.");
        }
        catch (IOException e) {
            plugin.getLogger().warning("Failed to create config backup: " + e.getMessage());
        }
    }
}

