/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.advancementannouncer.Handlers;

import io.github.altkat.advancementannouncer.AdvancementAnnouncer;
import io.github.altkat.advancementannouncer.Handlers.AdvancementHandler;
import io.github.altkat.advancementannouncer.Handlers.AutoAnnounce;
import io.github.altkat.advancementannouncer.PlayerData;
import io.github.altkat.advancementannouncer.guis.MainMenuGUI;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class CommandHandler
implements CommandExecutor,
TabCompleter {
    AdvancementAnnouncer plugin = AdvancementAnnouncer.getInstance();

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length > 0 && args[0].equalsIgnoreCase("edit")) {
            if (sender instanceof Player) {
                if (sender.hasPermission("advancementannouncer.admin")) {
                    MainMenuGUI.open((Player)sender);
                } else {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
                }
            } else {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "You must be a player to use this command!");
            }
            return true;
        }
        if (!sender.hasPermission("advancementannouncer.admin")) {
            if (args.length != 1 || !args[0].equalsIgnoreCase("toggle")) {
                sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getConfig().getString("lang-messages.wrong-usage")));
                return true;
            }
            if (!sender.hasPermission("advancementannouncer.toggle")) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
                return true;
            }
            this.handleToggle(sender);
            return true;
        }
        if (args.length == 0) {
            this.sendHelpMessage(sender);
            return true;
        }
        if (args[0].equalsIgnoreCase("toggle")) {
            if (!sender.hasPermission("advancementannouncer.toggle")) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
                return true;
            }
            this.handleToggle(sender);
            return true;
        }
        if (args[0].equalsIgnoreCase("reload")) {
            AutoAnnounce.stopAutoAnnounce();
            this.plugin.reloadConfig();
            AutoAnnounce.startAutoAnnounce();
            PlayerData.reloadPlayerData();
            sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getConfig().getString("lang-messages.config-reloaded")));
            return true;
        }
        if (args[0].equalsIgnoreCase("send")) {
            this.handleSendCommand(sender, args);
            return true;
        }
        this.sendHelpMessage(sender);
        return true;
    }

    private void handleToggle(CommandSender sender) {
        UUID playerUUID;
        if (!(sender instanceof Player)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "You must be a player to use this command!");
            return;
        }
        PlayerData.setToggleData(playerUUID, !PlayerData.returnToggleData(playerUUID = ((Player)sender).getUniqueId()));
        if (PlayerData.returnToggleData(playerUUID)) {
            sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getConfig().getString("lang-messages.announcements-toggled-on")));
        } else {
            sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getConfig().getString("lang-messages.announcements-toggled-off")));
        }
    }

    private void handleSendCommand(CommandSender sender, String[] args) {
        if (args.length < 2) {
            this.sendHelpMessage(sender);
            return;
        }
        if (args[1].equalsIgnoreCase("preset")) {
            AdvancementHandler.Style style;
            String iconStr;
            String styleStr;
            String message;
            if (args.length < 4) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /aa send preset <presetName> <target>");
                return;
            }
            String presetName = args[2];
            String targetName = args[3];
            ConfigurationSection presetSection = this.plugin.getConfig().getConfigurationSection("presets." + presetName);
            if (presetSection == null) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Preset not found: " + presetName);
                return;
            }
            if (this.plugin.getConfig().isConfigurationSection("presets." + presetName)) {
                message = presetSection.getString("message");
                styleStr = presetSection.getString("style", "GOAL");
                iconStr = presetSection.getString("icon", "STONE");
            } else {
                message = this.plugin.getConfig().getString("presets." + presetName);
                styleStr = "GOAL";
                iconStr = "PAPER";
            }
            try {
                style = AdvancementHandler.Style.valueOf(styleStr.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                style = AdvancementHandler.Style.GOAL;
            }
            this.sendToTarget(sender, targetName, message, style, iconStr);
            return;
        }
        if (args.length >= 5) {
            AdvancementHandler.Style style;
            try {
                style = AdvancementHandler.Style.valueOf(args[1].toUpperCase());
            }
            catch (IllegalArgumentException t) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Invalid style or option: " + args[1]);
                sender.sendMessage(String.valueOf(ChatColor.GRAY) + "Did you mean '/aa send preset'?");
                return;
            }
            String materialName = args[2];
            try {
                Material.valueOf((String)materialName.toUpperCase());
            }
            catch (IllegalArgumentException t) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Invalid material: " + materialName);
                return;
            }
            String targetName = args[3];
            String message = "";
            String potentialPresetName = args[4];
            if (this.plugin.getConfig().isConfigurationSection("presets." + potentialPresetName)) {
                message = this.plugin.getConfig().getString("presets." + potentialPresetName + ".message");
            } else if (this.plugin.getConfig().isString("presets." + potentialPresetName)) {
                message = this.plugin.getConfig().getString("presets." + potentialPresetName);
            } else {
                StringBuilder messageBuilder = new StringBuilder();
                for (int i = 4; i < args.length; ++i) {
                    messageBuilder.append(args[i]).append(" ");
                }
                message = messageBuilder.toString().trim();
            }
            if (message == null || message.isEmpty()) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Could not find message for preset or custom input.");
                return;
            }
            this.sendToTarget(sender, targetName, message, style, materialName);
            return;
        }
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Usage 1: /aa send preset <presetName> <target>");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Usage 2: /aa send <style> <icon> <target> <message/presetName>");
    }

    private void sendToTarget(CommandSender sender, String targetName, String message, AdvancementHandler.Style style, String icon) {
        if (targetName.equalsIgnoreCase("all")) {
            if (sender.getServer().getOnlinePlayers().isEmpty()) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "There are no online players in the server!");
                return;
            }
            int sentCount = 0;
            for (Player player : sender.getServer().getOnlinePlayers()) {
                if (!PlayerData.returnToggleData(player.getUniqueId())) continue;
                AdvancementHandler.displayTo(player, icon.toLowerCase(), message, style);
                ++sentCount;
            }
            sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)("&3[AdvancementAnnouncer] &aAdvancement message sent to " + sentCount + " player(s)")));
        } else {
            Player player = sender.getServer().getPlayer(targetName);
            if (player == null) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Player not found: " + targetName);
                return;
            }
            AdvancementHandler.displayTo(player, icon.toLowerCase(), message, style);
            sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)("&3[AdvancementAnnouncer] &aAdvancement message sent to " + player.getName())));
        }
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        ArrayList<String> tab = new ArrayList<String>();
        if (!sender.hasPermission("advancementannouncer.admin")) {
            if (args.length == 1) {
                tab.add("toggle");
            }
            return tab;
        }
        if (args.length == 1) {
            tab.add("reload");
            tab.add("toggle");
            tab.add("edit");
            tab.add("send");
            return this.filter(tab, args);
        }
        if (args[0].equalsIgnoreCase("send")) {
            switch (args.length) {
                case 2: {
                    tab.add("preset");
                    for (AdvancementHandler.Style style : AdvancementHandler.Style.values()) {
                        tab.add(style.toString().toLowerCase());
                    }
                    break;
                }
                case 3: {
                    if (args[1].equalsIgnoreCase("preset")) {
                        if (this.plugin.getConfig().getConfigurationSection("presets") == null) break;
                        tab.addAll(this.plugin.getConfig().getConfigurationSection("presets").getKeys(false));
                        break;
                    }
                    if (!this.isStyle(args[1])) break;
                    for (Material material : Material.values()) {
                        if (!material.isItem() || material == Material.AIR) continue;
                        tab.add(material.toString().toLowerCase());
                    }
                    break;
                }
                case 4: {
                    tab.add("all");
                    for (Player player : sender.getServer().getOnlinePlayers()) {
                        tab.add(player.getName());
                    }
                    break;
                }
                case 5: {
                    if (!this.isStyle(args[1])) break;
                    if (this.plugin.getConfig().getConfigurationSection("presets") != null) {
                        tab.addAll(this.plugin.getConfig().getConfigurationSection("presets").getKeys(false));
                    }
                    tab.add("<message>");
                }
            }
        }
        return this.filter(tab, args);
    }

    private List<String> filter(List<String> list, String[] args) {
        return list.stream().filter(completion -> completion.toLowerCase().startsWith(args[args.length - 1].toLowerCase())).collect(Collectors.toList());
    }

    private boolean isStyle(String arg) {
        try {
            AdvancementHandler.Style.valueOf(arg.toUpperCase());
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private void sendHelpMessage(CommandSender sender) {
        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&3[AdvancementAnnouncer] &aCommands: "));
        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&7- &a/aa send preset <presetName> <player/all>"));
        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&7- &a/aa send <style> <material> <player/all> <message/presetName>"));
        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&7- &a/aa reload"));
        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&7- &a/aa toggle"));
        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&7- &a/aa edit"));
    }
}

