/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.advancementannouncer.Handlers;

import io.github.altkat.advancementannouncer.AdvancementAnnouncer;
import io.github.altkat.advancementannouncer.Handlers.AdvancementHandler;
import io.github.altkat.advancementannouncer.Handlers.AutoAnnounce;
import io.github.altkat.advancementannouncer.guis.AutoAnnounceGUI;
import io.github.altkat.advancementannouncer.guis.EditorGUI;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.Plugin;

public class ChatInputListener
implements Listener {
    private final AdvancementAnnouncer plugin = AdvancementAnnouncer.getInstance();
    public static final Map<UUID, Map<String, Object>> activeSessions = new HashMap<UUID, Map<String, Object>>();
    public static final String STEP_NAME = "name";
    public static final String STEP_MESSAGE = "message";
    public static final String STEP_STYLE = "style";
    public static final String STEP_ICON = "icon";
    public static final String STEP_INTERVAL = "interval";

    @EventHandler
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        UUID playerUUID = player.getUniqueId();
        if (!activeSessions.containsKey(playerUUID)) {
            return;
        }
        Map<String, Object> data = activeSessions.get(playerUUID);
        if (!data.containsKey("step")) {
            return;
        }
        event.setCancelled(true);
        String message = event.getMessage();
        if (message.equalsIgnoreCase("cancel")) {
            data.remove("step");
            player.sendMessage(String.valueOf(ChatColor.RED) + "Input cancelled.");
            if (!data.containsKey("type")) {
                activeSessions.remove(playerUUID);
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> AutoAnnounceGUI.open(player));
            } else {
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> EditorGUI.open(player, data));
            }
            return;
        }
        String step = (String)data.get("step");
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            switch (step) {
                case "name": {
                    if (message.contains(".") || message.contains(" ")) {
                        player.sendMessage(String.valueOf(ChatColor.RED) + "The name cannot contain periods or spaces. Please try again.");
                        return;
                    }
                    data.put(STEP_NAME, message);
                    player.sendMessage(String.valueOf(ChatColor.GREEN) + "Name set to '" + message + "'");
                    break;
                }
                case "message": {
                    data.put(STEP_MESSAGE, message);
                    player.sendMessage(String.valueOf(ChatColor.GREEN) + "Message updated!");
                    break;
                }
                case "style": {
                    try {
                        AdvancementHandler.Style.valueOf(message.toUpperCase());
                        data.put(STEP_STYLE, message.toUpperCase());
                        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Style set to " + message.toUpperCase());
                        break;
                    }
                    catch (IllegalArgumentException e) {
                        player.sendMessage(String.valueOf(ChatColor.RED) + "Invalid style! Please use GOAL, TASK, or CHALLENGE.");
                        return;
                    }
                }
                case "icon": {
                    try {
                        Material.valueOf((String)message.toUpperCase());
                        data.put(STEP_ICON, message.toUpperCase());
                        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Icon set to " + message.toUpperCase());
                        break;
                    }
                    catch (IllegalArgumentException e) {
                        player.sendMessage(String.valueOf(ChatColor.RED) + "Invalid material name! Please try again.");
                        return;
                    }
                }
                case "interval": {
                    try {
                        int interval = Integer.parseInt(message);
                        this.plugin.getConfig().set("auto-announce.interval", (Object)interval);
                        this.plugin.saveConfig();
                        AutoAnnounce.stopAutoAnnounce();
                        AutoAnnounce.startAutoAnnounce();
                        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Interval has been set to " + interval + " seconds.");
                        activeSessions.remove(playerUUID);
                        AutoAnnounceGUI.open(player);
                        return;
                    }
                    catch (NumberFormatException e) {
                        player.sendMessage(String.valueOf(ChatColor.RED) + "Invalid number. Please type a valid interval in seconds. Type 'cancel' to exit.");
                        return;
                    }
                }
            }
            data.remove("step");
            EditorGUI.open(player, data);
        });
    }
}

